/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PopulatorPostProcessor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OSGiModuleImpl;

public class OsgiPopulatorPostProcessor
implements PopulatorPostProcessor {
    public static final String BUNDLE_VERSION = "Bundle-Version";
    public static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private final OSGiModuleImpl osgiModule;
    private final HK2Loader loader;

    OsgiPopulatorPostProcessor(OSGiModuleImpl paramOsgiModule) {
        this.osgiModule = paramOsgiModule;
        this.loader = new HK2Loader(){

            public Class<?> loadClass(final String className) throws MultiException {
                OsgiPopulatorPostProcessor.this.osgiModule.start();
                return (Class)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return OsgiPopulatorPostProcessor.this.osgiModule.getBundle().loadClass(className);
                        }
                        catch (Throwable e) {
                            Logger.logger.logp(Level.SEVERE, "OSGiModuleImpl", "loadClass", "Exception in module " + OsgiPopulatorPostProcessor.this.osgiModule.getBundle().toString(), e);
                            throw new MultiException(e);
                        }
                    }
                });
            }

            public String toString() {
                return "OsgiPopulatorPostProcessor.HK2Loader(" + OsgiPopulatorPostProcessor.this.osgiModule + "," + System.identityHashCode(this) + ")";
            }
        };
    }

    public DescriptorImpl process(ServiceLocator serviceLocator, DescriptorImpl descriptorImpl) {
        descriptorImpl.setLoader(this.loader);
        descriptorImpl.addMetadata(BUNDLE_SYMBOLIC_NAME, this.osgiModule.getBundle().getSymbolicName());
        descriptorImpl.addMetadata(BUNDLE_VERSION, this.osgiModule.getBundle().getVersion().toString());
        return descriptorImpl;
    }
}

