/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.httptunnel.tunnel.server;

import com.sun.messaging.jmq.httptunnel.api.server.HttpsTunnelServerDriver;
import com.sun.messaging.jmq.httptunnel.tunnel.server.DefaultTrustManager;
import com.sun.messaging.jmq.httptunnel.tunnel.server.HttpTunnelServerDriverImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class HttpsTunnelServerDriverImpl
extends HttpTunnelServerDriverImpl
implements HttpsTunnelServerDriver {
    private static boolean DEBUG = HttpsTunnelServerDriverImpl.getDEBUG();
    private static Logger logger = Logger.getLogger("Http Tunneling");
    protected boolean trustServlet = true;
    private boolean poodleFixEnabled = true;

    @Override
    public void init(String serviceName, boolean trust, boolean poodleFixEnabled) throws IOException {
        this.init(serviceName, InetAddress.getLocalHost().getHostAddress(), 7674, trust, poodleFixEnabled);
    }

    @Override
    public void init(String serviceName, String webServerHostName, int webServerPort, boolean trust, boolean poodleFixEnabled) throws IOException {
        super.init(serviceName, webServerHostName, webServerPort);
        this.trustServlet = trust;
        this.setName("HttpsTunnelServerDriver");
        this.poodleFixEnabled = poodleFixEnabled;
        if (DEBUG || DEBUGLINK) {
            this.log("Created HttpsTunnelServerDriver for " + serviceName + " to " + webServerHostName + ":" + webServerPort + ", poodleFixEnabled=" + poodleFixEnabled);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void createLink() {
        this.totalRetryWaited = 0;
        if (DEBUG) {
            this.log("http:connecting to " + String.valueOf(this.webServerHost) + ":" + this.webServerPort);
        }
        while (true) {
            try {
                this.serverConn = this.rxBufSize > 0 ? HttpsTunnelServerDriverImpl.getSSLSocket(this.webServerHost, this.webServerPort, this.rxBufSize, this.trustServlet) : HttpsTunnelServerDriverImpl.getSSLSocket(this.webServerHost, this.webServerPort, this.trustServlet);
                if (this.poodleFixEnabled) {
                    assert (this.serverConn instanceof SSLSocket) : this.serverConn.getClass();
                    HttpsTunnelServerDriverImpl.applyPoodleFix((SSLSocket)this.serverConn);
                }
                try {
                    this.serverConn.setTcpNoDelay(true);
                }
                catch (SocketException e) {
                    this.log(Level.WARNING, "HTTPS socket[" + String.valueOf(this.webServerHost) + ":" + this.webServerPort + "]setTcpNoDelay: " + String.valueOf(e), e);
                }
                if (DEBUG) {
                    this.log("######## rcvbuf = " + this.serverConn.getReceiveBufferSize());
                }
                this.is = this.serverConn.getInputStream();
                this.os = this.serverConn.getOutputStream();
                if (DEBUG || DEBUGLINK) {
                    this.log("Broker HTTPS link up");
                }
                this.totalRetryWaited = 0;
            }
            catch (Exception e) {
                if (DEBUG || DEBUGLINK) {
                    this.log("Got exception while connecting to servlet: " + e.getMessage());
                }
                try {
                    Thread.sleep(5000L);
                    this.totalRetryWaited += 5000;
                    if (this.totalRetryWaited < this.inactiveConnAbortInterval * 1000) continue;
                    if (DEBUG || DEBUGLINK) {
                        this.log("Retry connect to servlet timeout - cleanup all (" + this.connTable.size() + ") connections and stop retry ...");
                    }
                    this.cleanupAllConns();
                    this.totalRetryWaited = 0;
                    continue;
                }
                catch (Exception se) {
                    if (se instanceof IllegalStateException) throw (IllegalStateException)se;
                    continue;
                }
            }
            break;
        }
        this.sendLinkInitPacket();
        this.sendListenStatePacket();
    }

    private static SSLSocket getSSLSocket(InetAddress host, int port, boolean trust) throws IOException {
        if (DEBUG || DEBUGLINK) {
            logger.log(Level.INFO, "Creating SSL Socket...");
        }
        try {
            SSLSocketFactory factory = null;
            factory = trust ? HttpsTunnelServerDriverImpl.getTrustedSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault();
            SSLSocket s = (SSLSocket)factory.createSocket(host, port);
            return s;
        }
        catch (Exception e) {
            if (!(e instanceof IOException)) {
                IOException ex = new IOException(e.getMessage());
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
            throw (IOException)e;
        }
    }

    private static SSLSocket getSSLSocket(InetAddress host, int port, int rxBufSize, boolean trust) throws IOException {
        if (DEBUG || DEBUGLINK) {
            logger.log(Level.INFO, "Creating SSL Socket with rxBufSize...");
        }
        try {
            SSLSocketFactory factory = null;
            factory = trust ? HttpsTunnelServerDriverImpl.getTrustedSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault();
            SSLSocket s = (SSLSocket)factory.createSocket();
            try {
                s.setReceiveBufferSize(rxBufSize);
            }
            catch (SocketException e) {
                logger.log(Level.WARNING, "HTTPS socket[" + String.valueOf(host) + ":" + port + "]setReceiveBufferSize(" + rxBufSize + "): " + String.valueOf(e), e);
            }
            InetSocketAddress addr = new InetSocketAddress(host, port);
            s.connect(addr);
            return s;
        }
        catch (Exception e) {
            if (!(e instanceof IOException)) {
                IOException ex = new IOException(e.getMessage());
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
            throw (IOException)e;
        }
    }

    private static SSLSocketFactory getTrustedSocketFactory() throws Exception {
        SSLContext ctx = SSLContext.getInstance("TLS");
        TrustManager[] tm = new TrustManager[]{new DefaultTrustManager()};
        ctx.init(null, tm, null);
        SSLSocketFactory factory = ctx.getSocketFactory();
        return factory;
    }

    public static void applyPoodleFix(SSLSocket sslSocket) {
        Object[] protocols = sslSocket.getEnabledProtocols();
        String orig = Arrays.toString(protocols);
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        for (Object s : protocols) {
            if (((String)s).equals("SSLv3") || ((String)s).equals("SSLv2Hello")) continue;
            set.add(s);
        }
        logger.log(Level.INFO, "[HttpsTunnelServerDriver]: [" + orig + "], setEnabledProtocols[" + String.valueOf(set) + "]");
        sslSocket.setEnabledProtocols(set.toArray(new String[set.size()]));
    }
}

