/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.ResultSet;
import java.util.Properties;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.DMLVTIResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.shared.common.error.StandardException;

class UpdateVTIResultSet
extends DMLVTIResultSet {
    private ResultSet rs;
    private TemporaryRowHolderImpl rowHolder;

    public UpdateVTIResultSet(NoPutResultSet noPutResultSet, Activation activation) throws StandardException {
        super(noPutResultSet, activation);
    }

    @Override
    protected void openCore() throws StandardException {
        Object object;
        int n = -1;
        boolean bl = true;
        this.rs = this.activation.getTargetVTI();
        ExecRow execRow = this.getNextRowCore(this.sourceResultSet);
        if (null != execRow) {
            n = execRow.nColumns();
        }
        if (this.constants.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (null == this.rowHolder && this.constants.deferred) {
            object = new Properties();
            this.rowHolder = new TemporaryRowHolderImpl(this.activation, (Properties)object, this.resultDescription);
        }
        try {
            while (execRow != null) {
                if (this.constants.deferred) {
                    if (bl) {
                        execRow.getColumn(n).setValue(this.rs.getRow());
                        bl = false;
                    } else {
                        object = execRow.cloneColumn(n);
                        object.setValue(this.rs.getRow());
                        execRow.setColumn(n, (DataValueDescriptor)object);
                    }
                    this.rowHolder.insert(execRow);
                } else {
                    this.updateVTI(this.rs, execRow);
                }
                ++this.rowCount;
                if (this.constants.singleRowSource) {
                    execRow = null;
                    continue;
                }
                execRow = this.getNextRowCore(this.sourceResultSet);
            }
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
        if (this.constants.deferred) {
            object = this.rowHolder.getResultSet();
            try {
                object.open();
                while ((execRow = object.getNextRow()) != null) {
                    int n2 = execRow.getColumn(n).getInt();
                    this.rs.absolute(n2);
                    this.updateVTI(this.rs, execRow);
                }
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
            finally {
                this.sourceResultSet.clearCurrentRow();
                object.close();
            }
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
    }

    @Override
    public void close() throws StandardException {
        this.close(false);
    }

    private void updateVTI(ResultSet resultSet, ExecRow execRow) throws StandardException {
        int[] nArray = this.constants.changedColumnIds;
        try {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                DataValueDescriptor dataValueDescriptor = execRow.getColumn(i + 1);
                if (dataValueDescriptor.isNull()) {
                    resultSet.updateNull(n);
                    continue;
                }
                dataValueDescriptor.setInto(resultSet, n);
            }
            resultSet.updateRow();
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
    }
}

