/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.mvc.MvcContext;
import jakarta.mvc.security.Csrf;
import jakarta.mvc.security.Encoders;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.krazo.jaxrs.JaxRsContext;
import org.eclipse.krazo.uri.ApplicationUris;
import org.eclipse.krazo.util.PathUtils;

@Named(value="mvc")
@RequestScoped
public class MvcContextImpl
implements MvcContext {
    private static final Logger log = Logger.getLogger(MvcContextImpl.class.getName());
    @Inject
    private Csrf csrf;
    @Inject
    private Encoders encoders;
    @Inject
    private ServletContext servletContext;
    @Inject
    private ApplicationUris applicationUris;
    @Inject
    @JaxRsContext
    private Configuration configuration;
    @Inject
    @JaxRsContext
    private UriInfo uriInfo;
    private Locale locale;
    private String applicationPath;

    @PostConstruct
    public void init() {
        Objects.requireNonNull(this.configuration, "Cannot obtain JAX-RS Configuration instance");
        Objects.requireNonNull(this.uriInfo, "Cannot obtain JAX-RS UriInfo instance");
        Objects.requireNonNull(this.servletContext, "Cannot obtain ServletContext");
        this.applicationPath = PathUtils.normalizePath(this.uriInfo.getBaseUri().getPath().substring(this.servletContext.getContextPath().length()));
    }

    public String getBasePath() {
        if (this.applicationPath != null) {
            return this.servletContext.getContextPath() + this.applicationPath;
        }
        return this.servletContext.getContextPath();
    }

    public Csrf getCsrf() {
        return this.csrf;
    }

    public Encoders getEncoders() {
        return this.encoders;
    }

    public Configuration getConfig() {
        return this.configuration;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public URI uri(String identifier) {
        return this.applicationUris.get(identifier);
    }

    public URI uri(String identifier, Map<String, Object> params) {
        return this.applicationUris.get(identifier, params);
    }

    public UriBuilder uriBuilder(String identifier) {
        return this.applicationUris.getUriBuilder(identifier);
    }
}

