/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer;

import com.sun.jdo.api.persistence.enhancer.ByteCodeEnhancer;
import com.sun.jdo.api.persistence.enhancer.ByteCodeEnhancerHelper;
import com.sun.jdo.api.persistence.enhancer.EnhancerFatalError;
import com.sun.jdo.api.persistence.enhancer.EnhancerUserException;
import com.sun.jdo.api.persistence.enhancer.FilterEnhancer;
import com.sun.jdo.api.persistence.enhancer.OutputStreamWrapper;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataModelImpl;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataPropertyImpl;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataTimer;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import com.sun.jdo.api.persistence.model.Model;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Main {
    private ByteCodeEnhancer enhancer = null;
    private final PrintWriter outMessages = new PrintWriter(System.out, true);
    private final PrintWriter outErrors = new PrintWriter(System.err, true);
    private final CmdLineOptions cmdLineOpts = new CmdLineOptions(this);

    public static void main(String[] argv) {
        Main main = new Main();
        try {
            main.process(argv);
        }
        catch (RuntimeException tt) {
            System.err.println("Exception occurred while postprocessing:");
            tt.printStackTrace(System.err);
            throw tt;
        }
        finally {
            if (main.cmdLineOpts.doTiming) {
                Support.timer.print();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(String[] argv) {
        ArrayList cNames = new ArrayList();
        int res = this.processArgs(argv, cNames);
        if (res != 0) {
            this.printMessage("aborted with errors.");
            return res;
        }
        try {
            if (this.cmdLineOpts.doTiming) {
                Support.timer.push("Main.process(String[])");
            }
            this.enhanceInputFiles(cNames);
            this.printMessage("done.");
            int n = 0;
            return n;
        }
        finally {
            if (this.cmdLineOpts.doTiming) {
                Support.timer.pop();
            }
        }
    }

    protected int processArgs(String[] argv, Collection cNames) {
        Support jdoMetaData;
        argv = this.preprocess(argv);
        Properties jdoMetaDataProperties = null;
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.equals("-v") || arg.equals("-verbose")) {
                this.cmdLineOpts.verbose = true;
                this.cmdLineOpts.quiet = false;
                continue;
            }
            if (arg.equals("-q") || arg.equals("-quiet")) {
                this.cmdLineOpts.quiet = true;
                this.cmdLineOpts.verbose = false;
                continue;
            }
            if (arg.equals("-f") || arg.equals("-force")) {
                this.cmdLineOpts.forceWrite = true;
                continue;
            }
            if (arg.equals("-nowrite")) {
                this.cmdLineOpts.noWrite = true;
                continue;
            }
            if (arg.equals("-d") || arg.equals("-dest")) {
                if (argv.length - i < 2) {
                    this.printError("Missing argument to the -dest option", null);
                    Main.usage();
                }
                this.cmdLineOpts.destinationDirectory = argv[++i];
                continue;
            }
            if (arg.equals("-t") || arg.equals("--doTiming")) {
                this.cmdLineOpts.doTiming = true;
                continue;
            }
            if (arg.equals("-jp") || arg.equals("--jdoProperties")) {
                if (argv.length - i < 2) {
                    this.printError("Missing argument to the -jp/--jdoProperties option", null);
                    Main.usage();
                }
                try {
                    jdoMetaDataProperties = new Properties();
                    jdoMetaDataProperties.load(new FileInputStream(argv[++i]));
                }
                catch (IOException ex) {
                    this.printError("Cannot read JDO meta data properties from file", ex);
                    Main.usage();
                }
                continue;
            }
            if (arg.length() > 0 && arg.charAt(0) == '-') {
                this.printError("Unrecognized option:" + arg, null);
                Main.usage();
            }
            if (arg.length() == 0) {
                this.printMessage("Empty file name encountered on the command line.");
            }
            cNames.add(arg);
        }
        this.cmdLineOpts.quiet = false;
        if (this.cmdLineOpts.destinationDirectory == null) {
            if (argv.length > 0) {
                this.printError("No -dest output directory was specified", null);
            }
            Main.usage();
        }
        if (jdoMetaDataProperties != null) {
            this.printMessage("using JDO meta-data from properties");
            jdoMetaData = new JDOMetaDataPropertyImpl(jdoMetaDataProperties, this.outMessages);
        } else {
            this.printMessage("using JDO meta-data from Model.Enhancer");
            jdoMetaData = new JDOMetaDataModelImpl(Model.ENHANCER, this.outMessages);
        }
        if (this.cmdLineOpts.doTiming) {
            jdoMetaData = new JDOMetaDataTimer((JDOMetaData)((Object)jdoMetaData));
        }
        try {
            this.enhancer = this.createEnhancer((JDOMetaData)((Object)jdoMetaData));
        }
        catch (Exception ex) {
            this.printError("Error creating the enhancer", ex);
        }
        return 0;
    }

    private String[] preprocess(String[] args) {
        ArrayList<String> argVec = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length() > 0 && args[i].charAt(0) == '@') {
                String filename = null;
                if (args[i].length() == 1) {
                    if (i + 1 < args.length) {
                        filename = args[++i];
                    }
                } else {
                    filename = args[i].substring(1);
                }
                if (filename == null) {
                    this.printError("missing file name argument to @.", null);
                    continue;
                }
                this.appendFileContents(filename, argVec);
                continue;
            }
            argVec.add(args[i]);
        }
        String[] newArgs = argVec.toArray(new String[0]);
        return newArgs;
    }

    private void appendFileContents(String filename, ArrayList argVec) {
        try {
            FileReader inputFile = new FileReader(filename);
            try (BufferedReader input = new BufferedReader(inputFile);){
                String s = null;
                block9: while ((s = input.readLine()) != null) {
                    StringTokenizer parser = new StringTokenizer(s, " \t", false);
                    while (parser.hasMoreElements()) {
                        String token = parser.nextToken();
                        if (token.length() > 0 && token.charAt(0) == '@') {
                            this.printError("The included file \"" + filename + "\" contains a recursive include.  Recursive includes are not supported.", null);
                        }
                        if (token.charAt(0) == '#') continue block9;
                        argVec.add(token);
                    }
                }
            }
            catch (IOException ex) {
                this.printError("IO exception reading file " + filename + ".", ex);
            }
        }
        catch (FileNotFoundException ex) {
            this.printError("file " + filename + " not found.", ex);
        }
    }

    private final ByteCodeEnhancer createEnhancer(JDOMetaData jdometadata) throws EnhancerUserException, EnhancerFatalError {
        Properties props = new Properties();
        if (this.cmdLineOpts.verbose) {
            props.put("ByteCodeEnhancer.verboseLevel", "verbose");
        }
        return new FilterEnhancer(jdometadata, props, this.outMessages, this.outErrors);
    }

    private final void enhanceInputFiles(Collection filenames) {
        Iterator names = filenames.iterator();
        while (names.hasNext()) {
            try {
                String name = (String)names.next();
                if (Main.isClassFileName(name)) {
                    this.enhanceClassFile(Main.openFileInputStream(name));
                    continue;
                }
                if (Main.isZipFileName(name)) {
                    this.enhanceZipFile(name);
                    continue;
                }
                this.enhanceClassFile(this.openClassInputStream(name));
            }
            catch (Throwable ex) {
                this.printError(null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void enhanceClassFile(InputStream in) {
        BufferedOutputStream out = null;
        try {
            File temp = File.createTempFile("enhancer", ".class");
            out = new BufferedOutputStream(new FileOutputStream(temp));
            OutputStreamWrapper wrapper = new OutputStreamWrapper(out);
            boolean enhanced = this.enhancer.enhanceClassFile(in, wrapper);
            this.closeOutputStream(out);
            this.createOutputFile(enhanced, Main.createClassFileName(wrapper.getClassName()), temp);
            this.closeInputStream(in);
            this.closeOutputStream(out);
        }
        catch (Throwable ex) {
            try {
                this.printError(null, ex);
                this.closeInputStream(in);
                this.closeOutputStream(out);
            }
            catch (Throwable throwable) {
                this.closeInputStream(in);
                this.closeOutputStream(out);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void enhanceZipFile(String filename) {
        ZipInputStream in = null;
        ZipOutputStream out = null;
        try {
            File temp = File.createTempFile("enhancer", ".zip");
            in = new ZipInputStream(new BufferedInputStream(new FileInputStream(new File(filename))));
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(temp)));
            boolean enhanced = ByteCodeEnhancerHelper.enhanceZipFile(this.enhancer, in, out);
            this.closeOutputStream(out);
            out = null;
            this.createOutputFile(enhanced, new File(filename).getName(), temp);
            this.closeOutputStream(out);
            this.closeInputStream(in);
        }
        catch (Throwable ex) {
            try {
                this.printError(null, ex);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.closeOutputStream(out);
                this.closeInputStream(in);
            }
        }
    }

    private static final InputStream openFileInputStream(String filename) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(new File(filename)));
    }

    private final InputStream openClassInputStream(String classname) throws IOException, ClassNotFoundException {
        Main.class.getClassLoader();
        URL url = ClassLoader.getSystemResource(Main.createClassFileName(classname));
        if (url == null) {
            throw new ClassNotFoundException(classname);
        }
        return url.openStream();
    }

    private static final boolean isClassFileName(String filename) {
        return filename.endsWith(".class");
    }

    private static final boolean isZipFileName(String filename) {
        int n = filename.length();
        if (n < 5) {
            return false;
        }
        String ext = filename.substring(n - 4);
        return ext.equalsIgnoreCase(".zip") || ext.equalsIgnoreCase(".jar");
    }

    private static final String createClassFileName(String classname) {
        return classname.replace('.', '/') + ".class";
    }

    private final File createZipOutputFile(String zipfilename) {
        return new File(this.cmdLineOpts.destinationDirectory, new File(zipfilename).getName());
    }

    private final void createOutputFile(boolean enhanced, String filename, File temp) throws IOException {
        if (this.cmdLineOpts.noWrite || !enhanced && !this.cmdLineOpts.forceWrite) {
            temp.deleteOnExit();
            return;
        }
        File file = new File(this.cmdLineOpts.destinationDirectory, filename);
        Main.createPathOfFile(file);
        file.delete();
        boolean renamed = temp.renameTo(file);
        if (!renamed) {
            try {
                DataInputStream dis = new DataInputStream(new FileInputStream(temp));
                DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));
                int PAGESIZE = 4096;
                byte[] data = new byte[PAGESIZE];
                while (dis.available() > 0) {
                    int numRead = dis.read(data, 0, PAGESIZE);
                    dos.write(data, 0, numRead);
                }
                renamed = true;
                temp.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!renamed) {
                throw new IOException("Could not rename temp file '" + temp.getAbsolutePath() + "' to '" + file.getAbsolutePath() + "'.");
            }
        }
    }

    private final void closeInputStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ex) {
                this.printError(null, ex);
            }
        }
    }

    private final void closeOutputStream(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException ex) {
                this.printError(null, ex);
            }
        }
    }

    private static final void createPathOfFile(File file) throws IOException {
        File dir = file.getAbsoluteFile().getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Error creating directory '" + dir.getAbsolutePath() + "'.");
        }
    }

    private final void printError(String msg, Throwable ex) {
        if (msg != null) {
            this.outErrors.println(msg + (String)(ex != null ? ": " + String.valueOf(ex) : ""));
        }
        if (ex != null) {
            ex.printStackTrace(this.outErrors);
        }
    }

    private final void printMessage(String msg) {
        this.outMessages.println(msg);
    }

    public static void usage() {
        System.err.println("Usage: main <options> <file name>");
        System.err.println("  { -verbose | -v }");
        System.err.println("  { -force | -f }");
        System.err.println("  { -quiet | -q }");
        System.err.println("  -nowrite");
        System.err.println(" -dest | -d <destination directory>");
        System.err.println("  --jdoProperties | -jp");
        System.err.println("  --timing | -t");
        System.err.println("  @<cmd-arg-file>");
        System.exit(1);
    }

    private final class CmdLineOptions {
        String destinationDirectory = null;
        boolean doTiming = false;
        boolean verbose = false;
        boolean quiet = false;
        boolean forceWrite = false;
        boolean noWrite = false;

        private CmdLineOptions(Main main) {
        }
    }
}

