/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class ClientCookieStore
implements CookieStore {
    private static final int CACHE_WRITE_DELTA = 3600000;
    private static final URI COOKIE_URI = URI.create("http://CLI_Session/");
    private static final String CACHE_COMMENT = "# These cookies are used strictly for command routing.\n# These cookies are not used for authentication and they are\n# not assoicated with server state.";
    private final CookieStore cookieStore;
    private final File cookieStoreFile;

    public ClientCookieStore(CookieStore cookieStore, File file) {
        this.cookieStore = cookieStore;
        this.cookieStoreFile = file;
    }

    @Override
    public void add(URI uri, HttpCookie cookie) {
        this.cookieStore.add(uri, cookie);
    }

    @Override
    public List<HttpCookie> get(URI uri) {
        return this.cookieStore.get(uri);
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this.cookieStore.getCookies();
    }

    @Override
    public List<URI> getURIs() {
        return this.cookieStore.getURIs();
    }

    @Override
    public boolean remove(URI uri, HttpCookie cookie) {
        return this.cookieStore.remove(uri, cookie);
    }

    @Override
    public boolean removeAll() {
        return this.cookieStore.removeAll();
    }

    public URI getStaticURI() {
        return COOKIE_URI;
    }

    public void load() throws IOException {
        this.removeAll();
        if (!this.cookieStoreFile.exists()) {
            throw new IOException("File does not exist: " + String.valueOf(this.cookieStoreFile));
        }
        try (BufferedReader in = new BufferedReader(new FileReader(this.cookieStoreFile, StandardCharsets.UTF_8));){
            String str;
            while ((str = in.readLine()) != null) {
                if (str.startsWith("#")) continue;
                List<HttpCookie> cookies = HttpCookie.parse(str);
                for (HttpCookie cookie : cookies) {
                    this.add(this.getStaticURI(), cookie);
                }
            }
        }
    }

    public void store() throws IOException {
        if (!this.cookieStoreFile.getParentFile().exists() && !this.cookieStoreFile.getParentFile().mkdirs()) {
            throw new IOException("Unable to create directory: " + String.valueOf(this.cookieStoreFile));
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.cookieStoreFile, StandardCharsets.UTF_8)));
        out.println(CACHE_COMMENT);
        for (URI uri : this.getURIs()) {
            for (HttpCookie cookie : this.get(uri)) {
                if (cookie.getMaxAge() < 1L || cookie.getDiscard()) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(cookie.getName()).append("=").append(cookie.getValue());
                if (cookie.getPath() != null) {
                    sb.append("; Path=").append(cookie.getPath());
                }
                if (cookie.getDomain() != null) {
                    sb.append("; Domain=").append(cookie.getDomain());
                }
                if (cookie.getComment() != null) {
                    sb.append("; Comment=").append(cookie.getComment());
                }
                if (cookie.getCommentURL() != null) {
                    sb.append("; CommentURL=\"").append(cookie.getCommentURL()).append("\"");
                }
                sb.append("; Max-Age=").append(cookie.getMaxAge());
                if (cookie.getPortlist() != null) {
                    sb.append("; Port=\"").append(cookie.getPortlist()).append("\"");
                }
                sb.append("; Version=").append(cookie.getVersion());
                out.println(sb);
            }
        }
        out.close();
    }

    public boolean touchStore() {
        if (this.cookieStoreFile.lastModified() + 3600000L > System.currentTimeMillis()) {
            return false;
        }
        return this.cookieStoreFile.setLastModified(System.currentTimeMillis());
    }
}

