/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.apf.impl;

import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationProcessor;
import org.glassfish.apf.ErrorHandler;
import org.glassfish.apf.ProcessingContext;
import org.glassfish.apf.Scanner;
import org.glassfish.apf.context.AnnotationContext;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.api.deployment.archive.ReadableArchive;

class ProcessingContextImpl
implements ProcessingContext {
    private static final Logger LOG = AnnotationUtils.getLogger();
    protected AnnotationProcessor processor;
    protected Stack<AnnotatedElementHandler> handlers = new Stack();
    protected Scanner scanner;
    protected ReadableArchive archive;
    private ErrorHandler errorHandler;

    ProcessingContextImpl(AnnotationProcessor processor) {
        this.processor = processor;
    }

    @Override
    public AnnotationProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public ReadableArchive getArchive() {
        return this.archive;
    }

    @Override
    public void setArchive(ReadableArchive archive) {
        this.archive = archive;
    }

    @Override
    public void pushHandler(AnnotationContext handler) {
        LOG.log(Level.FINEST, "pushHandler: {0}", handler);
        handler.setProcessingContext(this);
        this.handlers.push(handler);
    }

    @Override
    public AnnotatedElementHandler getHandler() {
        if (this.handlers.isEmpty()) {
            return null;
        }
        return this.handlers.peek();
    }

    @Override
    public AnnotatedElementHandler popHandler() {
        if (this.handlers.isEmpty()) {
            return null;
        }
        return this.handlers.pop();
    }

    @Override
    public Scanner getProcessingInput() {
        return this.scanner;
    }

    @Override
    public void setProcessingInput(Scanner scanner) {
        this.scanner = scanner;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }
}

