/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import javax.xml.validation.Schema;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

public abstract class XMLReaderAdapter
extends XMLReader {
    protected ExtendedContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    protected LexicalHandler lexicalHandler;

    protected XMLReaderAdapter() {
    }

    protected XMLReaderAdapter(Unmarshaller xmlUnmarshaller) {
        if (null != xmlUnmarshaller) {
            Schema schema = xmlUnmarshaller.getSchema();
            if (null != schema) {
                this.validatingContentHandler = new XMLReader.ValidatingContentHandler(schema.newValidatorHandler());
                this.contentHandler = new ExtendedContentHandlerAdapter(this.validatingContentHandler);
            }
            this.setErrorHandler(xmlUnmarshaller.getErrorHandler());
        }
    }

    @Override
    public ExtendedContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        if (null == this.validatingContentHandler) {
            this.contentHandler = contentHandler instanceof ExtendedContentHandler ? (ExtendedContentHandler)contentHandler : new ExtendedContentHandlerAdapter(contentHandler);
        } else {
            this.validatingContentHandler.setContentHandler(contentHandler);
        }
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        if (null != this.validatingContentHandler) {
            this.validatingContentHandler.setErrorHandler(errorHandler);
        }
    }

    @Override
    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    @Override
    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            return this.getLexicalHandler();
        }
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            this.setLexicalHandler((LexicalHandler)value);
        }
    }

    @Override
    public void parse(String systemId) {
    }

    protected static class Attribute {
        private String localName;
        private String uri;
        private String name;
        private String value;

        public Attribute(String uri, String localName, String name, String value) {
            this.localName = localName;
            this.uri = uri == null ? "" : uri;
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getUri() {
            return this.uri;
        }
    }

    protected static abstract class IndexedAttributeList
    implements Attributes {
        protected static final Attribute[] NO_ATTRIBUTES = new Attribute[0];
        protected Attribute[] attributes;

        protected IndexedAttributeList() {
        }

        protected abstract Attribute[] attributes();

        @Override
        public int getIndex(String qName) {
            if (null == qName) {
                return -1;
            }
            int index = 0;
            for (Attribute attribute : this.attributes()) {
                if (qName.equals(attribute.getName())) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public int getIndex(String uri, String localName) {
            if (null == localName) {
                return -1;
            }
            int index = 0;
            for (Attribute attribute : this.attributes()) {
                if (localName.equals(attribute.getLocalName()) && uri.equals(attribute.getUri())) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public int getLength() {
            return this.attributes().length;
        }

        @Override
        public String getLocalName(int index) {
            return this.attributes()[index].getLocalName();
        }

        @Override
        public String getQName(int index) {
            return this.attributes()[index].getName();
        }

        @Override
        public String getType(int index) {
            return "CDATA";
        }

        @Override
        public String getType(String name) {
            return "CDATA";
        }

        @Override
        public String getType(String uri, String localName) {
            return "CDATA";
        }

        @Override
        public String getURI(int index) {
            return this.attributes()[index].getUri();
        }

        @Override
        public String getValue(int index) {
            return this.attributes()[index].getValue();
        }

        @Override
        public String getValue(String qName) {
            int index = this.getIndex(qName);
            if (-1 == index) {
                return null;
            }
            return this.attributes()[index].getValue();
        }

        @Override
        public String getValue(String uri, String localName) {
            int index = this.getIndex(uri, localName);
            if (-1 == index) {
                return null;
            }
            return this.attributes()[index].getValue();
        }

        public IndexedAttributeList reset() {
            this.attributes = null;
            return this;
        }
    }

    public static class ExtendedContentHandlerAdapter
    implements ExtendedContentHandler {
        private ContentHandler contentHandler;

        public ExtendedContentHandlerAdapter(ContentHandler contentHandler) {
            this.contentHandler = contentHandler;
        }

        public ContentHandler getContentHandler() {
            return this.contentHandler;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.contentHandler.setDocumentLocator(locator);
        }

        @Override
        public void startDocument() throws SAXException {
            this.contentHandler.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.contentHandler.endDocument();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.contentHandler.endPrefixMapping(prefix);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.contentHandler.startElement(uri, localName, qName, atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.contentHandler.endElement(uri, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.contentHandler.characters(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.contentHandler.processingInstruction(target, data);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.contentHandler.skippedEntity(name);
        }

        @Override
        public void characters(CharSequence characters) throws SAXException {
            if (null == characters) {
                return;
            }
            this.contentHandler.characters(characters.toString().toCharArray(), 0, characters.length());
        }

        @Override
        public void setNil(boolean isNil) {
        }
    }
}

