/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.helper;

import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.Subject;
import org.glassfish.epicyro.config.helper.PriviledgedAccessController;

public class Caller
implements Principal,
Serializable {
    private static final long serialVersionUID = 1L;
    private Principal callerPrincipal;
    private Set<String> groups = new HashSet<String>();

    public static Caller fromSubject(Subject subject) {
        Set callers = PriviledgedAccessController.privileged(() -> subject.getPrincipals(Caller.class));
        if (callers == null || callers.isEmpty()) {
            return null;
        }
        return (Caller)callers.iterator().next();
    }

    public static void toSubject(Subject subject, Caller caller) {
        PriviledgedAccessController.privileged(() -> subject.getPrincipals().add(caller));
    }

    public Caller() {
    }

    public Caller(Principal callerPrincipal) {
        this.callerPrincipal = callerPrincipal;
    }

    public Caller(String[] groups) {
        this.groups.addAll(Arrays.asList(groups));
    }

    public Caller(Principal callerPrincipal, Set<String> groups) {
        this.callerPrincipal = callerPrincipal;
        this.groups.addAll(groups);
    }

    @Override
    public String getName() {
        if (this.callerPrincipal == null) {
            return null;
        }
        return this.callerPrincipal.getName();
    }

    public Principal getCallerPrincipal() {
        return this.callerPrincipal;
    }

    public void setCallerPrincipal(Principal callerPrincipal) {
        this.callerPrincipal = callerPrincipal;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public String[] getGroupsAsArray() {
        return this.groups.toArray(new String[0]);
    }

    public void addGroups(String[] groups) {
        this.groups.addAll(Arrays.asList(groups));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Caller)) {
            return false;
        }
        Caller another = (Caller)o;
        return Objects.equals(this.getName(), another.getName());
    }

    @Override
    public int hashCode() {
        return this.callerPrincipal == null || this.callerPrincipal.getName() == null ? 0 : 31 * this.callerPrincipal.getName().hashCode();
    }
}

