/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.SQLModifyStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;

public class SQLUpdateAllStatement
extends SQLModifyStatement {
    protected Map<DatabaseField, Object> m_updateClauses;
    protected Map<DatabaseField, String> databaseFieldsToTableAliases;
    protected SQLCall selectCallForExist;
    protected String tableAliasInSelectCallForExist;
    protected Collection<DatabaseField> primaryKeyFields;
    protected boolean shouldExtractWhereClauseFromSelectCallForExist;

    public void setSelectCallForExist(SQLCall selectCallForExist) {
        this.selectCallForExist = selectCallForExist;
    }

    public SQLCall getSelectCallForExist() {
        return this.selectCallForExist;
    }

    public void setTableAliasInSelectCallForExist(String tableAliasInSelectCallForExist) {
        this.tableAliasInSelectCallForExist = tableAliasInSelectCallForExist;
    }

    public String getTableAliasInSelectCallForExist() {
        return this.tableAliasInSelectCallForExist;
    }

    public void setPrimaryKeyFieldsForAutoJoin(Collection<DatabaseField> primaryKeyFields) {
        this.primaryKeyFields = primaryKeyFields;
    }

    public Collection<DatabaseField> getPrimaryKeyFieldsForAutoJoin() {
        return this.primaryKeyFields;
    }

    public void setUpdateClauses(Map<DatabaseField, Object> updateClauses) {
        this.m_updateClauses = updateClauses;
    }

    public Map<DatabaseField, Object> getUpdateClauses() {
        return this.m_updateClauses;
    }

    public void setDatabaseFieldsToTableAliases(Map<DatabaseField, String> databaseFieldsToTableAliases) {
        this.databaseFieldsToTableAliases = databaseFieldsToTableAliases;
    }

    public Map<DatabaseField, String> getDatabaseFieldsToTableAliases() {
        return this.databaseFieldsToTableAliases;
    }

    public void setShouldExtractWhereClauseFromSelectCallForExist(boolean shouldExtractWhereClauseFromSelectCallForExist) {
        this.shouldExtractWhereClauseFromSelectCallForExist = shouldExtractWhereClauseFromSelectCallForExist;
    }

    public boolean shouldExtractWhereClauseFromSelectCallForExist() {
        return this.shouldExtractWhereClauseFromSelectCallForExist;
    }

    @Override
    public DatabaseCall buildCall(AbstractSession session) {
        SQLCall call = this.buildSimple(session);
        if (this.selectCallForExist == null) {
            return call;
        }
        CharArrayWriter writer = new CharArrayWriter(100);
        try {
            writer.write(call.getSQLString());
            if (this.selectCallForExist != null) {
                if (this.shouldExtractWhereClauseFromSelectCallForExist) {
                    this.writeWhere(writer, this.selectCallForExist, call);
                } else {
                    writer.write(" WHERE EXISTS(");
                    this.writeSelect(writer, this.selectCallForExist, this.tableAliasInSelectCallForExist, call, session.getPlatform());
                    writer.write(")");
                }
                if (this.selectCallForExist.isUsesBindingSet() && !this.selectCallForExist.usesBinding(session)) {
                    call.setUsesBinding(false);
                }
            }
            call.setSQLString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        return call;
    }

    protected SQLCall buildSimple(AbstractSession session) {
        SQLCall call = new SQLCall();
        call.returnNothing();
        CharArrayWriter writer = new CharArrayWriter(100);
        ExpressionSQLPrinter printer = new ExpressionSQLPrinter(session, this.getTranslationRow(), call, false, this.getBuilder());
        printer.setWriter(writer);
        try {
            writer.write("UPDATE ");
            if (this.getHintString() != null) {
                writer.write(this.getHintString());
                writer.write(" ");
            }
            writer.write(this.getTable().getQualifiedNameDelimited(session.getPlatform()));
            writer.write(" SET ");
            Iterator<DatabaseField> i = this.m_updateClauses.keySet().iterator();
            boolean commaNeeded = false;
            while (i.hasNext()) {
                if (commaNeeded) {
                    writer.write(", ");
                }
                DatabaseField field = i.next();
                Object value = this.m_updateClauses.get(field);
                writer.write(field.getNameDelimited(session.getPlatform()));
                writer.write(" = ");
                if (value instanceof Expression) {
                    Expression expression = (Expression)value;
                    printer.printExpression(expression);
                } else {
                    SQLCall selCall = (SQLCall)value;
                    String tableAlias = this.getDatabaseFieldsToTableAliases().get(field);
                    writer.write("(");
                    this.writeSelect(writer, selCall, tableAlias, call, session.getPlatform());
                    writer.write(")");
                }
                commaNeeded = true;
            }
            if (this.getWhereClause() != null) {
                writer.write(" WHERE ");
                printer.printExpression(this.getWhereClause());
            }
            call.setSQLString(((Object)writer).toString());
            return call;
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    protected void writeSelect(Writer writer, SQLCall selectCall, String tableAliasInSelectCall, SQLCall call, DatasourcePlatform platform) throws IOException {
        String str = selectCall.getSQLString();
        writer.write(str);
        boolean hasWhereClause = str.toUpperCase().contains(" WHERE ");
        Iterator<DatabaseField> it = this.getPrimaryKeyFieldsForAutoJoin().iterator();
        while (it.hasNext()) {
            if (!hasWhereClause) {
                writer.write(" WHERE ");
                hasWhereClause = true;
            } else {
                writer.write(" AND ");
            }
            String fieldName = it.next().getNameDelimited(platform);
            if (tableAliasInSelectCall != null) {
                writer.write(tableAliasInSelectCall);
                writer.write(46);
            }
            writer.write(fieldName);
            writer.write(" = ");
            writer.write(this.table.getQualifiedNameDelimited(platform));
            writer.write(46);
            writer.write(fieldName);
        }
        call.getParameters().addAll(selectCall.getParameters());
        call.getParameterTypes().addAll(selectCall.getParameterTypes());
        call.getParameterBindings().addAll(selectCall.getParameterBindings());
    }

    protected boolean writeWhere(Writer writer, SQLCall selectCall, SQLCall call) throws IOException {
        String selectStr = this.selectCallForExist.getSQLString();
        int index = selectStr.toUpperCase().indexOf(" WHERE ");
        if (index < 0) {
            return false;
        }
        String str = selectStr.substring(index);
        writer.write(str);
        call.getParameters().addAll(selectCall.getParameters());
        call.getParameterTypes().addAll(selectCall.getParameterTypes());
        call.getParameterBindings().addAll(selectCall.getParameterBindings());
        return true;
    }
}

