/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.More;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;
import org.jvnet.hk2.annotations.Service;

@Service(name="help")
@PerLookup
public class HelpCommand
extends CLICommand {
    @Inject
    private ServiceLocator habitat;
    private static final int DEFAULT_PAGE_LENGTH = 50;
    private static final int NO_PAGE_LENGTH = -1;
    private static final String DEFAULT_HELP_PAGE = "help";
    private static final LocalStringsImpl strings = new LocalStringsImpl(HelpCommand.class);
    @Param(name="command-name", primary=true, optional=true)
    private String cmd;

    @Override
    protected int executeCommand() throws CommandException, CommandValidationException {
        int n;
        block8: {
            Reader source = this.getSource();
            try {
                More more = new More(this.getUserInput(), this.getUserOutput(), this.getQuitChar(), this.getPrompt());
                more.view(this.getPageLength(), source, this.getDestination());
                n = 0;
                if (source == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new CommandException((Throwable)ioe);
                }
            }
            source.close();
        }
        return n;
    }

    private String getCommandName() {
        return this.cmd == null ? DEFAULT_HELP_PAGE : this.cmd;
    }

    private Writer getDestination() {
        return new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset());
    }

    private int getPageLength() {
        if (this.programOpts.isInteractive()) {
            return 50;
        }
        return -1;
    }

    private String getPrompt() {
        return strings.get("ManpagePrompt");
    }

    private String getQuitChar() {
        return strings.get("ManpageQuit");
    }

    private Reader getSource() throws CommandException, CommandValidationException {
        CLICommand command = CLICommand.getCommand(this.habitat, this.getCommandName());
        BufferedReader reader = command.getManPage();
        if (reader == null) {
            throw new CommandException(strings.get("ManpageMissing", new Object[]{this.getCommandName()}));
        }
        return this.expandManPage(reader);
    }

    private Reader getUserInput() {
        return new InputStreamReader(System.in, Charset.defaultCharset());
    }

    private Writer getUserOutput() {
        return new OutputStreamWriter((OutputStream)System.err, Charset.defaultCharset());
    }
}

