/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.ha.cache.store.backing.commands;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.shoal.ha.cache.api.DataStoreException;
import org.glassfish.shoal.ha.cache.store.backing.commands.AcknowledgedCommand;

public abstract class AbstractSaveCommand<K, V>
extends AcknowledgedCommand<K, V> {
    private static final long serialVersionUID = 241699054955846907L;
    protected static final transient Logger _logger = Logger.getLogger("org.glassfish.shoal.ha.cache.command.save");
    protected long version;
    protected long lastAccessedAt;
    protected long maxIdleTime;
    private transient String targetInstanceName;

    protected AbstractSaveCommand(byte opcode) {
        super(opcode);
    }

    public AbstractSaveCommand(byte opcode, K k, long version, long lastAccessedAt, long maxIdleTime) {
        this(opcode);
        super.setKey(k);
        this.version = version;
        this.lastAccessedAt = lastAccessedAt;
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    public boolean beforeTransmit() {
        this.targetInstanceName = this.dsc.getKeyMapper().getMappedInstance(this.dsc.getGroupName(), this.getKey());
        super.setTargetName(this.targetInstanceName);
        super.beforeTransmit();
        return this.getTargetName() != null;
    }

    @Override
    public abstract void execute(String var1) throws DataStoreException;

    @Override
    public String toString() {
        return this.getName() + "(" + String.valueOf(this.getKey()) + ")";
    }

    @Override
    public String getKeyMappingInfo() {
        return this.targetInstanceName;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.version);
        out.writeLong(this.lastAccessedAt);
        out.writeLong(this.maxIdleTime);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.dsc.getServiceName() + " sending state for key = " + String.valueOf(this.getKey()) + "; version = " + this.version + "; lastAccessedAt = " + this.lastAccessedAt + "; to " + this.getTargetName());
        }
    }

    public long getVersion() {
        return this.version;
    }

    public long getLastAccessedAt() {
        return this.lastAccessedAt;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.version = in.readLong();
        this.lastAccessedAt = in.readLong();
        this.maxIdleTime = in.readLong();
    }

    public boolean hasState() {
        return false;
    }
}

