/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.enterprise.v3.services.impl.monitor.stats.ConnectionQueueStatsProvider;
import com.sun.enterprise.v3.services.impl.monitor.stats.ThreadPoolStats;
import com.sun.enterprise.v3.services.impl.monitor.stats.ThreadPoolStatsProvider;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.threadpool.ThreadPoolInfo;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;

public class ThreadPoolMonitor
implements ThreadPoolProbe {
    private final GrizzlyMonitoring grizzlyMonitoring;
    private final String monitoringId;
    private final ThreadPoolStats stats;

    public ThreadPoolMonitor(GrizzlyMonitoring grizzlyMonitoring, String monitoringId, ThreadPoolConfig config) {
        this.grizzlyMonitoring = grizzlyMonitoring;
        this.monitoringId = monitoringId;
        this.stats = new ThreadPoolStats(config);
        if (grizzlyMonitoring != null) {
            ConnectionQueueStatsProvider connectionQueueStatsProvider;
            ThreadPoolStatsProvider threadPoolStatsProvider = grizzlyMonitoring.getThreadPoolStatsProvider(monitoringId);
            if (threadPoolStatsProvider != null) {
                threadPoolStatsProvider.setStatsObject(this.stats);
                threadPoolStatsProvider.reset();
            }
            if ((connectionQueueStatsProvider = grizzlyMonitoring.getConnectionQueueStatsProvider(monitoringId)) != null) {
                connectionQueueStatsProvider.setStatsObject(config);
                connectionQueueStatsProvider.reset();
            }
        }
    }

    public void onThreadPoolStartEvent(ThreadPoolInfo threadPool) {
    }

    public void onThreadPoolStopEvent(ThreadPoolInfo threadPool) {
    }

    public void onThreadAllocateEvent(ThreadPoolInfo threadPool, Thread thread) {
        this.stats.currentThreadCount = threadPool.getSize();
        this.grizzlyMonitoring.getThreadPoolProbeProvider().threadAllocatedEvent(this.monitoringId, threadPool.getConfig().getPoolName(), thread.getId());
        this.grizzlyMonitoring.getThreadPoolProbeProvider().setCurrentThreadCountEvent(this.monitoringId, threadPool.getConfig().getPoolName(), threadPool.getSize());
    }

    public void onThreadReleaseEvent(ThreadPoolInfo threadPool, Thread thread) {
        this.stats.currentThreadCount = threadPool.getSize();
        this.grizzlyMonitoring.getThreadPoolProbeProvider().threadReleasedEvent(this.monitoringId, threadPool.getConfig().getPoolName(), thread.getId());
        this.grizzlyMonitoring.getThreadPoolProbeProvider().setCurrentThreadCountEvent(this.monitoringId, threadPool.getConfig().getPoolName(), threadPool.getSize());
    }

    public void onMaxNumberOfThreadsEvent(ThreadPoolInfo threadPool, int maxNumberOfThreads) {
        this.stats.currentThreadCount = threadPool.getSize();
        this.grizzlyMonitoring.getThreadPoolProbeProvider().maxNumberOfThreadsReachedEvent(this.monitoringId, threadPool.getConfig().getPoolName(), maxNumberOfThreads);
        this.grizzlyMonitoring.getThreadPoolProbeProvider().setCurrentThreadCountEvent(this.monitoringId, threadPool.getConfig().getPoolName(), threadPool.getSize());
    }

    public void onTaskDequeueEvent(ThreadPoolInfo threadPool, Runnable task) {
        long currentBusyThreadCount = this.stats.currentBusyThreadCount.incrementAndGet();
        this.stats.currentThreadCount = threadPool.getSize();
        this.grizzlyMonitoring.getThreadPoolProbeProvider().threadDispatchedFromPoolEvent(this.monitoringId, threadPool.getConfig().getPoolName(), Thread.currentThread().getId(), currentBusyThreadCount);
        this.grizzlyMonitoring.getConnectionQueueProbeProvider().onTaskDequeuedEvent(this.monitoringId, task.getClass().getName());
        this.grizzlyMonitoring.getThreadPoolProbeProvider().setCurrentThreadCountEvent(this.monitoringId, threadPool.getConfig().getPoolName(), threadPool.getSize());
    }

    public void onTaskCancelEvent(ThreadPoolInfo threadPool, Runnable task) {
        long currentBusyThreadCount = this.stats.currentBusyThreadCount.decrementAndGet();
        this.stats.currentThreadCount = threadPool.getSize();
        this.grizzlyMonitoring.getThreadPoolProbeProvider().threadReturnedToPoolEvent(this.monitoringId, threadPool.getConfig().getPoolName(), Thread.currentThread().getId(), currentBusyThreadCount);
        this.grizzlyMonitoring.getThreadPoolProbeProvider().setCurrentThreadCountEvent(this.monitoringId, threadPool.getConfig().getPoolName(), threadPool.getSize());
    }

    public void onTaskCompleteEvent(ThreadPoolInfo threadPool, Runnable task) {
        long currentBusyThreadCount = this.stats.currentBusyThreadCount.decrementAndGet();
        this.stats.currentThreadCount = threadPool.getSize();
        this.grizzlyMonitoring.getThreadPoolProbeProvider().threadReturnedToPoolEvent(this.monitoringId, threadPool.getConfig().getPoolName(), Thread.currentThread().getId(), currentBusyThreadCount);
        this.grizzlyMonitoring.getThreadPoolProbeProvider().setCurrentThreadCountEvent(this.monitoringId, threadPool.getConfig().getPoolName(), threadPool.getSize());
    }

    public void onTaskQueueEvent(ThreadPoolInfo threadPool, Runnable task) {
        this.stats.currentThreadCount = threadPool.getSize();
        this.grizzlyMonitoring.getConnectionQueueProbeProvider().onTaskQueuedEvent(this.monitoringId, task.getClass().getName());
        this.grizzlyMonitoring.getThreadPoolProbeProvider().setCurrentThreadCountEvent(this.monitoringId, threadPool.getConfig().getPoolName(), threadPool.getSize());
    }

    public void onTaskQueueOverflowEvent(ThreadPoolInfo threadPool) {
        this.stats.currentThreadCount = threadPool.getSize();
        this.grizzlyMonitoring.getConnectionQueueProbeProvider().onTaskQueueOverflowEvent(this.monitoringId);
        this.grizzlyMonitoring.getThreadPoolProbeProvider().setCurrentThreadCountEvent(this.monitoringId, threadPool.getConfig().getPoolName(), threadPool.getSize());
    }
}

