/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.http.io.InputBuffer;
import org.glassfish.grizzly.http.io.NIOInputStream;

final class NIOInputStreamImpl
extends NIOInputStream
implements Cacheable {
    private volatile InputBuffer inputBuffer;

    NIOInputStreamImpl() {
    }

    @Override
    public int read() throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        return this.inputBuffer.readByte();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        return this.inputBuffer.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        return this.inputBuffer.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        return this.inputBuffer.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        return this.inputBuffer.available();
    }

    @Override
    public void close() throws IOException {
        if (!this.initialized()) {
            return;
        }
        this.inputBuffer.close();
    }

    @Override
    public void mark(int readlimit) {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        this.inputBuffer.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        this.inputBuffer.reset();
    }

    @Override
    public boolean markSupported() {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.inputBuffer.markSupported();
    }

    @Override
    public void notifyAvailable(ReadHandler handler) {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        this.inputBuffer.notifyAvailable(handler);
    }

    @Override
    public void notifyAvailable(ReadHandler handler, int size) {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        this.inputBuffer.notifyAvailable(handler, size);
    }

    @Override
    public boolean isFinished() {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.inputBuffer.isFinished();
    }

    @Override
    public int readyData() {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.inputBuffer.available();
    }

    @Override
    public boolean isReady() {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.inputBuffer.available() > 0;
    }

    @Override
    public Buffer getBuffer() {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.inputBuffer.getBuffer();
    }

    @Override
    public Buffer readBuffer() {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.inputBuffer.readBuffer();
    }

    @Override
    public Buffer readBuffer(int size) {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.inputBuffer.readBuffer(size);
    }

    @Override
    public void recycle() {
        this.inputBuffer = null;
    }

    public void setInputBuffer(InputBuffer inputBuffer) {
        this.inputBuffer = inputBuffer;
    }

    private boolean initialized() {
        return this.inputBuffer != null;
    }
}

