/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.xdb;

import java.io.StringReader;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.platform.database.XMLTypePlaceholder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.platform.xml.XMLComparer;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.eclipse.persistence.sessions.Session;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DirectToXMLTypeMapping
extends DirectToFieldMapping {
    protected boolean shouldReadWholeDocument = false;
    private XMLTransformer xmlTransformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
    private XMLComparer xmlComparer;
    private XMLParser xmlParser;

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        if (this.attributeClassification == null) {
            this.attributeClassification = this.getAttributeAccessor().getAttributeClass();
        }
        if (this.isMutable == null && this.attributeClassification != CoreClassConstants.STRING) {
            this.setIsMutable(true);
        }
        super.preInitialize(session);
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        this.setFieldClassification(XMLTypePlaceholder.class);
    }

    public DirectToXMLTypeMapping() {
        this.xmlTransformer.setFormattedOutput(false);
        this.xmlParser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
        this.xmlComparer = new XMLComparer();
    }

    public void setShouldReadWholeDocument(boolean readWholeDocument) {
        this.shouldReadWholeDocument = readWholeDocument;
    }

    public boolean shouldReadWholeDocument() {
        return this.shouldReadWholeDocument;
    }

    @Override
    public Object getObjectValue(Object fieldValue, Session session) throws ConversionException {
        Object attributeValue = fieldValue;
        try {
            if (attributeValue != null && this.attributeClassification != CoreClassConstants.STRING) {
                String xml = (String)attributeValue;
                StringReader reader = new StringReader(xml);
                return this.xmlParser.parse(reader);
            }
        }
        catch (Exception ex) {
            throw ConversionException.couldNotBeConverted(fieldValue, this.attributeClassification, ex);
        }
        if (attributeValue == null && this.nullValue != null) {
            return this.nullValue;
        }
        if (this.converter != null) {
            attributeValue = this.converter.convertDataValueToObjectValue(attributeValue, session);
        }
        return attributeValue;
    }

    @Override
    public boolean isDirectToXMLTypeMapping() {
        return true;
    }

    @Override
    protected Object buildCloneValue(Object attributeValue, AbstractSession session) {
        Object newAttributeValue = attributeValue;
        if (this.isMutable() && attributeValue != null && (this.getAttributeClassification() == ClassConstants.DOCUMENT || this.getAttributeClassification() == ClassConstants.NODE)) {
            Document doc = (Document)attributeValue;
            newAttributeValue = doc.cloneNode(true);
        }
        return newAttributeValue;
    }

    @Override
    protected boolean compareObjectValues(Object firstValue, Object secondValue, AbstractSession session) {
        if (firstValue == secondValue) {
            return true;
        }
        if (firstValue == null || secondValue == null) {
            return false;
        }
        if (this.getAttributeClassification() == CoreClassConstants.STRING) {
            return firstValue.equals(secondValue);
        }
        Object one = this.getFieldValue(firstValue, session);
        Object two = this.getFieldValue(secondValue, session);
        if (one instanceof Node && two instanceof Node) {
            return this.xmlComparer.isNodeEqual((Node)one, (Node)two);
        }
        return one.equals(two);
    }
}

