/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.util;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.glassfish.grizzly.ThreadCache;

public final class DateTimeFormatters {
    private static final ThreadCache.CachedTypeIndex<DateTimeFormatters> CACHE_IDX = ThreadCache.obtainIndex(DateTimeFormatters.class, 1);
    private final DateTimeFormatter[] formatters;

    public static DateTimeFormatters create() {
        DateTimeFormatters formats = ThreadCache.takeFromCache(CACHE_IDX);
        if (formats != null) {
            return formats;
        }
        return new DateTimeFormatters();
    }

    private DateTimeFormatters() {
        ZoneId zoneId = ZoneId.of("GMT");
        this.formatters = new DateTimeFormatter[]{DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).withZone(zoneId), DateTimeFormatter.ofPattern("EEE, dd-MMM-yy HH:mm:ss zzz", Locale.US).withZone(zoneId), DateTimeFormatter.ofPattern("EEE MMMM d HH:mm:ss yyyy", Locale.US).withZone(zoneId)};
    }

    public DateTimeFormatter[] getFormats() {
        return this.formatters;
    }

    public void recycle() {
        ThreadCache.putToCache(CACHE_IDX, this);
    }
}

