/*
 * Decompiled with CFR 0.152.
 */
package jakarta.persistence;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.PersistenceUnitTransactionType;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PersistenceConfiguration {
    public static final String JDBC_DRIVER = "jakarta.persistence.jdbc.driver";
    public static final String JDBC_URL = "jakarta.persistence.jdbc.url";
    public static final String JDBC_USER = "jakarta.persistence.jdbc.user";
    public static final String JDBC_PASSWORD = "jakarta.persistence.jdbc.password";
    public static final String JDBC_DATASOURCE = "jakarta.persistence.dataSource";
    public static final String LOCK_TIMEOUT = "jakarta.persistence.lock.timeout";
    public static final String QUERY_TIMEOUT = "jakarta.persistence.query.timeout";
    public static final String SCHEMAGEN_DATABASE_ACTION = "jakarta.persistence.schema-generation.database.action";
    public static final String SCHEMAGEN_SCRIPTS_ACTION = "jakarta.persistence.schema-generation.scripts.action";
    public static final String SCHEMAGEN_CREATE_SOURCE = "jakarta.persistence.schema-generation.create-source";
    public static final String SCHEMAGEN_DROP_SOURCE = "jakarta.persistence.schema-generation.drop-source";
    public static final String SCHEMAGEN_CREATE_SCRIPT_SOURCE = "jakarta.persistence.schema-generation.create-script-source";
    public static final String SCHEMAGEN_DROP_SCRIPT_SOURCE = "jakarta.persistence.schema-generation.drop-script-source";
    public static final String SCHEMAGEN_CREATE_TARGET = "jakarta.persistence.schema-generation.create-target";
    public static final String SCHEMAGEN_DROP_TARGET = "jakarta.persistence.schema-generation.drop-target";
    public static final String VALIDATION_FACTORY = "jakarta.persistence.validation.factory";
    public static final String VALIDATION_GROUP_PRE_PERSIST = "jakarta.persistence.validation.group.pre-persist";
    public static final String VALIDATION_GROUP_PRE_UPDATE = "jakarta.persistence.validation.group.pre-update";
    public static final String VALIDATION_GROUP_PRE_REMOVE = "jakarta.persistence.validation.group.pre-remove";
    public static final String CACHE_MODE = "jakarta.persistence.sharedCache.mode";
    private final String name;
    private String provider;
    private String jtaDataSource;
    private String nonJtaDataSource;
    private SharedCacheMode sharedCacheMode = SharedCacheMode.UNSPECIFIED;
    private ValidationMode validationMode = ValidationMode.AUTO;
    private PersistenceUnitTransactionType transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
    private final List<Class<?>> managedClasses = new ArrayList();
    private final List<String> mappingFileNames = new ArrayList<String>();
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public PersistenceConfiguration(String name) {
        Objects.requireNonNull(name, "Persistence unit name should not be null");
        this.name = name;
    }

    public EntityManagerFactory createEntityManagerFactory() {
        return Persistence.createEntityManagerFactory(this);
    }

    public String name() {
        return this.name;
    }

    public PersistenceConfiguration provider(String providerClassName) {
        this.provider = providerClassName;
        return this;
    }

    public String provider() {
        return this.provider;
    }

    public PersistenceConfiguration jtaDataSource(String dataSourceJndiName) {
        this.jtaDataSource = dataSourceJndiName;
        return this;
    }

    public String jtaDataSource() {
        return this.jtaDataSource;
    }

    public PersistenceConfiguration nonJtaDataSource(String dataSourceJndiName) {
        this.nonJtaDataSource = dataSourceJndiName;
        return this;
    }

    public String nonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public PersistenceConfiguration managedClass(Class<?> managedClass) {
        this.managedClasses.add(managedClass);
        return this;
    }

    public List<Class<?>> managedClasses() {
        return this.managedClasses;
    }

    public PersistenceConfiguration mappingFile(String name) {
        this.mappingFileNames.add(name);
        return this;
    }

    public List<String> mappingFiles() {
        return this.mappingFileNames;
    }

    public PersistenceConfiguration transactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    public PersistenceUnitTransactionType transactionType() {
        return this.transactionType;
    }

    public PersistenceConfiguration sharedCacheMode(SharedCacheMode sharedCacheMode) {
        this.sharedCacheMode = sharedCacheMode;
        return this;
    }

    public SharedCacheMode sharedCacheMode() {
        return this.sharedCacheMode;
    }

    public PersistenceConfiguration validationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
        return this;
    }

    public ValidationMode validationMode() {
        return this.validationMode;
    }

    public PersistenceConfiguration property(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    public PersistenceConfiguration properties(Map<String, ?> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }
}

