/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet_http.httpsessionx;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import servlet.tck.common.servlets.HttpTCKServlet;
import servlet.tck.common.util.ServletTestUtil;

public class TestServlet
extends HttpTCKServlet {
    int expectedResult = 10;

    public void getNewSession(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = true;
        request.getSession(true);
        ServletTestUtil.printResult(pw, passed);
    }

    public void getNewSessionx(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletContext servletContext = this.getServletContext().getContext("/servlet_jsh_httpsessionx2_web");
        if (servletContext != null || ServletTestUtil.SUPPORT_CROSS_CONTEXT) {
            RequestDispatcher rd = servletContext.getRequestDispatcher("/getNewSession");
            rd.include((ServletRequest)request, (ServletResponse)response);
        } else {
            response.getWriter().println("Test PASSED");
        }
    }

    public void setMaxInactiveIntervalTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = true;
        HttpSession session = request.getSession(false);
        session.setMaxInactiveInterval(this.expectedResult);
        ServletTestUtil.printResult(pw, passed);
    }

    public void getMaxInactiveIntervalTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        HttpSession session = request.getSession(false);
        int result = session.getMaxInactiveInterval();
        if (result != this.expectedResult) {
            passed = false;
            pw.println("getMaxInactiveInterval() returned incorrect result ");
            pw.println("Expected result = " + this.expectedResult + " ");
            pw.println("Actual result = |" + result + "| ");
        } else {
            pw.println("getMaxInactiveInterval() returned correct result " + result);
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void expireHttpSessionTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        HttpSession session = request.getSession(false);
        if (session != null) {
            passed = false;
            pw.println("From TestServlet: Session is not expired ");
        } else {
            pw.println("From TestServlet: Session is expired as expected");
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void setMaxInactiveIntervalxiTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletContext servletContext = this.getServletContext().getContext("/servlet_jsh_httpsessionx2_web");
        if (servletContext != null || ServletTestUtil.SUPPORT_CROSS_CONTEXT) {
            RequestDispatcher rd = servletContext.getRequestDispatcher("/setMaxInterval");
            rd.include((ServletRequest)request, (ServletResponse)response);
        } else {
            response.getWriter().println("Test PASSED");
        }
    }

    public void setMaxInactiveIntervalxfTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletContext servletContext = this.getServletContext().getContext("/servlet_jsh_httpsessionx2_web");
        if (servletContext != null || ServletTestUtil.SUPPORT_CROSS_CONTEXT) {
            RequestDispatcher rd = servletContext.getRequestDispatcher("/setMaxInterval");
            rd.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            response.getWriter().println("Test PASSED");
        }
    }

    public void expireHttpSessionxriTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletContext servletContext = this.getServletContext().getContext("/servlet_jsh_httpsessionx2_web");
        if (servletContext != null || ServletTestUtil.SUPPORT_CROSS_CONTEXT) {
            RequestDispatcher rd = servletContext.getRequestDispatcher("/expireHttpSession");
            rd.include((ServletRequest)request, (ServletResponse)response);
        } else {
            response.getWriter().println("Test PASSED");
        }
    }

    public void expireHttpSessionxrfTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletContext servletContext = this.getServletContext().getContext("/servlet_jsh_httpsessionx2_web");
        if (servletContext != null || ServletTestUtil.SUPPORT_CROSS_CONTEXT) {
            RequestDispatcher rd = servletContext.getRequestDispatcher("/expireHttpSession");
            rd.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            response.getWriter().println("Test PASSED");
        }
    }

    public void invalidateSessionTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        HttpSession session = request.getSession(false);
        session.invalidate();
        if (!request.isRequestedSessionIdValid()) {
            passed = true;
            pw.println("From TestServlet: Session is invalidated ");
        } else {
            passed = false;
            pw.println("From TestServlet: Session is not invalidated ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void invalidateSessionxTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletContext servletContext = this.getServletContext().getContext("/servlet_jsh_httpsessionx2_web");
        if (servletContext != null || ServletTestUtil.SUPPORT_CROSS_CONTEXT) {
            RequestDispatcher rd = servletContext.getRequestDispatcher("/invalidateHttpSession");
            rd.include((ServletRequest)request, (ServletResponse)response);
        } else {
            response.getWriter().println("Test PASSED");
        }
    }
}

