/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.common.client.handler;

import servlet.tck.common.client.handler.ALLOWHandler;
import servlet.tck.common.client.handler.ContentTypeHandler;
import servlet.tck.common.client.handler.DefaultHandler;
import servlet.tck.common.client.handler.Handler;
import servlet.tck.common.client.handler.LocationHandler;
import servlet.tck.common.client.handler.SetCookieHandler;
import servlet.tck.common.client.handler.WWWAuthenticateHandler;

public class HandlerFactory {
    private static final String CONTENT_TYPE = "content-type";
    private static final String LOCATION = "location";
    private static final String SET_COOKIE = "set-cookie";
    private static final String ALLOW = "allow";
    private static final String WWW_AUTH = "www-authenticate";

    private HandlerFactory() {
    }

    public static Handler getHandler(String handlerName) {
        switch (handlerName.toLowerCase()) {
            case "content-type": {
                return ContentTypeHandler.getInstance();
            }
            case "location": {
                return LocationHandler.getInstance();
            }
            case "set-cookie": {
                return SetCookieHandler.getInstance();
            }
            case "www-authenticate": {
                return WWWAuthenticateHandler.getInstance();
            }
            case "allow": {
                return ALLOWHandler.getInstance();
            }
        }
        return DefaultHandler.getInstance();
    }
}

