/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit.command;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.internal.IRepositoryCommit;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.DiffEditor;
import org.eclipse.egit.ui.internal.commit.DiffEditorInput;
import org.eclipse.egit.ui.internal.commit.command.CommitCommandHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class UnifiedDiffHandler
extends CommitCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<IRepositoryCommit> commits = this.getCommits(event);
        if (commits.size() == 2) {
            Collections.sort(commits, Comparator.comparingInt(repoCommit -> repoCommit.getRevCommit().getCommitTime()).reversed());
            UnifiedDiffHandler.show(commits.get(0), commits.get(1));
        }
        return null;
    }

    public static void show(IRepositoryCommit tip, IRepositoryCommit base) {
        IEditorPart existing;
        Assert.isNotNull((Object)tip);
        final DiffEditorInput input = new DiffEditorInput(tip, base);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        final IWorkbenchPage page = window.getActivePage();
        IEditorReference[] editors = page.findEditors((IEditorInput)input, "org.eclipse.egit.ui.diffEditor", 3);
        if (editors != null && editors.length > 0 && (existing = editors[0].getEditor(false)) != null) {
            page.activate((IWorkbenchPart)existing);
            return;
        }
        final DiffEditor.DiffJob job = DiffEditor.getDiffer(tip, base);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent evt) {
                if (!evt.getResult().isOK()) {
                    return;
                }
                input.setDocument((IDocument)job.getDocument());
                new UIJob(UIText.DiffEditor_TaskUpdatingViewer){

                    public IStatus runInUIThread(IProgressMonitor uiMonitor) {
                        try {
                            page.openEditor((IEditorInput)input, "org.eclipse.egit.ui.diffEditor", true);
                        }
                        catch (PartInitException e) {
                            return e.getStatus();
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule(50L);
            }
        });
        job.setUser(true);
        job.schedule();
    }
}

