/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.process.normalize;

import java.util.Locale;
import java.util.function.BiFunction;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.langtag.LangTags;
import org.apache.jena.riot.process.StreamRDFApplyObject;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.util.NodeUtils;

public class StreamCanonicalLangTag
extends StreamRDFApplyObject {
    public static StreamRDF toLC(StreamRDF other) {
        Locale.Builder locBuild = new Locale.Builder();
        return new StreamCanonicalLangTag(other, locBuild, (b, n) -> StreamCanonicalLangTag.canonical(locBuild, n, StreamCanonicalLangTag::langTagLC));
    }

    public static StreamRDF toCanonical(StreamRDF other) {
        Locale.Builder locBuild = new Locale.Builder();
        return new StreamCanonicalLangTag(other, locBuild, (b, n) -> StreamCanonicalLangTag.canonical(locBuild, n, StreamCanonicalLangTag::langTagCanonical));
    }

    private StreamCanonicalLangTag(StreamRDF other, Locale.Builder locBuild, BiFunction<Locale.Builder, Node, Node> stringMapper) {
        super(other, n -> (Node)stringMapper.apply(locBuild, (Node)n));
    }

    private static Node canonical(Locale.Builder locBuild, Node n, BiFunction<Locale.Builder, String, String> tagMapper) {
        if (!NodeUtils.hasLang(n)) {
            return n;
        }
        String langTag = n.getLiteralLanguage();
        if (langTag == null || langTag.isEmpty()) {
            return n;
        }
        String langTag2 = tagMapper.apply(locBuild, langTag);
        if (langTag == langTag2) {
            return n;
        }
        Node obj2 = NodeFactory.createLiteralLang(n.getLiteralLexicalForm(), langTag2);
        return obj2;
    }

    static String langTagCanonical(Locale.Builder locBuild, String str2) {
        return LangTags.basicFormat(str2);
    }

    static String langTagLC(Locale.Builder locBuild, String str2) {
        return Lib.lowercase(str2);
    }
}

