/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.writers;

import org.eclipse.escet.cif.plcgen.generators.typegen.PlcDerivedTypeData;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcConfiguration;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPou;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcProject;
import org.eclipse.escet.cif.plcgen.model.types.PlcDerivedType;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.cif.plcgen.writers.Writer;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.java.PathPair;

public class AbbWriter
extends Writer {
    public AbbWriter(PlcTarget target) {
        super(target);
    }

    @Override
    public void write(PlcProject project, PathPair outputPaths) {
        this.ensureDirectory(outputPaths);
        for (PlcConfiguration config : project.configurations) {
            this.write(config, outputPaths);
        }
        for (PlcPou pou : project.pous) {
            this.write(pou, outputPaths);
        }
        for (PlcDerivedTypeData derivedTypeData : project.derivedTypeDatas) {
            this.writeDerivedType(derivedTypeData.derivedType, outputPaths);
        }
    }

    private void write(PlcConfiguration config, PathPair outPaths) {
        String fileName = config.name + ".plccfg";
        Box code = this.toBox(config);
        this.writeFile(code, outPaths, fileName);
    }

    private void write(PlcPou pou, PathPair outPaths) {
        String ext = pou.retType == null ? ".plcprog" : ".plcfunc";
        String fileName = pou.name + ext;
        Box code = this.toBox(pou);
        this.writeFile(code, outPaths, fileName);
    }

    private void writeDerivedType(PlcDerivedType derivedType, PathPair outPaths) {
        String typeName;
        if (derivedType instanceof PlcStructType) {
            PlcStructType structType = (PlcStructType)derivedType;
            typeName = structType.getName();
        } else if (derivedType instanceof PlcStructType) {
            PlcStructType enumType = (PlcStructType)derivedType;
            typeName = enumType.getName();
        } else {
            throw new AssertionError((Object)("Unexpected derived type found: \"" + String.valueOf(derivedType) + "\"."));
        }
        String fileName = typeName + ".plctype";
        Box code = this.toTypeDeclBox(derivedType);
        this.writeFile(code, outPaths, fileName);
    }
}

