/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth;

import java.util.List;
import org.eclipse.escet.cif.bdd.settings.AllowNonDeterminism;
import org.eclipse.escet.cif.datasynth.CifDataSynthesis;
import org.eclipse.escet.cif.datasynth.CifDataSynthesisTiming;
import org.eclipse.escet.cif.datasynth.options.BddAdvancedVariableOrderOption;
import org.eclipse.escet.cif.datasynth.options.BddDcshVarOrderOption;
import org.eclipse.escet.cif.datasynth.options.BddDebugMaxNodesOption;
import org.eclipse.escet.cif.datasynth.options.BddDebugMaxPathsOption;
import org.eclipse.escet.cif.datasynth.options.BddForceVarOrderOption;
import org.eclipse.escet.cif.datasynth.options.BddHyperEdgeAlgoOption;
import org.eclipse.escet.cif.datasynth.options.BddInitNodeTableSizeOption;
import org.eclipse.escet.cif.datasynth.options.BddOpCacheRatioOption;
import org.eclipse.escet.cif.datasynth.options.BddOpCacheSizeOption;
import org.eclipse.escet.cif.datasynth.options.BddOutputNamePrefixOption;
import org.eclipse.escet.cif.datasynth.options.BddOutputOption;
import org.eclipse.escet.cif.datasynth.options.BddSimplifyOption;
import org.eclipse.escet.cif.datasynth.options.BddSlidingWindowSizeOption;
import org.eclipse.escet.cif.datasynth.options.BddSlidingWindowVarOrderOption;
import org.eclipse.escet.cif.datasynth.options.BddVariableOrderOption;
import org.eclipse.escet.cif.datasynth.options.ContinuousPerformanceStatisticsFileOption;
import org.eclipse.escet.cif.datasynth.options.EdgeGranularityOption;
import org.eclipse.escet.cif.datasynth.options.EdgeOrderBackwardOption;
import org.eclipse.escet.cif.datasynth.options.EdgeOrderDuplicateEventsOption;
import org.eclipse.escet.cif.datasynth.options.EdgeOrderForwardOption;
import org.eclipse.escet.cif.datasynth.options.EdgeOrderOption;
import org.eclipse.escet.cif.datasynth.options.EdgeWorksetAlgoOption;
import org.eclipse.escet.cif.datasynth.options.EventWarnOption;
import org.eclipse.escet.cif.datasynth.options.ExplorationStrategyOption;
import org.eclipse.escet.cif.datasynth.options.FixedPointComputationsOrderOption;
import org.eclipse.escet.cif.datasynth.options.ForwardReachOption;
import org.eclipse.escet.cif.datasynth.options.PlantsRefReqsWarnOption;
import org.eclipse.escet.cif.datasynth.options.StateReqInvEnforceOption;
import org.eclipse.escet.cif.datasynth.options.SupervisorNameOption;
import org.eclipse.escet.cif.datasynth.options.SupervisorNamespaceOption;
import org.eclipse.escet.cif.datasynth.options.SynthesisStatisticsOption;
import org.eclipse.escet.cif.datasynth.settings.CifDataSynthesisSettings;
import org.eclipse.escet.cif.datasynth.settings.SynthesisStatistics;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.PathPair;
import org.eclipse.escet.common.java.Termination;

public class CifDataSynthesisApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        CifDataSynthesisApp app = new CifDataSynthesisApp();
        app.run(args, true);
    }

    public CifDataSynthesisApp() {
    }

    public CifDataSynthesisApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "CIF data-based supervisory controller synthesis tool";
    }

    public String getAppDescription() {
        return "Synthesizes a supervisory controller for a CIF specification with data.";
    }

    protected int runInternal() {
        CifDataSynthesisSettings settings = new CifDataSynthesisSettings();
        settings.setTermination(() -> this.isTerminationRequested());
        settings.setDebugOutput(this.getAppEnvData().getProvider().getDebugOutputStream());
        settings.setNormalOutput(this.getAppEnvData().getProvider().getNormalOutputStream());
        settings.setWarnOutput(this.getAppEnvData().getProvider().getWarningOutputStream());
        settings.setIndentAmount(4);
        settings.setDoPlantsRefReqsWarn(PlantsRefReqsWarnOption.isEnabled());
        settings.setAllowNonDeterminism(AllowNonDeterminism.UNCONTROLLABLE);
        settings.setAdhereToExecScheme(false);
        settings.setBddExtraVarDomainNames(new String[0]);
        settings.setBddInitNodeTableSize(BddInitNodeTableSizeOption.getInitialSize());
        settings.setBddOpCacheRatio(BddOpCacheRatioOption.getCacheRatio());
        settings.setBddOpCacheSize(BddOpCacheSizeOption.getCacheSize());
        settings.setBddVarOrderInit(BddVariableOrderOption.getOrder());
        settings.setBddDcshEnabled(BddDcshVarOrderOption.isEnabled());
        settings.setBddForceEnabled(BddForceVarOrderOption.isEnabled());
        settings.setBddSlidingWindowEnabled(BddSlidingWindowVarOrderOption.isEnabled());
        settings.setBddSlidingWindowMaxLen(BddSlidingWindowSizeOption.getMaxLen());
        settings.setBddVarOrderAdvanced(BddAdvancedVariableOrderOption.getOrder());
        settings.setBddHyperEdgeAlgo(BddHyperEdgeAlgoOption.getAlgo());
        settings.setBddDebugMaxNodes(BddDebugMaxNodesOption.getMaximum());
        settings.setBddDebugMaxPaths(BddDebugMaxPathsOption.getMaximum());
        settings.setEdgeGranularity(EdgeGranularityOption.getGranularity());
        settings.setEdgeOrderBackward(EdgeOrderBackwardOption.getOrder());
        settings.setEdgeOrderForward(EdgeOrderForwardOption.getOrder());
        settings.setEdgeOrderAllowDuplicateEvents(EdgeOrderDuplicateEventsOption.getAllowance());
        settings.setCifBddStatistics(SynthesisStatistics.toCifBdd(SynthesisStatisticsOption.getStatistics()));
        settings.setDoNeverEnabledEventsWarn(EventWarnOption.isEnabled());
        settings.setStateReqInvEnforceMode(StateReqInvEnforceOption.getMode());
        settings.setFixedPointComputationsOrder(FixedPointComputationsOrderOption.getOrder());
        settings.setExplorationStrategy(ExplorationStrategyOption.getStrategy());
        settings.setDoForwardReach(ForwardReachOption.isEnabled());
        settings.setSupervisorName(SupervisorNameOption.getSupervisorName());
        settings.setSupervisorNamespace(SupervisorNamespaceOption.getNamespace());
        settings.setBddOutputMode(BddOutputOption.getMode());
        settings.setBddOutputNamePrefix(BddOutputNamePrefixOption.getPrefix());
        settings.setBddSimplifications(BddSimplifyOption.getSimplifications());
        settings.setSynthesisStatistics(SynthesisStatisticsOption.getStatistics());
        settings.setContinuousPerformanceStatisticsFilePath(ContinuousPerformanceStatisticsFileOption.getPath());
        settings.setContinuousPerformanceStatisticsFileAbsPath(Paths.resolve((String)ContinuousPerformanceStatisticsFileOption.getPath()));
        settings.setModificationAllowed(false);
        boolean doTiming = settings.getSynthesisStatistics().contains((Object)SynthesisStatistics.TIMING);
        CifDataSynthesisTiming timing = new CifDataSynthesisTiming();
        if (doTiming) {
            timing.total.start();
        }
        try {
            String inputPath = InputFileOption.getPath();
            String absInputPath = Paths.resolve((String)inputPath);
            this.doSynthesis(new PathPair(inputPath, absInputPath), settings, timing);
        }
        finally {
            if (doTiming) {
                timing.total.stop();
                timing.print(settings.getIndentAmount(), settings.getDebugOutput(), settings.getNormalOutput(), settings.getFixedPointComputationsOrder());
            }
        }
        return 0;
    }

    private void doSynthesis(PathPair inputPair, CifDataSynthesisSettings settings, CifDataSynthesisTiming timing) {
        boolean dbgEnabled = settings.getDebugOutput().isEnabled();
        boolean doTiming = settings.getSynthesisStatistics().contains((Object)SynthesisStatistics.TIMING);
        Termination termination = settings.getTermination();
        Specification spec = this.loadCifSpec(inputPair.userPath, inputPair.systemPath, timing, doTiming, dbgEnabled);
        if (termination.isRequested()) {
            return;
        }
        String absInputDir = Paths.getAbsFilePathDir((String)inputPair.systemPath);
        Specification resultSpec = CifDataSynthesis.doSynthesisOnSpec(spec, inputPair.systemPath, absInputDir, settings, timing);
        if (termination.isRequested()) {
            return;
        }
        String outPath = OutputFileOption.getDerivedPath((String)".cif", (String)".ctrlsys.cif");
        String absOutPath = Paths.resolve((String)outPath);
        this.writeCifSpec(resultSpec, absInputDir, timing, doTiming, dbgEnabled, new PathPair(outPath, absOutPath));
        if (termination.isRequested()) {
            return;
        }
    }

    private Specification loadCifSpec(String inputPath, String absInputPath, CifDataSynthesisTiming timing, boolean doTiming, boolean dbgEnabled) {
        Specification spec;
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Reading CIF file \"%s\".", (Object[])new Object[]{inputPath});
        }
        CifReader cifReader = (CifReader)new CifReader().init(inputPath, absInputPath, false);
        if (doTiming) {
            timing.inputRead.start();
        }
        try {
            spec = (Specification)cifReader.read();
        }
        finally {
            if (doTiming) {
                timing.inputRead.stop();
            }
        }
        return spec;
    }

    private void writeCifSpec(Specification resultSpec, String absInputDir, CifDataSynthesisTiming timing, boolean doTiming, boolean dbgEnabled, PathPair outputPair) {
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Writing output CIF file \"%s\".", (Object[])new Object[]{outputPair.userPath});
        }
        if (doTiming) {
            timing.outputWrite.start();
        }
        try {
            CifWriter.writeCifSpec((Specification)resultSpec, (PathPair)outputPair, (String)absInputDir);
        }
        finally {
            if (doTiming) {
                timing.outputWrite.stop();
            }
        }
    }

    protected OutputProvider<IOutputComponent> createProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = CifDataSynthesisApp.getGeneralOptionCategory();
        List bddOpts = Lists.list();
        bddOpts.add(Options.getInstance(BddOutputOption.class));
        bddOpts.add(Options.getInstance(BddOutputNamePrefixOption.class));
        bddOpts.add(Options.getInstance(BddVariableOrderOption.class));
        bddOpts.add(Options.getInstance(BddHyperEdgeAlgoOption.class));
        bddOpts.add(Options.getInstance(BddDcshVarOrderOption.class));
        bddOpts.add(Options.getInstance(BddForceVarOrderOption.class));
        bddOpts.add(Options.getInstance(BddSlidingWindowVarOrderOption.class));
        bddOpts.add(Options.getInstance(BddSlidingWindowSizeOption.class));
        bddOpts.add(Options.getInstance(BddAdvancedVariableOrderOption.class));
        bddOpts.add(Options.getInstance(BddSimplifyOption.class));
        bddOpts.add(Options.getInstance(BddInitNodeTableSizeOption.class));
        bddOpts.add(Options.getInstance(BddOpCacheSizeOption.class));
        bddOpts.add(Options.getInstance(BddOpCacheRatioOption.class));
        bddOpts.add(Options.getInstance(BddDebugMaxNodesOption.class));
        bddOpts.add(Options.getInstance(BddDebugMaxPathsOption.class));
        OptionCategory bddCat = new OptionCategory("BDD", "BDD options.", Lists.list(), bddOpts);
        List synthOpts = Lists.list();
        synthOpts.add(Options.getInstance(InputFileOption.class));
        synthOpts.add(Options.getInstance(OutputFileOption.class));
        synthOpts.add(Options.getInstance(SupervisorNameOption.class));
        synthOpts.add(Options.getInstance(SupervisorNamespaceOption.class));
        synthOpts.add(Options.getInstance(ForwardReachOption.class));
        synthOpts.add(Options.getInstance(FixedPointComputationsOrderOption.class));
        synthOpts.add(Options.getInstance(ExplorationStrategyOption.class));
        synthOpts.add(Options.getInstance(EdgeGranularityOption.class));
        synthOpts.add(Options.getInstance(EdgeOrderOption.class));
        synthOpts.add(Options.getInstance(EdgeOrderBackwardOption.class));
        synthOpts.add(Options.getInstance(EdgeOrderForwardOption.class));
        synthOpts.add(Options.getInstance(EdgeOrderDuplicateEventsOption.class));
        synthOpts.add(Options.getInstance(EdgeWorksetAlgoOption.class));
        synthOpts.add(Options.getInstance(StateReqInvEnforceOption.class));
        synthOpts.add(Options.getInstance(SynthesisStatisticsOption.class));
        synthOpts.add(Options.getInstance(ContinuousPerformanceStatisticsFileOption.class));
        synthOpts.add(Options.getInstance(EventWarnOption.class));
        synthOpts.add(Options.getInstance(PlantsRefReqsWarnOption.class));
        OptionCategory synthCat = new OptionCategory("Synthesis", "Synthesis options.", Lists.list((Object)bddCat), synthOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, synthCat});
        OptionCategory options = new OptionCategory("CIF Data-based Synthesis Options", "All options for the CIF data-based supervisory controller synthesis tool.", cats, Lists.list());
        return options;
    }
}

