/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.merger;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.RefReplace;
import org.eclipse.escet.cif.common.CifControllerPropertiesAnnotationUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifPartialSpecAnnotationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifMerger {
    private static final boolean CHECK_GET_CHILDREN_MAP_CONSISTENCY = false;
    private Map<PositionObject, Expression> refExprReplacements = Maps.map();
    private Map<Declaration, CifType> refTypeReplacements = Maps.map();

    public Specification merge(Specification spec1, Specification spec2, boolean makePartial) {
        Specification merged = (Specification)this.merge((ComplexComponent)spec1, (ComplexComponent)spec2);
        RefReplace replacer = new RefReplace(this.refExprReplacements, this.refTypeReplacements, Collections.emptyMap());
        replacer.transform(merged);
        CifControllerPropertiesAnnotationUtils.remove((Specification)merged);
        CifPartialSpecAnnotationUtils.makeNonPartial((Specification)merged);
        if (makePartial) {
            CifPartialSpecAnnotationUtils.makePartial((Specification)merged);
        }
        return merged;
    }

    private ComplexComponent merge(ComplexComponent comp1, ComplexComponent comp2) {
        ComplexComponent otherComp;
        ComplexComponent mergedComp;
        if (comp1 instanceof Group && comp2 instanceof Group) {
            mergedComp = comp1;
            otherComp = comp2;
        } else {
            if (comp1 instanceof Automaton && comp2 instanceof Automaton) {
                throw new RuntimeException("Merging two automata not allowed.");
            }
            if (comp1 instanceof Automaton && comp2 instanceof Group) {
                this.checkGroupForAutMerge((Group)comp2);
                mergedComp = comp1;
                otherComp = comp2;
            } else if (comp1 instanceof Group && comp2 instanceof Automaton) {
                this.checkGroupForAutMerge((Group)comp1);
                mergedComp = comp2;
                otherComp = comp1;
            } else {
                String msg = Strings.fmt((String)"Unknown components: %s / %s", (Object[])new Object[]{comp1, comp2});
                throw new RuntimeException(msg);
            }
        }
        mergedComp.getAnnotations().addAll((Collection)otherComp.getAnnotations());
        mergedComp.getInitials().addAll((Collection)otherComp.getInitials());
        mergedComp.getMarkeds().addAll((Collection)otherComp.getMarkeds());
        mergedComp.getInvariants().addAll((Collection)otherComp.getInvariants().stream().filter(inv -> inv.getName() == null).collect(Collectors.toList()));
        mergedComp.getEquations().addAll((Collection)otherComp.getEquations());
        mergedComp.getIoDecls().addAll((Collection)otherComp.getIoDecls());
        this.mergeChildren(comp1, comp2, mergedComp);
        return mergedComp;
    }

    private Declaration merge(Declaration decl1, Declaration decl2) {
        if (decl1 instanceof Event && decl2 instanceof Event) {
            return this.merge((Event)decl1, (Event)decl2);
        }
        if (decl1 instanceof InputVariable && decl2 instanceof InputVariable) {
            return this.merge((InputVariable)decl1, (InputVariable)decl2);
        }
        if (decl1 instanceof DiscVariable && decl2 instanceof InputVariable) {
            return this.merge((DiscVariable)decl1, (InputVariable)decl2);
        }
        if (decl1 instanceof InputVariable && decl2 instanceof DiscVariable) {
            return this.merge((DiscVariable)decl2, (InputVariable)decl1);
        }
        if (decl1 instanceof ContVariable && decl2 instanceof InputVariable) {
            return this.merge((ContVariable)decl1, (InputVariable)decl2);
        }
        if (decl1 instanceof InputVariable && decl2 instanceof ContVariable) {
            return this.merge((ContVariable)decl2, (InputVariable)decl1);
        }
        if (decl1 instanceof AlgVariable && decl2 instanceof InputVariable) {
            return this.merge((AlgVariable)decl1, (InputVariable)decl2);
        }
        if (decl1 instanceof InputVariable && decl2 instanceof AlgVariable) {
            return this.merge((AlgVariable)decl2, (InputVariable)decl1);
        }
        if (decl1 instanceof Constant && decl2 instanceof InputVariable) {
            return this.merge((Constant)decl1, (InputVariable)decl2);
        }
        if (decl1 instanceof InputVariable && decl2 instanceof Constant) {
            return this.merge((Constant)decl2, (InputVariable)decl1);
        }
        if (decl1 instanceof Constant && decl2 instanceof Constant) {
            return this.merge((Constant)decl1, (Constant)decl2);
        }
        if (decl1 instanceof TypeDecl && decl2 instanceof TypeDecl) {
            return this.merge((TypeDecl)decl1, (TypeDecl)decl2);
        }
        if (decl1 instanceof EnumDecl && decl2 instanceof EnumDecl) {
            return this.merge((EnumDecl)decl1, (EnumDecl)decl2);
        }
        if (decl1 instanceof EnumDecl && decl2 instanceof TypeDecl) {
            return this.merge((EnumDecl)decl1, (TypeDecl)decl2);
        }
        if (decl1 instanceof TypeDecl && decl2 instanceof EnumDecl) {
            return this.merge((EnumDecl)decl2, (TypeDecl)decl1);
        }
        String msg = Strings.fmt((String)"Unmergeable decls: %s / %s", (Object[])new Object[]{decl1, decl2});
        throw new RuntimeException(msg);
    }

    private InputVariable merge(InputVariable var1, InputVariable var2) {
        CifType type2;
        CifType type1 = var1.getType();
        if (!CifTypeUtils.checkTypeCompat((CifType)type1, (CifType)(type2 = var2.getType()), (RangeCompat)RangeCompat.EQUAL)) {
            String msg = Strings.fmt((String)"Merging input variables with name \"%s\" failed: types \"%s\" and \"%s\" are not compatible.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var1), CifTextUtils.typeToStr((CifType)type1), CifTextUtils.typeToStr((CifType)type2)});
            throw new UnsupportedException(msg);
        }
        InputVariableExpression varRef = CifConstructors.newInputVariableExpression();
        varRef.setVariable(var1);
        varRef.setType((CifType)EMFHelper.deepclone((EObject)type1));
        this.refExprReplacements.put((PositionObject)var2, (Expression)varRef);
        var1.getAnnotations().addAll((Collection)var2.getAnnotations());
        return var1;
    }

    private DiscVariable merge(DiscVariable discVar, InputVariable inputVar) {
        CifType inputType;
        CifType discType = discVar.getType();
        if (!CifTypeUtils.checkTypeCompat((CifType)discType, (CifType)(inputType = inputVar.getType()), (RangeCompat)RangeCompat.EQUAL)) {
            String msg = Strings.fmt((String)"Merging a discrete variable and input variable with name \"%s\" failed: types \"%s\" and \"%s\" are not compatible.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)discVar), CifTextUtils.typeToStr((CifType)discType), CifTextUtils.typeToStr((CifType)inputType)});
            throw new UnsupportedException(msg);
        }
        DiscVariableExpression varRef = CifConstructors.newDiscVariableExpression();
        varRef.setVariable(discVar);
        varRef.setType((CifType)EMFHelper.deepclone((EObject)discType));
        this.refExprReplacements.put((PositionObject)inputVar, (Expression)varRef);
        discVar.getAnnotations().addAll((Collection)inputVar.getAnnotations());
        return discVar;
    }

    private Location merge(Location loc, InputVariable inputVar) {
        Assert.check((loc.getName() != null ? 1 : 0) != 0);
        CifType type = inputVar.getType();
        CifType ntype = CifTypeUtils.normalizeType((CifType)type);
        if (!(ntype instanceof BoolType)) {
            String msg = Strings.fmt((String)"Merging a location and input variable with name \"%s\" failed: type \"%s\" of the input variable is not a boolean type.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)loc), CifTextUtils.typeToStr((CifType)type)});
            throw new UnsupportedException(msg);
        }
        LocationExpression locRef = CifConstructors.newLocationExpression();
        locRef.setLocation(loc);
        locRef.setType((CifType)CifConstructors.newBoolType());
        this.refExprReplacements.put((PositionObject)inputVar, (Expression)locRef);
        loc.getAnnotations().addAll((Collection)inputVar.getAnnotations());
        return loc;
    }

    private ContVariable merge(ContVariable contVar, InputVariable inputVar) {
        CifType inputType;
        RealType contType = CifConstructors.newRealType();
        if (!CifTypeUtils.checkTypeCompat((CifType)contType, (CifType)(inputType = inputVar.getType()), (RangeCompat)RangeCompat.EQUAL)) {
            String msg = Strings.fmt((String)"Merging a continuous variable and input variable with name \"%s\" failed: types \"%s\" and \"%s\" are not compatible.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)contVar), CifTextUtils.typeToStr((CifType)contType), CifTextUtils.typeToStr((CifType)inputType)});
            throw new UnsupportedException(msg);
        }
        ContVariableExpression varRef = CifConstructors.newContVariableExpression();
        varRef.setVariable(contVar);
        varRef.setType((CifType)EMFHelper.deepclone((EObject)contType));
        this.refExprReplacements.put((PositionObject)inputVar, (Expression)varRef);
        contVar.getAnnotations().addAll((Collection)inputVar.getAnnotations());
        return contVar;
    }

    private AlgVariable merge(AlgVariable algVar, InputVariable inputVar) {
        CifType inputType;
        CifType algType = algVar.getType();
        if (!CifTypeUtils.checkTypeCompat((CifType)algType, (CifType)(inputType = inputVar.getType()), (RangeCompat)RangeCompat.EQUAL)) {
            String msg = Strings.fmt((String)"Merging an algebraic variable and input variable with name \"%s\" failed: types \"%s\" and \"%s\" are not compatible.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)algVar), CifTextUtils.typeToStr((CifType)algType), CifTextUtils.typeToStr((CifType)inputType)});
            throw new UnsupportedException(msg);
        }
        AlgVariableExpression varRef = CifConstructors.newAlgVariableExpression();
        varRef.setVariable(algVar);
        varRef.setType((CifType)EMFHelper.deepclone((EObject)algType));
        this.refExprReplacements.put((PositionObject)inputVar, (Expression)varRef);
        algVar.getAnnotations().addAll((Collection)inputVar.getAnnotations());
        return algVar;
    }

    private Constant merge(Constant constant, InputVariable inputVar) {
        CifType inputType;
        CifType constType = constant.getType();
        if (!CifTypeUtils.checkTypeCompat((CifType)constType, (CifType)(inputType = inputVar.getType()), (RangeCompat)RangeCompat.EQUAL)) {
            String msg = Strings.fmt((String)"Merging a constant and input variable with name \"%s\" failed: types \"%s\" and \"%s\" are not compatible.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)constant), CifTextUtils.typeToStr((CifType)constType), CifTextUtils.typeToStr((CifType)inputType)});
            throw new UnsupportedException(msg);
        }
        ConstantExpression constRef = CifConstructors.newConstantExpression();
        constRef.setConstant(constant);
        constRef.setType((CifType)EMFHelper.deepclone((EObject)constType));
        this.refExprReplacements.put((PositionObject)inputVar, (Expression)constRef);
        constant.getAnnotations().addAll((Collection)inputVar.getAnnotations());
        return constant;
    }

    private Constant merge(Constant constant1, Constant constant2) {
        Object value2;
        Object value1;
        CifType type2;
        CifType type1 = constant1.getType();
        if (!CifTypeUtils.checkTypeCompat((CifType)type1, (CifType)(type2 = constant2.getType()), (RangeCompat)RangeCompat.EQUAL)) {
            String msg = Strings.fmt((String)"Merging constants with name \"%s\" failed: types \"%s\" and \"%s\" are not compatible.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)constant1), CifTextUtils.typeToStr((CifType)type1), CifTextUtils.typeToStr((CifType)type2)});
            throw new UnsupportedException(msg);
        }
        if (!CifTypeUtils.supportsValueEquality((CifType)type1)) {
            String msg = Strings.fmt((String)"Merging constants with name \"%s\" failed: values of type \"%s\" can not be compared, and are thus not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)constant1), CifTextUtils.typeToStr((CifType)type1)});
            throw new UnsupportedException(msg);
        }
        try {
            value1 = CifEvalUtils.eval((Expression)constant1.getValue(), (boolean)false);
            value2 = CifEvalUtils.eval((Expression)constant2.getValue(), (boolean)false);
        }
        catch (CifEvalException e) {
            throw new RuntimeException(e);
        }
        if (!value1.equals(value2)) {
            String msg = Strings.fmt((String)"Merging constants with name \"%s\" failed: values \"%s\" and \"%s\" are not the same.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)constant1), CifEvalUtils.objToStr((Object)value1), CifEvalUtils.objToStr((Object)value2)});
            throw new UnsupportedException(msg);
        }
        ConstantExpression const1Ref = CifConstructors.newConstantExpression();
        const1Ref.setConstant(constant1);
        const1Ref.setType((CifType)EMFHelper.deepclone((EObject)type1));
        this.refExprReplacements.put((PositionObject)constant2, (Expression)const1Ref);
        constant1.getAnnotations().addAll((Collection)constant2.getAnnotations());
        return constant1;
    }

    private Event merge(Event event1, Event event2) {
        Boolean ctrl2;
        CifType type2;
        CifType type1 = event1.getType();
        if (type1 == null != ((type2 = event2.getType()) == null)) {
            String msg = Strings.fmt((String)"Merging events with name \"%s\" failed: the event is declared without a data type in one specification and with a data type in another.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event1)});
            throw new UnsupportedException(msg);
        }
        if (type1 != null && type2 != null && !CifTypeUtils.checkTypeCompat((CifType)type1, (CifType)type2, (RangeCompat)RangeCompat.EQUAL)) {
            String msg = Strings.fmt((String)"Merging events with name \"%s\" failed: types \"%s\" and \"%s\" are not compatible.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event1), CifTextUtils.typeToStr((CifType)type1), CifTextUtils.typeToStr((CifType)type2)});
            throw new UnsupportedException(msg);
        }
        Boolean ctrl1 = event1.getControllable();
        if (!Objects.equals(ctrl1, ctrl2 = event2.getControllable())) {
            String msg = Strings.fmt((String)"Merging events with name \"%s\" failed: the event is declared as \"%s\" in one specification and as \"%s\" in another.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event1), CifTextUtils.controllabilityToStr((Boolean)ctrl1), CifTextUtils.controllabilityToStr((Boolean)ctrl2)});
            throw new UnsupportedException(msg);
        }
        EventExpression eventRef = CifConstructors.newEventExpression();
        eventRef.setEvent(event1);
        eventRef.setType((CifType)CifConstructors.newBoolType());
        this.refExprReplacements.put((PositionObject)event2, (Expression)eventRef);
        event1.getAnnotations().addAll((Collection)event2.getAnnotations());
        return event1;
    }

    private TypeDecl merge(TypeDecl typeDecl1, TypeDecl typeDecl2) {
        CifType type2;
        CifType type1 = typeDecl1.getType();
        if (!CifTypeUtils.checkTypeCompat((CifType)type1, (CifType)(type2 = typeDecl2.getType()), (RangeCompat)RangeCompat.EQUAL)) {
            String msg = Strings.fmt((String)"Merging type declarations with name \"%s\" failed: types \"%s\" and \"%s\" are not compatible.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)typeDecl1), CifTextUtils.typeToStr((CifType)type1), CifTextUtils.typeToStr((CifType)type2)});
            throw new UnsupportedException(msg);
        }
        TypeRef typeRef = CifConstructors.newTypeRef();
        typeRef.setType(typeDecl1);
        this.refTypeReplacements.put((Declaration)typeDecl2, (CifType)typeRef);
        typeDecl1.getAnnotations().addAll((Collection)typeDecl2.getAnnotations());
        return typeDecl1;
    }

    private EnumDecl merge(EnumDecl enumDecl, TypeDecl typeDecl) {
        EnumType etype = CifConstructors.newEnumType();
        etype.setEnum(enumDecl);
        CifType ttype = typeDecl.getType();
        if (!CifTypeUtils.checkTypeCompat((CifType)etype, (CifType)ttype, (RangeCompat)RangeCompat.EQUAL)) {
            String msg = Strings.fmt((String)"Merging a type declaration and enumeration with name \"%s\" failed: type \"%s\" of the type declaration is not compatible with the type of the enumeration.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)enumDecl), CifTextUtils.typeToStr((CifType)ttype)});
            throw new UnsupportedException(msg);
        }
        this.refTypeReplacements.put((Declaration)typeDecl, (CifType)etype);
        enumDecl.getAnnotations().addAll((Collection)typeDecl.getAnnotations());
        return enumDecl;
    }

    private EnumDecl merge(EnumDecl enum1, EnumDecl enum2) {
        if (!CifTypeUtils.areEnumsCompatible((EnumDecl)enum1, (EnumDecl)enum2)) {
            String msg = Strings.fmt((String)"Merging enumerations with name \"%s\" failed: the enumerations are not compatible.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)enum1)});
            throw new UnsupportedException(msg);
        }
        EnumType enumRef = CifConstructors.newEnumType();
        enumRef.setEnum(enum1);
        this.refTypeReplacements.put((Declaration)enum2, (CifType)enumRef);
        int i = 0;
        while (i < enum1.getLiterals().size()) {
            EnumLiteral lit1 = (EnumLiteral)enum1.getLiterals().get(i);
            EnumLiteral lit2 = (EnumLiteral)enum2.getLiterals().get(i);
            EnumLiteralExpression litRef = CifConstructors.newEnumLiteralExpression();
            litRef.setLiteral(lit1);
            litRef.setType((CifType)EMFHelper.deepclone((EObject)enumRef));
            this.refExprReplacements.put((PositionObject)lit2, (Expression)litRef);
            lit1.getAnnotations().addAll((Collection)lit2.getAnnotations());
            ++i;
        }
        enum1.getAnnotations().addAll((Collection)enum2.getAnnotations());
        return enum1;
    }

    private void mergeChildren(ComplexComponent comp1, ComplexComponent comp2, ComplexComponent merged) {
        Assert.check((merged == comp1 || merged == comp2 ? 1 : 0) != 0);
        Map<String, PositionObject> childMap1 = this.getChildrenMap(comp1);
        Map<String, PositionObject> childMap2 = this.getChildrenMap(comp2);
        Set overlappingChildNames = Sets.set();
        overlappingChildNames.addAll(childMap1.keySet());
        overlappingChildNames.retainAll(childMap2.keySet());
        for (String overlappingChildName : overlappingChildNames) {
            PositionObject child1 = childMap1.get(overlappingChildName);
            PositionObject child2 = childMap2.get(overlappingChildName);
            this.checkMergeCompatibility(child1, child2);
        }
        Set childNames = Sets.set();
        childNames.addAll(childMap1.keySet());
        childNames.addAll(childMap2.keySet());
        for (String childName : childNames) {
            EObject child1 = (EObject)childMap1.get(childName);
            EObject child2 = (EObject)childMap2.get(childName);
            if (child1 == null && child2 != null) {
                if (comp2 == merged) continue;
                if (child2 instanceof Component) {
                    ((Group)comp1).getComponents().add((Object)((Component)child2));
                    continue;
                }
                if (child2 instanceof Declaration) {
                    comp1.getDeclarations().add((Object)((Declaration)child2));
                    continue;
                }
                if (child2 instanceof Invariant) {
                    comp1.getInvariants().add((Object)((Invariant)child2));
                    continue;
                }
                Assert.check((boolean)(child2 instanceof EnumLiteral));
                continue;
            }
            if (child1 != null && child2 == null) {
                if (comp1 == merged) continue;
                if (child1 instanceof Component) {
                    ((Group)comp2).getComponents().add((Object)((Component)child1));
                    continue;
                }
                if (child1 instanceof Declaration) {
                    comp2.getDeclarations().add((Object)((Declaration)child1));
                    continue;
                }
                if (child1 instanceof Invariant) {
                    comp1.getInvariants().add((Object)((Invariant)child1));
                    continue;
                }
                Assert.check((boolean)(child1 instanceof EnumLiteral));
                continue;
            }
            if (child1 != null && child2 != null) {
                EObject replaceChild;
                ComplexComponent mergedChild;
                boolean isLoc;
                if (child1 instanceof Component) {
                    isLoc = false;
                    mergedChild = this.merge((ComplexComponent)child1, (ComplexComponent)child2);
                } else if (child1 instanceof Location && child2 instanceof InputVariable) {
                    isLoc = true;
                    mergedChild = this.merge((Location)child1, (InputVariable)child2);
                } else if (child1 instanceof InputVariable && child2 instanceof Location) {
                    isLoc = true;
                    mergedChild = this.merge((Location)child2, (InputVariable)child1);
                } else {
                    if (child1 instanceof EnumLiteral && child2 instanceof EnumLiteral) continue;
                    Assert.check((boolean)(child1 instanceof Declaration));
                    isLoc = false;
                    mergedChild = this.merge((Declaration)child1, (Declaration)child2);
                }
                EObject eObject = replaceChild = comp1 == merged ? child1 : child2;
                if (isLoc) {
                    Assert.check((replaceChild == mergedChild ? 1 : 0) != 0);
                    continue;
                }
                EMFHelper.updateParentContainment((EObject)replaceChild, (EObject)mergedChild);
                continue;
            }
            throw new RuntimeException("Child not in either component?");
        }
    }

    private Map<String, PositionObject> getChildrenMap(ComplexComponent comp) {
        PositionObject prev;
        Group group = comp instanceof Group ? (Group)comp : null;
        Automaton aut = comp instanceof Automaton ? (Automaton)comp : null;
        int size = comp.getDeclarations().size();
        size += comp.getInvariants().size();
        if (group != null) {
            size += group.getComponents().size();
        }
        if (aut != null) {
            size += aut.getLocations().size();
        }
        Map rslt = Maps.mapc((int)size);
        if (group != null) {
            for (Component child : group.getComponents()) {
                prev = (PositionObject)rslt.put(child.getName(), child);
                Assert.check((prev == null ? 1 : 0) != 0);
            }
        }
        if (aut != null) {
            for (Location loc : aut.getLocations()) {
                if (loc.getName() != null) {
                    prev = (PositionObject)rslt.put(loc.getName(), loc);
                    Assert.check((prev == null ? 1 : 0) != 0);
                }
                for (Invariant inv : loc.getInvariants()) {
                    if (inv.getName() == null) continue;
                    prev = (PositionObject)rslt.put(inv.getName(), inv);
                    Assert.check((prev == null ? 1 : 0) != 0);
                }
            }
        }
        for (Component child : comp.getDeclarations()) {
            prev = (PositionObject)rslt.put(child.getName(), child);
            Assert.check((prev == null ? 1 : 0) != 0);
            if (!(child instanceof EnumDecl)) continue;
            for (EnumLiteral lit : ((EnumDecl)child).getLiterals()) {
                prev = (PositionObject)rslt.put(lit.getName(), lit);
                Assert.check((prev == null ? 1 : 0) != 0);
            }
        }
        for (Invariant inv : comp.getInvariants()) {
            if (inv.getName() == null) continue;
            prev = (PositionObject)rslt.put(inv.getName(), inv);
            Assert.check((prev == null ? 1 : 0) != 0);
        }
        return rslt;
    }

    private void checkGroupForAutMerge(Group group) {
        if (!group.getComponents().isEmpty()) {
            String msg = Strings.fmt((String)"Merging group with name \"%s\" into an automaton with the same name failed: the group has child components.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)group)});
            throw new UnsupportedException(msg);
        }
        for (Declaration decl : group.getDeclarations()) {
            if (!(decl instanceof Function)) continue;
            Function func = (Function)decl;
            String msg = Strings.fmt((String)"Merging group with name \"%s\" into an automaton with the same name failed: the group contains function \"%s\".", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)group), func.getName()});
            throw new UnsupportedException(msg);
        }
    }

    private void checkMergeCompatibility(PositionObject obj1, PositionObject obj2) {
        if (!(obj1 instanceof Group && obj2 instanceof Group || obj1 instanceof Automaton && obj2 instanceof Group || obj1 instanceof Group && obj2 instanceof Automaton)) {
            if (obj1 instanceof Automaton && obj2 instanceof Automaton) {
                String msg = Strings.fmt((String)"Merging objects with name \"%s\" failed: merging two automata is not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)obj1)});
                throw new UnsupportedException(msg);
            }
            if (!(obj1 instanceof Event) || !(obj2 instanceof Event)) {
                if (obj1 instanceof AlgVariable && obj2 instanceof AlgVariable) {
                    String msg = Strings.fmt((String)"Merging objects with name \"%s\" failed: merging two algebraic variables is not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)obj1)});
                    throw new UnsupportedException(msg);
                }
                if (!(obj1 instanceof InputVariable && obj2 instanceof InputVariable || (obj1 instanceof DiscVariable || obj1 instanceof ContVariable || obj1 instanceof AlgVariable || obj1 instanceof Constant || obj1 instanceof Location) && obj2 instanceof InputVariable || obj1 instanceof InputVariable && (obj2 instanceof DiscVariable || obj2 instanceof ContVariable || obj2 instanceof AlgVariable || obj2 instanceof Constant || obj2 instanceof Location) || obj1 instanceof Constant && obj2 instanceof Constant || obj1 instanceof TypeDecl && obj2 instanceof TypeDecl || obj1 instanceof EnumDecl && obj2 instanceof EnumDecl || obj1 instanceof EnumDecl && obj2 instanceof TypeDecl || obj1 instanceof TypeDecl && obj2 instanceof EnumDecl)) {
                    if (obj1 instanceof EnumLiteral && obj2 instanceof EnumLiteral) {
                        EnumDecl enum1 = (EnumDecl)obj1.eContainer();
                        EnumDecl enum2 = (EnumDecl)obj2.eContainer();
                        if (!enum1.getName().equals(enum2.getName())) {
                            String msg = Strings.fmt((String)"Merging enumeration literals with names \"%s\" and \"%s\" failed: the literals are from enumerations \"%s\" and \"%s\", which have different names and are not merged.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)obj1), CifTextUtils.getAbsName((PositionObject)obj2), CifTextUtils.getAbsName((PositionObject)enum1), CifTextUtils.getAbsName((PositionObject)enum2)});
                            throw new UnsupportedException(msg);
                        }
                    } else {
                        if (obj1 instanceof ContVariable && obj2 instanceof ContVariable) {
                            String msg = Strings.fmt((String)"Merging objects with name \"%s\" failed: merging two continuous variables is not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)obj1)});
                            throw new UnsupportedException(msg);
                        }
                        if (obj1 instanceof Function && obj2 instanceof Function) {
                            String msg = Strings.fmt((String)"Merging objects with name \"%s\" failed: merging two functions is not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)obj1)});
                            throw new UnsupportedException(msg);
                        }
                        if (obj1 instanceof DiscVariable && obj2 instanceof DiscVariable) {
                            String msg = Strings.fmt((String)"Merging objects with name \"%s\" failed: merging two discrete variables is not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)obj1)});
                            throw new UnsupportedException(msg);
                        }
                        if (obj1 instanceof Invariant && obj2 instanceof Invariant) {
                            String msg = Strings.fmt((String)"Merging objects with name \"%s\" failed: merging two invariants is not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)obj1)});
                            throw new UnsupportedException(msg);
                        }
                        Assert.check((obj1.getClass() != obj2.getClass() ? 1 : 0) != 0);
                        String msg = Strings.fmt((String)"Merging objects with name \"%s\" failed: the objects are incompatible.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)obj1)});
                        throw new UnsupportedException(msg);
                    }
                }
            }
        }
    }
}

