/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.escet.cif.metamodel.cif.InputParameter;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;

public class CifAddressableUtils {
    private CifAddressableUtils() {
    }

    public static Declaration getVariable(Expression addr) {
        Expression expression = addr;
        Objects.requireNonNull(expression);
        Expression expression2 = expression;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DiscVariableExpression.class, ContVariableExpression.class, InputVariableExpression.class}, (Object)expression2, 0)) {
            case 0 -> {
                DiscVariableExpression daddr = (DiscVariableExpression)expression2;
                yield daddr.getVariable();
            }
            case 1 -> {
                ContVariableExpression caddr = (ContVariableExpression)expression2;
                yield caddr.getVariable();
            }
            case 2 -> {
                InputVariableExpression iaddr = (InputVariableExpression)expression2;
                if (iaddr.getVariable().eContainer() instanceof InputParameter) {
                    throw new AssertionError((Object)("Unsupported input parameter addressable: " + String.valueOf(addr)));
                }
                yield iaddr.getVariable();
            }
            default -> throw new AssertionError((Object)("Unexpected addressable: " + String.valueOf(addr)));
        };
    }

    public static List<Expression> getRefExprs(Expression addr) {
        Expression expression = addr;
        Objects.requireNonNull(expression);
        Expression expression2 = expression;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TupleExpression.class, ProjectionExpression.class, CompInstWrapExpression.class, CompParamWrapExpression.class}, (Object)expression2, 0)) {
            case 0 -> {
                TupleExpression tupleAddr = (TupleExpression)expression2;
                List rslt = Lists.list();
                for (Expression elem : tupleAddr.getFields()) {
                    rslt.addAll(CifAddressableUtils.getRefExprs(elem));
                }
                yield rslt;
            }
            case 1 -> {
                ProjectionExpression projAddr = (ProjectionExpression)expression2;
                while (addr instanceof ProjectionExpression) {
                    ProjectionExpression p = (ProjectionExpression)addr;
                    addr = p.getChild();
                }
                yield Lists.list((Object)addr);
            }
            case 2 -> {
                CompInstWrapExpression wrap = (CompInstWrapExpression)expression2;
                throw new AssertionError((Object)("Unsupported addressable: " + String.valueOf(wrap)));
            }
            case 3 -> {
                CompParamWrapExpression wrap = (CompParamWrapExpression)expression2;
                throw new AssertionError((Object)("Unsupported addressable: " + String.valueOf(wrap)));
            }
            default -> Lists.list((Object)addr);
        };
    }

    public static Set<Declaration> getRefs(Expression addr) throws DuplVarAsgnException {
        List<Expression> refExprs = CifAddressableUtils.getRefExprs(addr);
        Set rslt = Sets.set();
        for (Expression refExpr : refExprs) {
            Expression expression;
            Objects.requireNonNull(refExpr);
            rslt.add(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DiscVariableExpression.class, ContVariableExpression.class, InputVariableExpression.class}, (Object)expression, 0)) {
                case 0 -> {
                    DiscVariableExpression discRef = (DiscVariableExpression)expression;
                    yield discRef.getVariable();
                }
                case 1 -> {
                    ContVariableExpression contRef = (ContVariableExpression)expression;
                    yield contRef.getVariable();
                }
                case 2 -> {
                    InputVariableExpression inputRef = (InputVariableExpression)expression;
                    if (inputRef.getVariable().eContainer() instanceof InputParameter) {
                        throw new AssertionError((Object)("Unsupported input parameter addressable: " + String.valueOf(addr)));
                    }
                    yield inputRef.getVariable();
                }
                default -> throw new AssertionError((Object)("Unexpected addressable: " + String.valueOf(addr)));
            });
        }
        if (refExprs.size() != rslt.size()) {
            throw new DuplVarAsgnException();
        }
        return rslt;
    }

    public static boolean hasProjs(Expression addr) {
        Expression expression = addr;
        Objects.requireNonNull(expression);
        Expression expression2 = expression;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TupleExpression.class, ProjectionExpression.class, DiscVariableExpression.class, ContVariableExpression.class, InputVariableExpression.class, CompInstWrapExpression.class, CompParamWrapExpression.class}, (Object)expression2, 0)) {
            case 0 -> {
                TupleExpression tupleAddr = (TupleExpression)expression2;
                yield tupleAddr.getFields().stream().anyMatch(f -> CifAddressableUtils.hasProjs(f));
            }
            case 1 -> {
                ProjectionExpression projAddr = (ProjectionExpression)expression2;
                yield true;
            }
            case 2 -> {
                DiscVariableExpression discAddr = (DiscVariableExpression)expression2;
                yield false;
            }
            case 3 -> {
                ContVariableExpression contAddr = (ContVariableExpression)expression2;
                yield false;
            }
            case 4 -> {
                InputVariableExpression inputAddr = (InputVariableExpression)expression2;
                yield false;
            }
            case 5 -> {
                CompInstWrapExpression compInstWrapAddr = (CompInstWrapExpression)expression2;
                yield CifAddressableUtils.hasProjs(compInstWrapAddr.getReference());
            }
            case 6 -> {
                CompParamWrapExpression compParamWrapAddr = (CompParamWrapExpression)expression2;
                yield CifAddressableUtils.hasProjs(compParamWrapAddr.getReference());
            }
            default -> throw new AssertionError((Object)("Unknown addressable: " + String.valueOf(addr)));
        };
    }

    public static <T extends Collection<ProjectionExpression>> T collectProjs(Expression addr, T collected) {
        if (addr instanceof TupleExpression) {
            TupleExpression tupleAddr = (TupleExpression)addr;
            for (Expression field : tupleAddr.getFields()) {
                CifAddressableUtils.collectProjs(field, collected);
            }
            return collected;
        }
        if (addr instanceof ProjectionExpression) {
            ProjectionExpression projExpr = (ProjectionExpression)addr;
            CifAddressableUtils.collectProjs(projExpr.getChild(), collected);
            collected.add((ProjectionExpression)projExpr);
            return collected;
        }
        if (addr instanceof DiscVariableExpression) {
            return collected;
        }
        if (addr instanceof ContVariableExpression) {
            return collected;
        }
        if (addr instanceof InputVariableExpression) {
            return collected;
        }
        if (addr instanceof CompInstWrapExpression) {
            CompInstWrapExpression compInstWrapAddr = (CompInstWrapExpression)addr;
            CifAddressableUtils.collectProjs(compInstWrapAddr.getReference(), collected);
            return collected;
        }
        if (addr instanceof CompParamWrapExpression) {
            CompParamWrapExpression compParamWrapAddr = (CompParamWrapExpression)addr;
            CifAddressableUtils.collectProjs(compParamWrapAddr.getReference(), collected);
            return collected;
        }
        throw new AssertionError((Object)("Unknown addressable: " + String.valueOf(addr)));
    }

    public static Expression stripProjs(Expression addr) {
        Expression rslt = addr;
        while (rslt instanceof ProjectionExpression) {
            ProjectionExpression projExpr = (ProjectionExpression)rslt;
            rslt = projExpr.getChild();
        }
        return rslt;
    }

    public static List<ProjectionExpression> collectProjs(Expression addr) {
        Assert.check((!(addr instanceof TupleExpression) ? 1 : 0) != 0);
        Assert.check((!(addr instanceof CompInstWrapExpression) ? 1 : 0) != 0);
        Assert.check((!(addr instanceof CompParamWrapExpression) ? 1 : 0) != 0);
        List rslt = Lists.list();
        while (addr instanceof ProjectionExpression) {
            ProjectionExpression paddr = (ProjectionExpression)addr;
            rslt.add(paddr);
            addr = paddr.getChild();
        }
        rslt = Lists.reverse((List)rslt);
        return rslt;
    }

    public static void collectAddrVars(List<Update> updates, Set<Declaration> vars) {
        for (Update update : updates) {
            CifAddressableUtils.collectAddrVars(update, vars);
        }
    }

    public static void collectAddrVars(Update update, Set<Declaration> vars) {
        if (update instanceof IfUpdate) {
            IfUpdate ifUpd = (IfUpdate)update;
            CifAddressableUtils.collectAddrVars((List<Update>)ifUpd.getThens(), vars);
            for (ElifUpdate elifUpd : ifUpd.getElifs()) {
                CifAddressableUtils.collectAddrVars((List<Update>)elifUpd.getThens(), vars);
            }
            CifAddressableUtils.collectAddrVars((List<Update>)ifUpd.getElses(), vars);
        } else {
            Assignment asgn = (Assignment)update;
            CifAddressableUtils.collectAddrVars(asgn.getAddressable(), vars);
        }
    }

    public static void collectAddrVars(Expression addr, Set<Declaration> vars) {
        if (addr instanceof TupleExpression) {
            TupleExpression tupleAddr = (TupleExpression)addr;
            for (Expression elem : tupleAddr.getFields()) {
                CifAddressableUtils.collectAddrVars(elem, vars);
            }
        } else if (addr instanceof ProjectionExpression) {
            while (addr instanceof ProjectionExpression) {
                ProjectionExpression p = (ProjectionExpression)addr;
                addr = p.getChild();
            }
            CifAddressableUtils.collectAddrVars(addr, vars);
        } else if (addr instanceof DiscVariableExpression) {
            DiscVariableExpression discRef = (DiscVariableExpression)addr;
            vars.add((Declaration)discRef.getVariable());
        } else if (addr instanceof ContVariableExpression) {
            ContVariableExpression contRef = (ContVariableExpression)addr;
            vars.add((Declaration)contRef.getVariable());
        } else if (addr instanceof InputVariableExpression) {
            InputVariableExpression inputRef = (InputVariableExpression)addr;
            if (inputRef.getVariable().eContainer() instanceof InputParameter) {
                throw new RuntimeException("Unsupported input parameter addressable: " + String.valueOf(addr));
            }
            vars.add((Declaration)inputRef.getVariable());
        } else {
            throw new RuntimeException("Unknown addr: " + String.valueOf(addr));
        }
    }

    public static void collectAddrVars(Automaton aut, Set<Declaration> vars) {
        for (Location loc : aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                CifAddressableUtils.collectAddrVars((List<Update>)edge.getUpdates(), vars);
            }
        }
    }

    public static class DuplVarAsgnException
    extends Exception {
    }
}

