/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.random;

import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.data.random.BooleanDistribution;
import org.eclipse.escet.chi.runtime.data.random.RandomGenerator;
import org.eclipse.escet.common.java.Strings;

public class BernoulliDistribution
extends BooleanDistribution {
    private RandomGenerator randGen;
    private double chance;

    public BernoulliDistribution(ChiCoordinator chiCoordinator, double chance) {
        super(chiCoordinator);
        if (chance < 0.0 || chance > 1.0) {
            String msg = Strings.fmt((String)"The Bernoulli distribution expects the chance parameter to be in the range [0.0..1.0], found chance %s instead.", (Object[])new Object[]{chance});
            throw new ChiSimulatorException(msg);
        }
        this.chance = chance;
        this.randGen = chiCoordinator.getFreshGenerator();
    }

    @Override
    public boolean sample() {
        return BernoulliDistribution.drawBernoulli(this.randGen, this.chance);
    }

    public static boolean drawBernoulli(RandomGenerator randGen, double chance) {
        return randGen.draw() < chance;
    }
}

