//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2024, 2026 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

package org.eclipse.escet.cif.datasynth.settings;

import java.util.EnumSet;

/** Defaults for CIF data-based synthesis-related {@link CifDataSynthesisSettings settings}. */
public class CifDataSynthesisSettingsDefaults {
    /** The default value of the {@link CifDataSynthesisSettings#getDoNeverEnabledEventsWarn} setting. */
    public static final boolean DO_NEVER_ENABLED_EVENTS_WARN_DEFAULT = true;

    /** The default value of the {@link CifDataSynthesisSettings#getStateReqInvEnforceMode} setting. */
    public static final StateReqInvEnforceMode STATE_REQ_INV_ENFORCE_MODE_DEFAULT = StateReqInvEnforceMode.ALL_CTRL_BEH;

    /** The default value of the {@link CifDataSynthesisSettings#getFixedPointComputationsOrder} setting. */
    public static final FixedPointComputationsOrder FIXED_POINT_COMPUTATIONS_ORDER_DEFAULT = new FixedPointComputationsOrder(
            FixedPointComputation.NONBLOCK, FixedPointComputation.REACH_REQS, FixedPointComputation.CTRL,
            FixedPointComputation.REACH);

    /** The default value of the {@link CifDataSynthesisSettings#getDoForwardReach} setting. */
    public static final boolean DO_FORWARD_REACH_DEFAULT = false;

    /** The default value of the {@link CifDataSynthesisSettings#getSupervisorName} setting. */
    public static final String SUPERVISOR_NAME_DEFAULT = "sup";

    /** The default value of the {@link CifDataSynthesisSettings#getSupervisorNamespace} setting. */
    public static final String SUPERVISOR_NAMESPACE_DEFAULT = null;

    /** The default value of the {@link CifDataSynthesisSettings#getBddOutputMode} setting. */
    public static final BddOutputMode BDD_OUTPUT_MODE_DEFAULT = BddOutputMode.NORMAL;

    /** The default value of the {@link CifDataSynthesisSettings#getBddOutputNamePrefix} setting. */
    public static final String BDD_OUTPUT_NAME_PREFIX = "bdd";

    /**
     * The default value of the {@link CifDataSynthesisSettings#getBddSimplifications} setting. Do not modify this set,
     * but {@link EnumSet#clone} it first.
     */
    public static final EnumSet<BddSimplify> BDD_SIMPLIFICATIONS_DEFAULT = EnumSet.allOf(BddSimplify.class);

    /**
     * The default value of the {@link CifDataSynthesisSettings#getSynthesisStatistics} setting. Do not modify this set,
     * but {@link EnumSet#clone} it first.
     */
    public static final EnumSet<SynthesisStatistics> SYNTHESIS_STATISTICS_DEFAULT = EnumSet
            .noneOf(SynthesisStatistics.class);

    /**
     * The default value of the {@link CifDataSynthesisSettings#getSynthesisFrees} setting. Do not modify this set, but
     * {@link EnumSet#clone} it first.
     */
    public static final EnumSet<CifDataSynthesisFree> SYNTHESIS_FREES_DEFAULT = EnumSet
            .allOf(CifDataSynthesisFree.class);

    /** Constructor for the {@link CifDataSynthesisSettingsDefaults} class. */
    private CifDataSynthesisSettingsDefaults() {
        // Static class.
    }
}
