/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.typecheck.symbols;

import java.util.List;
import org.eclipse.escet.chi.metamodel.chi.BehaviourDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ProcessDeclaration;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.chi.metamodel.java.ChiConstructors;
import org.eclipse.escet.chi.typecheck.CheckContext;
import org.eclipse.escet.chi.typecheck.Message;
import org.eclipse.escet.chi.typecheck.symbols.DeclarationSymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.SymbolEntry;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class ProcessDefSymbolEntry
extends DeclarationSymbolEntry {
    private ProcessDeclaration oldProcDef;
    private ProcessDeclaration useProcDef;
    private ProcessDeclaration fullProcDef;

    public ProcessDefSymbolEntry(ProcessDeclaration procDef, CheckContext ctxt) {
        super(true, ctxt);
        this.oldProcDef = procDef;
        this.useProcDef = null;
        this.fullProcDef = null;
    }

    @Override
    protected BehaviourDeclaration getOriginalDecl() {
        return this.oldProcDef;
    }

    public ProcessDeclaration getNewDecl() {
        Assert.check((boolean)this.useCheckDone());
        if (this.useProcDef == null) {
            throw new SemanticException();
        }
        return this.useProcDef;
    }

    @Override
    public String getName() {
        return this.oldProcDef.getName();
    }

    @Override
    public Position getPosition() {
        return this.oldProcDef.getPosition();
    }

    @Override
    public void typeCheckForUse() {
        if (this.useCheckDone()) {
            return;
        }
        this.checkState = SymbolEntry.TypeCheckState.USE_CHECK_DONE;
        List<VariableDeclaration> newParms = this.checkParameters(false);
        Type rtype = this.checkExitType(this.oldProcDef.getReturnType(), this.ctxt);
        this.useProcDef = ChiConstructors.newProcessDeclaration((String)this.oldProcDef.getName(), (Position)PositionUtils.copyPosition((PositionObject)this.oldProcDef), (Type)rtype, null, newParms);
    }

    @Override
    public void fullTypeCheck() {
        if (this.checkState == SymbolEntry.TypeCheckState.FULL_CHECK_DONE) {
            return;
        }
        try {
            this.typeCheckForUse();
        }
        finally {
            this.checkState = SymbolEntry.TypeCheckState.FULL_CHECK_DONE;
        }
        if (this.useProcDef == null) {
            return;
        }
        CheckContext chkCtxt = this.parameterCtxt.add(CheckContext.ContextItem.NO_MODELS);
        chkCtxt = chkCtxt.newExitContext(this.useProcDef.getReturnType());
        Assert.check((chkCtxt.funcReturnType == null ? 1 : 0) != 0);
        Assert.check((!chkCtxt.contains(CheckContext.ContextItem.NO_EXIT) ? 1 : 0) != 0);
        this.checkBody((BehaviourDeclaration)this.useProcDef, chkCtxt);
        this.fullProcDef = this.useProcDef;
    }

    @Override
    public void checkUsage(CheckContext ctxt) {
        if (this.isUsed) {
            return;
        }
        ctxt.addWarning(Message.UNUSED_PROCESS, this.getPosition(), this.getName());
    }

    public ProcessDeclaration getProcess() {
        Assert.check((this.checkState == SymbolEntry.TypeCheckState.FULL_CHECK_DONE ? 1 : 0) != 0);
        if (this.fullProcDef == null) {
            throw new SemanticException();
        }
        return this.fullProcDef;
    }
}

