/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.annotations.builtin;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotationArgument;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProblemReporter;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;

public class StateAnnotationProvider
extends AnnotationProvider {
    @Override
    public final void checkAnnotation(AnnotatedObject annotatedObject, Annotation annotation, AnnotationProblemReporter reporter) {
        if (!(annotatedObject instanceof Location)) {
            reporter.reportProblem(annotation, "state annotation on a non-location object.", annotation.getPosition(), SemanticProblemSeverity.ERROR);
            return;
        }
        for (AnnotationArgument arg : annotation.getArguments()) {
            if (arg.getName() == null) {
                reporter.reportProblem(annotation, "unsupported unnamed argument.", arg.getPosition(), SemanticProblemSeverity.ERROR);
                continue;
            }
            this.checkSupportedLiteral(annotation, arg, arg.getValue(), reporter);
        }
    }

    private void checkSupportedLiteral(Annotation annotation, AnnotationArgument arg, Expression value, AnnotationProblemReporter reporter) {
        CifType type = CifTypeUtils.normalizeType((CifType)value.getType());
        if (type instanceof BoolType) {
            if (!(value instanceof BoolExpression)) {
                this.reportNonLiteral(annotation, arg, value, reporter);
            }
        } else if (type instanceof IntType) {
            if (!this.evaluatesToItself(value)) {
                this.reportNonLiteral(annotation, arg, value, reporter);
            }
        } else if (type instanceof RealType) {
            if (!this.evaluatesToItself(value)) {
                this.reportNonLiteral(annotation, arg, value, reporter);
            }
        } else if (type instanceof StringType) {
            if (!(value instanceof StringExpression)) {
                this.reportNonLiteral(annotation, arg, value, reporter);
            }
        } else if (type instanceof TupleType) {
            if (!(value instanceof TupleExpression)) {
                this.reportNonLiteral(annotation, arg, value, reporter);
                return;
            }
            TupleExpression tvalue = (TupleExpression)value;
            for (Expression field : tvalue.getFields()) {
                this.checkSupportedLiteral(annotation, arg, field, reporter);
            }
        } else if (type instanceof ListType) {
            if (value instanceof CastExpression) {
                CastExpression cexpr = (CastExpression)value;
                value = cexpr.getChild();
            }
            if (!(value instanceof ListExpression)) {
                this.reportNonLiteral(annotation, arg, value, reporter);
                return;
            }
            ListExpression lvalue = (ListExpression)value;
            for (Expression element : lvalue.getElements()) {
                this.checkSupportedLiteral(annotation, arg, element, reporter);
            }
        } else if (type instanceof SetType) {
            if (value instanceof CastExpression) {
                CastExpression cexpr = (CastExpression)value;
                value = cexpr.getChild();
            }
            if (!(value instanceof SetExpression)) {
                this.reportNonLiteral(annotation, arg, value, reporter);
                return;
            }
            SetExpression svalue = (SetExpression)value;
            for (Expression element : svalue.getElements()) {
                this.checkSupportedLiteral(annotation, arg, element, reporter);
            }
        } else if (type instanceof DictType) {
            if (value instanceof CastExpression) {
                CastExpression cexpr = (CastExpression)value;
                value = cexpr.getChild();
            }
            if (!(value instanceof DictExpression)) {
                this.reportNonLiteral(annotation, arg, value, reporter);
                return;
            }
            DictExpression dvalue = (DictExpression)value;
            for (DictPair pair : dvalue.getPairs()) {
                this.checkSupportedLiteral(annotation, arg, pair.getKey(), reporter);
                this.checkSupportedLiteral(annotation, arg, pair.getValue(), reporter);
            }
        } else {
            reporter.reportProblem(annotation, Strings.fmt((String)"unsupported value of type \"%s\" in argument \"%s\".", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)value.getType()), arg.getName()}), value.getPosition(), SemanticProblemSeverity.ERROR);
        }
    }

    private boolean evaluatesToItself(Expression expr) {
        Expression evaluationResult;
        if (!CifValueUtils.hasSingleValue((Expression)expr, (boolean)false, (boolean)true)) {
            return false;
        }
        try {
            evaluationResult = CifEvalUtils.evalAsExpr((Expression)expr, (boolean)false);
        }
        catch (CifEvalException e) {
            return false;
        }
        return CifValueUtils.areStructurallySameExpression((Expression)expr, (Expression)evaluationResult);
    }

    private void reportNonLiteral(Annotation annotation, AnnotationArgument arg, Expression value, AnnotationProblemReporter reporter) {
        reporter.reportProblem(annotation, Strings.fmt((String)"non-literal value in argument \"%s\".", (Object[])new Object[]{arg.getName()}), value.getPosition(), SemanticProblemSeverity.ERROR);
    }

    @Override
    public final void checkGlobal(Specification spec, AnnotationProblemReporter reporter) {
        Map argNameToAnnoArg = Maps.map();
        for (Automaton aut : (List)CifCollectUtils.collectAutomata((ComplexComponent)spec, (Collection)Lists.list())) {
            boolean stateAnnoPresent = false;
            argNameToAnnoArg.clear();
            for (Location loc : aut.getLocations()) {
                for (Annotation anno : loc.getAnnotations()) {
                    if (!anno.getName().equals("state")) continue;
                    stateAnnoPresent = true;
                    for (AnnotationArgument arg : anno.getArguments()) {
                        if (arg.getName() == null) continue;
                        argNameToAnnoArg.putIfAbsent(arg.getName(), arg);
                    }
                }
            }
            if (!stateAnnoPresent) continue;
            for (Location loc : aut.getLocations()) {
                boolean locHasStateAnno = false;
                for (Annotation anno : loc.getAnnotations()) {
                    if (!anno.getName().equals("state")) continue;
                    locHasStateAnno = true;
                    List<String> annoArgNames = anno.getArguments().stream().filter(a -> a.getName() != null).map(a -> a.getName()).toList();
                    Set missingArgNames = Sets.difference(argNameToAnnoArg.keySet(), annoArgNames);
                    if (!missingArgNames.isEmpty()) {
                        String text = missingArgNames.stream().map(n -> Strings.fmt((String)"\"%s\"", (Object[])new Object[]{n})).collect(Collectors.joining(", "));
                        reporter.reportProblem(anno, Strings.fmt((String)"compared to other state annotations in the same automaton, one or more arguments are missing: %s.", (Object[])new Object[]{text}), anno.getPosition(), SemanticProblemSeverity.ERROR);
                    }
                    for (AnnotationArgument arg : anno.getArguments()) {
                        CifType otherType;
                        CifType argType;
                        AnnotationArgument otherArg;
                        if (arg.getName() == null || arg == (otherArg = (AnnotationArgument)argNameToAnnoArg.get(arg.getName())) || CifTypeUtils.checkTypeCompat((CifType)(argType = arg.getValue().getType()), (CifType)(otherType = otherArg.getValue().getType()), (RangeCompat)RangeCompat.IGNORE)) continue;
                        reporter.reportProblem(anno, Strings.fmt((String)"the \"%s\" type of the value of argument \"%s\" is incompatible with the \"%s\" type of the value of the same argument of another state annotation in the same automaton.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)argType), arg.getName(), CifTextUtils.typeToStr((CifType)otherType)}), arg.getPosition(), SemanticProblemSeverity.ERROR);
                        reporter.reportProblem(anno, Strings.fmt((String)"the \"%s\" type of the value of argument \"%s\" is incompatible with the \"%s\" type of the value of the same argument of another state annotation in the same automaton.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)otherType), arg.getName(), CifTextUtils.typeToStr((CifType)argType)}), otherArg.getPosition(), SemanticProblemSeverity.ERROR);
                    }
                }
                if (locHasStateAnno) continue;
                reporter.reportProblem("state", Strings.fmt((String)"%s must have a state annotation, as at least one other location in the same automaton has a state annotation.", (Object[])new Object[]{CifTextUtils.getLocationText2((Location)loc)}), loc.getPosition(), SemanticProblemSeverity.ERROR);
            }
        }
    }
}

