/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.commons.math3.linear.RealMatrix;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Pair;

public class BusComputing {
    private BusComputing() {
    }

    public static BitSet computeTopKBus(RealMatrix dependencies, int gamma) {
        BitSet all = BitSets.ones((int)dependencies.getRowDimension());
        return BusComputing.internalComputeTopKBus(dependencies, gamma, all);
    }

    public static BitSet computeTopKBus(RealMatrix dependencies, double gamma) {
        BitSet all = BitSets.ones((int)dependencies.getRowDimension());
        return BusComputing.internalComputeTopKBus(dependencies, (int)gamma, all);
    }

    public static BitSet computeTopKBus(RealMatrix dependencies, int gamma, BitSet availableNodes) {
        return BusComputing.internalComputeTopKBus(dependencies, gamma, BitSets.copy((BitSet)availableNodes));
    }

    public static BitSet computeTopKBus(RealMatrix dependencies, double gamma, BitSet availableNodes) {
        return BusComputing.internalComputeTopKBus(dependencies, (int)gamma, BitSets.copy((BitSet)availableNodes));
    }

    private static BitSet internalComputeTopKBus(RealMatrix dependencies, int gamma, BitSet nodeSet) {
        int[] degrees = BusComputing.computeInOutDegrees(dependencies, nodeSet);
        return BitSets.makeBitset((int[])BusComputing.indicesOfLargestElements(degrees, gamma));
    }

    private static int[] indicesOfLargestElements(int[] array, int k) {
        Assert.check((k >= 0 ? 1 : 0) != 0);
        Assert.check((k <= array.length ? 1 : 0) != 0);
        Pair[] pairs = new Pair[array.length];
        int i = 0;
        while (i < array.length) {
            pairs[i] = new Pair((Object)i, (Object)array[i]);
            ++i;
        }
        Arrays.sort(pairs, (p1, p2) -> Integer.compare((Integer)p2.right, (Integer)p1.right));
        int[] result = new int[k];
        int i2 = 0;
        while (i2 < k) {
            result[i2] = (Integer)pairs[i2].left;
            ++i2;
        }
        return result;
    }

    public static BitSet computeFixPointBus(RealMatrix dependencies, double gamma) {
        BitSet all = BitSets.ones((int)dependencies.getRowDimension());
        return BusComputing.internalComputeFixPointBus(dependencies, gamma, all);
    }

    public static BitSet computeFixPointBus(RealMatrix dependencies, double gamma, BitSet availableNodes) {
        return BusComputing.internalComputeFixPointBus(dependencies, gamma, BitSets.copy((BitSet)availableNodes));
    }

    private static BitSet internalComputeFixPointBus(RealMatrix dependencies, double gamma, BitSet nodeSet) {
        BitSet busNodes = new BitSet();
        int[] degrees = BusComputing.computeInOutDegrees(dependencies, nodeSet);
        while (!nodeSet.isEmpty()) {
            double median = BusComputing.computeMedianOfPositives(degrees);
            BitSet newBusNodes = BusComputing.selectBusNodes(degrees, gamma * median, nodeSet);
            if (newBusNodes.isEmpty()) break;
            busNodes.or(newBusNodes);
            Iterator iterator = BitSets.iterateTrueBits((BitSet)busNodes).iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                degrees[i] = 0;
            }
            nodeSet.andNot(newBusNodes);
        }
        return busNodes;
    }

    private static int[] computeInOutDegrees(RealMatrix m, BitSet availableNodes) {
        int[] result = new int[availableNodes.cardinality()];
        int resultIndex = 0;
        Iterator iterator = BitSets.iterateTrueBits((BitSet)availableNodes).iterator();
        while (iterator.hasNext()) {
            int nodeIdx = (Integer)iterator.next();
            int degrees = 0;
            Iterator iterator2 = BitSets.iterateTrueBits((BitSet)availableNodes).iterator();
            while (iterator2.hasNext()) {
                int col = (Integer)iterator2.next();
                if (!(m.getEntry(nodeIdx, col) > 0.0)) continue;
                ++degrees;
            }
            iterator2 = BitSets.iterateTrueBits((BitSet)availableNodes).iterator();
            while (iterator2.hasNext()) {
                int row = (Integer)iterator2.next();
                if (!(m.getEntry(row, nodeIdx) > 0.0)) continue;
                ++degrees;
            }
            result[resultIndex] = degrees;
            ++resultIndex;
        }
        return result;
    }

    private static double computeMedianOfPositives(int[] counts) {
        int size = counts.length;
        Assert.check((size > 0 ? 1 : 0) != 0);
        int[] copiedArray = Arrays.copyOf(counts, size);
        Arrays.sort(copiedArray);
        Integer firstNonZero = null;
        int i = 0;
        while (i < size) {
            if (copiedArray[i] > 0) {
                firstNonZero = i;
                break;
            }
            ++i;
        }
        if (firstNonZero == null) {
            return 0.0;
        }
        int nonZeroSize = size - firstNonZero;
        if (nonZeroSize % 2 == 0) {
            return (copiedArray[firstNonZero + nonZeroSize / 2] + copiedArray[firstNonZero + nonZeroSize / 2 - 1]) / 2;
        }
        return copiedArray[firstNonZero + nonZeroSize / 2];
    }

    private static BitSet selectBusNodes(int[] degrees, double threshold, BitSet availableNodes) {
        BitSet busNodes = BitSets.bitset((int)availableNodes.size());
        Iterator iterator = BitSets.iterateTrueBits((BitSet)availableNodes).iterator();
        while (iterator.hasNext()) {
            int nodeIdx = (Integer)iterator.next();
            if (!((double)degrees[nodeIdx] >= threshold)) continue;
            busNodes.set(nodeIdx);
        }
        return busNodes;
    }
}

