/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.text;

import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.handly.text.DocumentChange;
import org.eclipse.handly.text.IDocumentChange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditProcessor;
import org.eclipse.text.edits.UndoEdit;

public class DocumentChangeOperation {
    protected final IDocument document;
    protected final IDocumentChange change;

    public DocumentChangeOperation(IDocument document, IDocumentChange change) {
        if (document == null) {
            throw new IllegalArgumentException();
        }
        if (change == null) {
            throw new IllegalArgumentException();
        }
        this.document = document;
        this.change = change;
    }

    public IDocumentChange execute() throws BadLocationException {
        if (!(this.document instanceof IDocumentExtension4)) {
            return this.applyChange();
        }
        IDocumentExtension4 extension = (IDocumentExtension4)this.document;
        boolean isLargeEdit = RewriteSessionEditProcessor.isLargeEdit((TextEdit)this.change.getEdit());
        DocumentRewriteSessionType type = isLargeEdit ? DocumentRewriteSessionType.UNRESTRICTED : DocumentRewriteSessionType.UNRESTRICTED_SMALL;
        DocumentRewriteSession session = extension.startRewriteSession(type);
        try {
            IDocumentChange iDocumentChange = this.applyChange();
            return iDocumentChange;
        }
        finally {
            extension.stopRewriteSession(session);
        }
    }

    protected IDocumentChange applyChange() throws BadLocationException {
        this.checkChange();
        LinkedModeModel.closeAllModels((IDocument)this.document);
        long stampToRestore = DocumentChangeOperation.getModificationStampOf(this.document);
        UndoEdit undoEdit = this.applyTextEdit();
        if (this.change instanceof UndoChange) {
            DocumentChangeOperation.setModificationStampOf(this.document, ((UndoChange)this.change).stampToRestore);
        }
        return this.createUndoChange(undoEdit, stampToRestore);
    }

    protected ISnapshot getCurrentSnapshot() {
        return new DocumentSnapshot(this.document);
    }

    protected void checkChange() {
        ISnapshot baseSnapshot = this.change.getBase();
        if (baseSnapshot != null && !baseSnapshot.isEqualTo(this.getCurrentSnapshot())) {
            throw new StaleSnapshotException();
        }
    }

    protected UndoEdit applyTextEdit() throws BadLocationException {
        return this.createTextEditProcessor().performEdits();
    }

    protected TextEditProcessor createTextEditProcessor() {
        return new TextEditProcessor(this.document, this.change.getEdit(), this.change.getStyle());
    }

    protected IDocumentChange createUndoChange(UndoEdit undoEdit, long stampToRestore) {
        if (undoEdit == null) {
            return null;
        }
        UndoChange undoChange = new UndoChange(undoEdit, stampToRestore);
        undoChange.setBase(this.getCurrentSnapshot());
        undoChange.setStyle(this.change.getStyle());
        return undoChange;
    }

    protected static long getModificationStampOf(IDocument document) {
        long modificationStamp = -1L;
        if (document instanceof IDocumentExtension4) {
            modificationStamp = ((IDocumentExtension4)document).getModificationStamp();
        }
        return modificationStamp;
    }

    protected static void setModificationStampOf(IDocument document, long modificationStamp) {
        if (document instanceof IDocumentExtension4 && modificationStamp != -1L) {
            try {
                ((IDocumentExtension4)document).replace(0, 0, "", modificationStamp);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    protected static class UndoChange
    extends DocumentChange {
        public final long stampToRestore;

        public UndoChange(UndoEdit undoEdit, long stampToRestore) {
            super((TextEdit)undoEdit);
            this.stampToRestore = stampToRestore;
        }
    }
}

