/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.asset;

import java.util.List;
import java.util.Objects;
import org.eclipse.kura.asset.Asset;
import org.eclipse.kura.asset.AssetService;
import org.eclipse.kura.util.collection.CollectionUtil;
import org.eclipse.kura.util.service.ServiceUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class AssetServiceImpl
implements AssetService {
    public Asset getAsset(String assetPid) {
        Objects.requireNonNull(assetPid, "Asset PID cannot be null");
        BundleContext context = this.getBundleContext();
        ServiceReference<Asset>[] refs = this.getAssetServiceReferences(context);
        try {
            ServiceReference<Asset>[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference<Asset> ref = serviceReferenceArray[n2];
                if (ref.getProperty("kura.service.pid").equals(assetPid)) {
                    Asset asset = (Asset)context.getService(ref);
                    return asset;
                }
                ++n2;
            }
        }
        finally {
            this.ungetServiceReferences(context, refs);
        }
        return null;
    }

    public String getAssetPid(Asset asset) {
        Objects.requireNonNull(asset, "Asset cannot be null");
        BundleContext context = this.getBundleContext();
        ServiceReference<Asset>[] refs = this.getAssetServiceReferences(context);
        try {
            ServiceReference<Asset>[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference<Asset> ref = serviceReferenceArray[n2];
                Asset assetRef = (Asset)context.getService(ref);
                if (assetRef == asset) {
                    String string = ref.getProperty("kura.service.pid").toString();
                    return string;
                }
                ++n2;
            }
        }
        finally {
            this.ungetServiceReferences(context, refs);
        }
        return null;
    }

    public List<Asset> listAssets() {
        List assets = CollectionUtil.newArrayList();
        BundleContext context = this.getBundleContext();
        ServiceReference<Asset>[] refs = this.getAssetServiceReferences(context);
        try {
            ServiceReference<Asset>[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference<Asset> ref = serviceReferenceArray[n2];
                Asset assetRef = (Asset)context.getService(ref);
                assets.add(assetRef);
                ++n2;
            }
        }
        finally {
            this.ungetServiceReferences(context, refs);
        }
        return assets;
    }

    protected ServiceReference<Asset>[] getAssetServiceReferences(BundleContext context) {
        return ServiceUtil.getServiceReferences((BundleContext)context, Asset.class, null);
    }

    protected BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(this.getClass()).getBundleContext();
    }

    protected void ungetServiceReferences(BundleContext context, ServiceReference<Asset>[] refs) {
        ServiceUtil.ungetServiceReferences((BundleContext)context, refs);
    }
}

