/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.firewall;

import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetProtocol;
import org.eclipse.kura.net.NetworkPair;
import org.eclipse.kura.net.firewall.FirewallOpenPortConfig;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class FirewallOpenPortConfigIP<T extends IPAddress>
implements FirewallOpenPortConfig {
    private int port;
    private String portRange;
    private NetProtocol protocol;
    private NetworkPair<T> permittedNetwork;
    private String permittedInterfaceName;
    private String unpermittedInterfaceName;
    private String permittedMac;
    private String sourcePortRange;

    public FirewallOpenPortConfigIP() {
    }

    public FirewallOpenPortConfigIP(int port, NetProtocol protocol, NetworkPair<T> permittedNetwork, String permittedInterfaceName, String unpermittedInterfaceName, String permittedMac, String sourcePortRange) {
        this.port = port;
        this.portRange = null;
        this.protocol = protocol;
        this.permittedNetwork = permittedNetwork;
        this.permittedInterfaceName = permittedInterfaceName;
        this.unpermittedInterfaceName = unpermittedInterfaceName;
        this.permittedMac = permittedMac;
        this.sourcePortRange = sourcePortRange;
    }

    public FirewallOpenPortConfigIP(String portRange, NetProtocol protocol, NetworkPair<T> permittedNetwork, String permittedInterfaceName, String unpermittedInterfaceName, String permittedMac, String sourcePortRange) {
        this.portRange = portRange;
        this.port = -1;
        this.protocol = protocol;
        this.permittedNetwork = permittedNetwork;
        this.permittedInterfaceName = permittedInterfaceName;
        this.unpermittedInterfaceName = unpermittedInterfaceName;
        this.permittedMac = permittedMac;
        this.sourcePortRange = sourcePortRange;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getPortRange() {
        return this.portRange;
    }

    public void setPortRange(String portRange) {
        this.portRange = portRange;
    }

    @Override
    public NetProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(NetProtocol protocol) {
        this.protocol = protocol;
    }

    public NetworkPair<T> getPermittedNetwork() {
        return this.permittedNetwork;
    }

    public void setPermittedNetwork(NetworkPair<T> permittedNetwork) {
        this.permittedNetwork = permittedNetwork;
    }

    public String getPermittedInterfaceName() {
        return this.permittedInterfaceName;
    }

    public void setPermittedInterfaceName(String permittedInterfaceName) {
        this.permittedInterfaceName = permittedInterfaceName;
    }

    public String getUnpermittedInterfaceName() {
        return this.unpermittedInterfaceName;
    }

    public void setUnpermittedInterfaceName(String unpermittedInterfaceName) {
        this.unpermittedInterfaceName = unpermittedInterfaceName;
    }

    @Override
    public String getPermittedMac() {
        return this.permittedMac;
    }

    public void setPermittedMac(String permittedMac) {
        this.permittedMac = permittedMac;
    }

    @Override
    public String getSourcePortRange() {
        return this.sourcePortRange;
    }

    public void setSourcePortRange(String sourcePortRange) {
        this.sourcePortRange = sourcePortRange;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.permittedInterfaceName == null ? 0 : this.permittedInterfaceName.hashCode());
        result = 31 * result + (this.permittedMac == null ? 0 : this.permittedMac.hashCode());
        result = 31 * result + (this.permittedNetwork == null ? 0 : this.permittedNetwork.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.sourcePortRange == null ? 0 : this.sourcePortRange.hashCode());
        result = 31 * result + (this.unpermittedInterfaceName == null ? 0 : this.unpermittedInterfaceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FirewallOpenPortConfigIP other = (FirewallOpenPortConfigIP)obj;
        if (this.permittedInterfaceName == null ? other.permittedInterfaceName != null : !this.permittedInterfaceName.equals(other.permittedInterfaceName)) {
            return false;
        }
        if (this.permittedMac == null ? other.permittedMac != null : !this.permittedMac.equals(other.permittedMac)) {
            return false;
        }
        if (this.permittedNetwork == null ? other.permittedNetwork != null : !this.permittedNetwork.equals(other.permittedNetwork)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.protocol != other.protocol) {
            return false;
        }
        if (this.sourcePortRange == null ? other.sourcePortRange != null : !this.sourcePortRange.equals(other.sourcePortRange)) {
            return false;
        }
        return !(this.unpermittedInterfaceName == null ? other.unpermittedInterfaceName != null : !this.unpermittedInterfaceName.equals(other.unpermittedInterfaceName));
    }

    @Override
    public boolean isValid() {
        if (this.port < 0 || this.port > 65535) {
            return false;
        }
        return this.protocol != null && this.protocol.equals((Object)NetProtocol.tcp) && this.protocol.equals((Object)NetProtocol.udp);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FirewallOpenPortConfigIP [port=");
        builder.append(this.port);
        builder.append(", protocol=");
        builder.append((Object)this.protocol);
        builder.append(", permittedNetwork=");
        builder.append(this.permittedNetwork);
        builder.append(", permittedMac=");
        builder.append(this.permittedMac);
        builder.append(", sourcePortRange=");
        builder.append(this.sourcePortRange);
        builder.append("]");
        return builder.toString();
    }
}

