/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtil {
    private static final Logger s_logger = LoggerFactory.getLogger(NetUtil.class);

    public static String hardwareAddressToString(byte[] macAddress) {
        if (macAddress == null) {
            return "N/A";
        }
        if (macAddress.length != 6) {
            throw new IllegalArgumentException("macAddress is invalid");
        }
        StringJoiner sj = new StringJoiner(":");
        byte[] byArray = macAddress;
        int n = macAddress.length;
        int n2 = 0;
        while (n2 < n) {
            byte item = byArray[n2];
            sj.add(String.format("%02X", item));
            ++n2;
        }
        return sj.toString();
    }

    public static byte[] hardwareAddressToBytes(String macAddress) {
        if (macAddress == null || macAddress.isEmpty()) {
            return new byte[6];
        }
        String[] items = macAddress.split("\\:");
        if (items.length != 6) {
            throw new IllegalArgumentException("mac is invalid: " + macAddress);
        }
        byte[] bytes = new byte[6];
        int i = 0;
        while (i < 6) {
            String item = items[i];
            if (item.isEmpty() || item.length() > 2) {
                throw new IllegalArgumentException("mac is invalid: " + macAddress);
            }
            try {
                bytes[i] = (byte)Integer.parseInt(items[i], 16);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("mac is invalid: " + macAddress, e);
            }
            ++i;
        }
        return bytes;
    }

    public static String getPrimaryMacAddress() {
        NetworkInterface firstInterface = null;
        Enumeration<NetworkInterface> nifs = null;
        try {
            NetworkInterface nif;
            nifs = NetworkInterface.getNetworkInterfaces();
            if (nifs != null) {
                while (nifs.hasMoreElements()) {
                    nif = nifs.nextElement();
                    if (!"eth0".equals(nif.getName()) && !"en0".equals(nif.getName())) continue;
                    return NetUtil.hardwareAddressToString(nif.getHardwareAddress());
                }
            }
            if ((nifs = NetworkInterface.getNetworkInterfaces()) != null) {
                while (nifs.hasMoreElements()) {
                    nif = nifs.nextElement();
                    if (nif.isVirtual() || nif.getHardwareAddress() == null) continue;
                    firstInterface = nif;
                    if (!nif.getName().startsWith("eth") && !nif.getName().startsWith("en")) continue;
                    return NetUtil.hardwareAddressToString(nif.getHardwareAddress());
                }
            }
            if (firstInterface != null) {
                return NetUtil.hardwareAddressToString(firstInterface.getHardwareAddress());
            }
        }
        catch (Exception e) {
            s_logger.warn("Exception while getting current IP", (Throwable)e);
        }
        return null;
    }

    public static InetAddress getCurrentInetAddress() {
        try {
            Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
            if (nifs != null) {
                while (nifs.hasMoreElements()) {
                    NetworkInterface nif = nifs.nextElement();
                    if (nif.isLoopback() || !nif.isUp() || nif.isVirtual() || nif.getHardwareAddress() == null) continue;
                    Enumeration<InetAddress> nadrs = nif.getInetAddresses();
                    while (nadrs.hasMoreElements()) {
                        InetAddress adr = nadrs.nextElement();
                        if (adr == null || adr.isLoopbackAddress() || !nif.isPointToPoint() && adr.isLinkLocalAddress()) continue;
                        return adr;
                    }
                }
            }
        }
        catch (Exception e) {
            s_logger.warn("Exception while getting current IP", (Throwable)e);
        }
        return null;
    }
}

