/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.subscriber;

import java.util.Map;
import java.util.Optional;
import org.eclipse.kura.type.DataType;

final class CloudSubscriberOptions {
    private static final String CONF_BODY_PROPERTY = "set.property.from.body";
    private static final String CONF_BODY_PROPERTY_TYPE = "body.property.type";
    private final Map<String, Object> properties;

    CloudSubscriberOptions(Map<String, Object> properties) {
        this.properties = properties;
    }

    Optional<String> getBodyProperty() {
        Object propertyRaw = this.properties.get(CONF_BODY_PROPERTY);
        if (!(propertyRaw instanceof String)) {
            return Optional.empty();
        }
        String property = (String)propertyRaw;
        if (property.trim().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(property);
    }

    DataType getBodyPropertyType() {
        try {
            return DataType.valueOf((String)((String)this.properties.get(CONF_BODY_PROPERTY_TYPE)));
        }
        catch (Exception exception) {
            return DataType.BYTE_ARRAY;
        }
    }
}

