/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared.model;

public enum GwtWifiRadioMode {
    netWifiRadioModeANAC("ac", false, true),
    netWifiRadioModeBGN("n", true, true),
    netWifiRadioModeBG("g", true, false),
    netWifiRadioModeB("b", true, false),
    netWifiRadioModeA("a", false, true);

    private final String radioMode;
    private final boolean twoDotFourGhz;
    private final boolean fiveGhz;

    private GwtWifiRadioMode(String radioMode, boolean twoDotFourGhz, boolean fiveGhz) {
        this.radioMode = radioMode;
        this.twoDotFourGhz = twoDotFourGhz;
        this.fiveGhz = fiveGhz;
    }

    public static GwtWifiRadioMode getRadioMode(String mode) {
        if ("a".equals(mode)) {
            return netWifiRadioModeA;
        }
        if ("b".equals(mode)) {
            return netWifiRadioModeB;
        }
        if ("g".equals(mode)) {
            return netWifiRadioModeBG;
        }
        if ("n".equals(mode)) {
            return netWifiRadioModeBGN;
        }
        if ("ac".equals(mode)) {
            return netWifiRadioModeANAC;
        }
        return null;
    }

    public String getRadioMode() {
        return this.radioMode;
    }

    public boolean isTwoDotFourGhz() {
        return this.twoDotFourGhz;
    }

    public boolean isFiveGhz() {
        return this.fiveGhz;
    }
}

