/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.internal.linux.executor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.exec.StreamPumper;
import org.apache.commons.exec.util.DebugUtils;

public class FlushStreamPumper
extends StreamPumper {
    private static final int DEFAULT_SIZE = 1024;
    private final InputStream is;
    private final OutputStream os;
    private final int size;
    private boolean finished;
    private final boolean closeWhenExhausted;

    public FlushStreamPumper(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        super(is, os, closeWhenExhausted);
        this.is = is;
        this.os = os;
        this.size = 1024;
        this.closeWhenExhausted = closeWhenExhausted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block27: {
            FlushStreamPumper flushStreamPumper = this;
            synchronized (flushStreamPumper) {
                this.finished = false;
            }
            byte[] buf = new byte[this.size];
            try {
                try {
                    int length;
                    while ((length = this.is.read(buf)) > 0) {
                        this.os.write(buf, 0, length);
                        this.os.flush();
                    }
                }
                catch (Exception exception) {
                    if (this.closeWhenExhausted) {
                        try {
                            this.os.close();
                        }
                        catch (IOException e) {
                            DebugUtils.handleException((String)"Got exception while closing exhausted output stream", (Exception)e);
                        }
                    }
                    FlushStreamPumper e = this;
                    synchronized (e) {
                        this.finished = true;
                        ((Object)((Object)this)).notifyAll();
                        break block27;
                    }
                }
            }
            catch (Throwable throwable) {
                if (this.closeWhenExhausted) {
                    try {
                        this.os.close();
                    }
                    catch (IOException e) {
                        DebugUtils.handleException((String)"Got exception while closing exhausted output stream", (Exception)e);
                    }
                }
                FlushStreamPumper e = this;
                synchronized (e) {
                    this.finished = true;
                    ((Object)((Object)this)).notifyAll();
                }
                throw throwable;
            }
            if (this.closeWhenExhausted) {
                try {
                    this.os.close();
                }
                catch (IOException e) {
                    DebugUtils.handleException((String)"Got exception while closing exhausted output stream", (Exception)e);
                }
            }
            FlushStreamPumper flushStreamPumper2 = this;
            synchronized (flushStreamPumper2) {
                this.finished = true;
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }
}

