/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ProgressDetail;
import org.mandas.docker.client.messages.ProgressMessage;

final class ImmutableProgressMessage
implements ProgressMessage {
    @Nullable
    private final String id;
    @Nullable
    private final String status;
    @Nullable
    private final String stream;
    @Nullable
    private final String error;
    @Nullable
    private final String progress;
    @Nullable
    private final ProgressDetail progressDetail;
    @Nullable
    private final transient String buildImageId;
    @Nullable
    private final transient String digest;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableProgressMessage(@Nullable String id, @Nullable String status, @Nullable String stream, @Nullable String error, @Nullable String progress, @Nullable ProgressDetail progressDetail) {
        this.id = id;
        this.status = status;
        this.stream = stream;
        this.error = error;
        this.progress = progress;
        this.progressDetail = progressDetail;
        this.buildImageId = this.initShim.buildImageId();
        this.digest = this.initShim.digest();
        this.initShim = null;
    }

    @Nullable
    private String buildImageIdInitialize() {
        return ProgressMessage.super.buildImageId();
    }

    @Nullable
    private String digestInitialize() {
        return ProgressMessage.super.digest();
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="status")
    @Nullable
    public String status() {
        return this.status;
    }

    @Override
    @JsonProperty(value="stream")
    @Nullable
    public String stream() {
        return this.stream;
    }

    @Override
    @JsonProperty(value="error")
    @Nullable
    public String error() {
        return this.error;
    }

    @Override
    @JsonProperty(value="progress")
    @Nullable
    public String progress() {
        return this.progress;
    }

    @Override
    @JsonProperty(value="progressDetail")
    @Nullable
    public ProgressDetail progressDetail() {
        return this.progressDetail;
    }

    @Override
    @JsonProperty(value="buildImageId")
    @JsonIgnore
    @Nullable
    public String buildImageId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.buildImageId() : this.buildImageId;
    }

    @Override
    @JsonProperty(value="digest")
    @JsonIgnore
    @Nullable
    public String digest() {
        InitShim shim = this.initShim;
        return shim != null ? shim.digest() : this.digest;
    }

    public final ImmutableProgressMessage withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableProgressMessage(value, this.status, this.stream, this.error, this.progress, this.progressDetail);
    }

    public final ImmutableProgressMessage withStatus(@Nullable String value) {
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableProgressMessage(this.id, value, this.stream, this.error, this.progress, this.progressDetail);
    }

    public final ImmutableProgressMessage withStream(@Nullable String value) {
        if (Objects.equals(this.stream, value)) {
            return this;
        }
        return new ImmutableProgressMessage(this.id, this.status, value, this.error, this.progress, this.progressDetail);
    }

    public final ImmutableProgressMessage withError(@Nullable String value) {
        if (Objects.equals(this.error, value)) {
            return this;
        }
        return new ImmutableProgressMessage(this.id, this.status, this.stream, value, this.progress, this.progressDetail);
    }

    public final ImmutableProgressMessage withProgress(@Nullable String value) {
        if (Objects.equals(this.progress, value)) {
            return this;
        }
        return new ImmutableProgressMessage(this.id, this.status, this.stream, this.error, value, this.progressDetail);
    }

    public final ImmutableProgressMessage withProgressDetail(@Nullable ProgressDetail value) {
        if (this.progressDetail == value) {
            return this;
        }
        return new ImmutableProgressMessage(this.id, this.status, this.stream, this.error, this.progress, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProgressMessage && this.equalsByValue((ImmutableProgressMessage)another);
    }

    private boolean equalsByValue(ImmutableProgressMessage another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.status, another.status) && Objects.equals(this.stream, another.stream) && Objects.equals(this.error, another.error) && Objects.equals(this.progress, another.progress) && Objects.equals(this.progressDetail, another.progressDetail) && Objects.equals(this.buildImageId, another.buildImageId) && Objects.equals(this.digest, another.digest);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + Objects.hashCode(this.stream);
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + Objects.hashCode(this.progress);
        h += (h << 5) + Objects.hashCode(this.progressDetail);
        h += (h << 5) + Objects.hashCode(this.buildImageId);
        h += (h << 5) + Objects.hashCode(this.digest);
        return h;
    }

    public String toString() {
        return "ProgressMessage{id=" + this.id + ", status=" + this.status + ", stream=" + this.stream + ", error=" + this.error + ", progress=" + this.progress + ", progressDetail=" + String.valueOf(this.progressDetail) + ", buildImageId=" + this.buildImageId + ", digest=" + this.digest + "}";
    }

    public static ImmutableProgressMessage copyOf(ProgressMessage instance) {
        if (instance instanceof ImmutableProgressMessage) {
            return (ImmutableProgressMessage)instance;
        }
        return ImmutableProgressMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private final class InitShim {
        private byte buildImageIdBuildStage = 0;
        private String buildImageId;
        private byte digestBuildStage = 0;
        private String digest;

        private InitShim() {
        }

        String buildImageId() {
            if (this.buildImageIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.buildImageIdBuildStage == 0) {
                String computedValue;
                this.buildImageIdBuildStage = (byte)-1;
                this.buildImageId = computedValue = ImmutableProgressMessage.this.buildImageIdInitialize();
                this.buildImageIdBuildStage = 1;
            }
            return this.buildImageId;
        }

        String digest() {
            if (this.digestBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.digestBuildStage == 0) {
                String computedValue;
                this.digestBuildStage = (byte)-1;
                this.digest = computedValue = ImmutableProgressMessage.this.digestInitialize();
                this.digestBuildStage = 1;
            }
            return this.digest;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.buildImageIdBuildStage == -1) {
                attributes.add("buildImageId");
            }
            if (this.digestBuildStage == -1) {
                attributes.add("digest");
            }
            return "Cannot build ProgressMessage, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    static final class Builder
    implements ProgressMessage.Builder {
        private String id;
        private String status;
        private String stream;
        private String error;
        private String progress;
        private ProgressDetail progressDetail;

        private Builder() {
        }

        public final Builder from(ProgressMessage instance) {
            ProgressDetail progressDetailValue;
            String progressValue;
            String errorValue;
            String streamValue;
            String statusValue;
            Objects.requireNonNull(instance, "instance");
            String idValue = instance.id();
            if (idValue != null) {
                this.id(idValue);
            }
            if ((statusValue = instance.status()) != null) {
                this.status(statusValue);
            }
            if ((streamValue = instance.stream()) != null) {
                this.stream(streamValue);
            }
            if ((errorValue = instance.error()) != null) {
                this.error(errorValue);
            }
            if ((progressValue = instance.progress()) != null) {
                this.progress(progressValue);
            }
            if ((progressDetailValue = instance.progressDetail()) != null) {
                this.progressDetail(progressDetailValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="id")
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonProperty(value="status")
        public final Builder status(@Nullable String status) {
            this.status = status;
            return this;
        }

        @Override
        @JsonProperty(value="stream")
        public final Builder stream(@Nullable String stream) {
            this.stream = stream;
            return this;
        }

        @Override
        @JsonProperty(value="error")
        public final Builder error(@Nullable String error) {
            this.error = error;
            return this;
        }

        @Override
        @JsonProperty(value="progress")
        public final Builder progress(@Nullable String progress) {
            this.progress = progress;
            return this;
        }

        @Override
        @JsonProperty(value="progressDetail")
        public final Builder progressDetail(@Nullable ProgressDetail progressDetail) {
            this.progressDetail = progressDetail;
            return this;
        }

        @Override
        public ImmutableProgressMessage build() {
            return new ImmutableProgressMessage(this.id, this.status, this.stream, this.error, this.progress, this.progressDetail);
        }
    }
}

