/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.deser.util;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.datatype.guava.deser.util.RangeFactory;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.regex.Pattern;

public class RangeHelper {
    private static final RangeProperties STD_NAMES = new RangeProperties();
    private static final Field[] FIELDS = STD_NAMES.fields();
    private static final Pattern PATTERN_DOUBLE_DOT = Pattern.compile("\\.\\.");

    public static RangeProperties standardNames() {
        return STD_NAMES;
    }

    public static RangeProperties getPropertyNames(MapperConfig<?> config, PropertyNamingStrategy pns) {
        if (pns == null) {
            return STD_NAMES;
        }
        TypeResolutionContext.Empty typeCtxt = new TypeResolutionContext.Empty(config.getTypeFactory());
        return new RangeProperties(RangeHelper._find(config, (TypeResolutionContext)typeCtxt, pns, FIELDS[0]), RangeHelper._find(config, (TypeResolutionContext)typeCtxt, pns, FIELDS[1]), RangeHelper._find(config, (TypeResolutionContext)typeCtxt, pns, FIELDS[2]), RangeHelper._find(config, (TypeResolutionContext)typeCtxt, pns, FIELDS[3]));
    }

    private static String _find(MapperConfig<?> config, TypeResolutionContext typeCtxt, PropertyNamingStrategy pns, Field field) {
        AnnotatedField af = new AnnotatedField(typeCtxt, field, null);
        return pns.nameForField(config, af, field.getName());
    }

    public static Range<? extends Comparable> getRangeFromString(String rangeInterval, DeserializationContext context, KeyDeserializer fromStringDeserializer, JavaType rangeType, Class<?> targetClass) throws IOException {
        if (RangeHelper._isValidBracketNotation(rangeInterval)) {
            BoundType lowerBoundType = rangeInterval.startsWith("[") ? BoundType.CLOSED : BoundType.OPEN;
            BoundType upperBoundType = rangeInterval.endsWith("]") ? BoundType.CLOSED : BoundType.OPEN;
            String[] parts = PATTERN_DOUBLE_DOT.split(rangeInterval = rangeInterval.substring(1, rangeInterval.length() - 1));
            if (parts.length == 2) {
                boolean isLowerInfinite = parts[0].equals("-\u221e");
                boolean isUpperInfinite = parts[1].equals("+\u221e");
                if (isLowerInfinite && isUpperInfinite) {
                    return RangeFactory.all();
                }
                if (isLowerInfinite) {
                    return RangeFactory.upTo(RangeHelper.deserializeStringified(context, parts[1], fromStringDeserializer, rangeType), upperBoundType);
                }
                if (isUpperInfinite) {
                    return RangeFactory.downTo(RangeHelper.deserializeStringified(context, parts[0], fromStringDeserializer, rangeType), lowerBoundType);
                }
                return RangeFactory.range(RangeHelper.deserializeStringified(context, parts[0], fromStringDeserializer, rangeType), lowerBoundType, RangeHelper.deserializeStringified(context, parts[1], fromStringDeserializer, rangeType), upperBoundType);
            }
        } else {
            String msg = "Invalid Range: should start with '[' or '(', end with ')' or ']'";
            return (Range)context.handleWeirdStringValue(targetClass, rangeInterval, msg, new Object[0]);
        }
        return (Range)context.handleWeirdStringValue(targetClass, rangeInterval, "Invalid bracket-notation representation (possibly missing \"..\" delimiter in your Stringified Range)", new Object[0]);
    }

    private static Comparable<?> deserializeStringified(DeserializationContext context, String value, KeyDeserializer fromStringDeserializer, JavaType rangeType) throws IOException {
        Object obj = fromStringDeserializer.deserializeKey(value, context);
        if (!(obj instanceof Comparable)) {
            context.reportBadDefinition(rangeType, String.format("Stringified endpoint '%s' deserialized to a %s, which does not implement `Comparable`", value, ClassUtil.classNameOf((Object)obj)));
        }
        return (Comparable)obj;
    }

    private static boolean _isValidBracketNotation(String range) {
        if (range.isEmpty()) {
            return false;
        }
        char first = range.charAt(0);
        char last = range.charAt(range.length() - 1);
        return !(first != '[' && first != '(' || last != ']' && last != ')');
    }

    public static class RangeProperties
    implements Serializable {
        private static final long serialVersionUID = 2L;
        public final String lowerEndpoint;
        public final String upperEndpoint;
        public final String lowerBoundType;
        public final String upperBoundType;

        protected RangeProperties() {
            this("lowerEndpoint", "upperEndpoint", "lowerBoundType", "upperBoundType");
        }

        public RangeProperties(String lowerEP, String upperEP, String lowerBT, String upperBT) {
            this.lowerEndpoint = lowerEP;
            this.upperEndpoint = upperEP;
            this.lowerBoundType = lowerBT;
            this.upperBoundType = upperBT;
        }

        protected Field[] fields() {
            return new Field[]{this._field(this.lowerEndpoint), this._field(this.upperEndpoint), this._field(this.lowerBoundType), this._field(this.upperBoundType)};
        }

        private Field _field(String name) {
            try {
                return this.getClass().getField(name);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

