/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.common.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingProgressMonitor
implements IProgressMonitor {
    private static final IProgressMonitor DEV_NULL = new NullProgressMonitor();
    private final IProgressMonitor delegate;
    private final Logger logger;
    private final LogLevel level;

    public LoggingProgressMonitor() {
        this(LoggerFactory.getLogger(LoggingProgressMonitor.class), LogLevel.Debug, DEV_NULL);
    }

    public LoggingProgressMonitor(Logger logger, LogLevel level) {
        this(logger, level, DEV_NULL);
    }

    public LoggingProgressMonitor(Logger logger, LogLevel level, IProgressMonitor delegate) {
        this.logger = logger;
        this.level = level;
        this.delegate = delegate;
    }

    protected void log(String msg) {
        switch (this.level) {
            case Trace: {
                this.logger.trace(msg);
                break;
            }
            case Debug: {
                this.logger.debug(msg);
                break;
            }
            case Info: {
                this.logger.info(msg);
                break;
            }
            case Warn: {
                this.logger.warn(msg);
                break;
            }
            case Error: {
                this.logger.error(msg);
            }
        }
    }

    public void beginTask(String name, int totalWork) {
        this.log(name);
        this.delegate.beginTask(name, totalWork);
    }

    public void done() {
        this.delegate.done();
    }

    public void internalWorked(double work) {
        this.delegate.internalWorked(work);
    }

    public boolean isCanceled() {
        return this.delegate.isCanceled();
    }

    public void setCanceled(boolean value) {
        this.delegate.setCanceled(value);
    }

    public void setTaskName(String name) {
        this.log(name);
        this.delegate.setTaskName(name);
    }

    public void subTask(String name) {
        this.log(name);
        this.delegate.subTask(name);
    }

    public void worked(int work) {
        this.delegate.worked(work);
    }

    public static enum LogLevel {
        Trace,
        Debug,
        Info,
        Warn,
        Error;

    }
}

