/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifMath;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.CifPackage;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.Parameter;
import org.eclipse.escet.cif.metamodel.cif.automata.AutomataPackage;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DeclarationsPackage;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.ReturnFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.CompInstWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.CompParamWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.ListProductIterator;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifValueUtils {
    private CifValueUtils() {
    }

    public static boolean isTriviallyTrue(Expression expr, boolean initial, boolean checkRefs) {
        Object value;
        if (!CifValueUtils.hasSingleValue(expr, initial, checkRefs)) {
            return false;
        }
        try {
            value = CifEvalUtils.eval(expr, initial);
        }
        catch (CifEvalException e) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public static boolean isTriviallyTrue(List<Expression> exprs, boolean initial, boolean checkRefs) {
        for (Expression expr : exprs) {
            if (CifValueUtils.isTriviallyTrue(expr, initial, checkRefs)) continue;
            return false;
        }
        return true;
    }

    public static boolean isTriviallyFalse(Expression expr, boolean initial, boolean checkRefs) {
        Object value;
        if (!CifValueUtils.hasSingleValue(expr, initial, checkRefs)) {
            return false;
        }
        try {
            value = CifEvalUtils.eval(expr, initial);
        }
        catch (CifEvalException e) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        return false;
    }

    public static boolean isTriviallyFalse(List<Expression> exprs, boolean initial, boolean checkRefs) {
        for (Expression expr : exprs) {
            if (!CifValueUtils.isTriviallyFalse(expr, initial, checkRefs)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSingleValue(Expression expr, boolean initial, boolean checkRefs) {
        return CifValueUtils.findNonSingleValueSubExpr(expr, initial, checkRefs) == null;
    }

    public static Expression findNonSingleValueSubExpr(Expression expr, boolean initial, boolean checkRefs) {
        if (expr instanceof BoolExpression) {
            return null;
        }
        if (expr instanceof IntExpression) {
            return null;
        }
        if (expr instanceof RealExpression) {
            return null;
        }
        if (expr instanceof StringExpression) {
            return null;
        }
        if (expr instanceof TimeExpression) {
            return initial ? null : expr;
        }
        if (expr instanceof CastExpression) {
            Expression child = ((CastExpression)expr).getChild();
            if (CifTypeUtils.isAutRefExpr(child)) {
                Automaton aut;
                if (!checkRefs) {
                    return expr;
                }
                CifType ctype = child.getType();
                CifType nctype = CifTypeUtils.normalizeType(ctype);
                if (nctype instanceof ComponentType) {
                    Component comp = ((ComponentType)nctype).getComponent();
                    aut = CifScopeUtils.getAutomaton(comp);
                } else {
                    Assert.check((boolean)(nctype instanceof ComponentDefType));
                    ComponentDef cdef = ((ComponentDefType)nctype).getDefinition();
                    aut = CifScopeUtils.getAutomaton((Component)cdef.getBody());
                }
                return aut.getLocations().size() == 1 ? null : expr;
            }
            CastExpression cexpr = (CastExpression)expr;
            return CifValueUtils.findNonSingleValueSubExpr(cexpr.getChild(), initial, checkRefs);
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression uexpr = (UnaryExpression)expr;
            if (uexpr.getOperator() == UnaryOperator.SAMPLE) {
                return expr;
            }
            return CifValueUtils.findNonSingleValueSubExpr(uexpr.getChild(), initial, checkRefs);
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            Expression result = CifValueUtils.findNonSingleValueSubExpr(bexpr.getLeft(), initial, checkRefs);
            if (result != null) {
                return result;
            }
            return CifValueUtils.findNonSingleValueSubExpr(bexpr.getRight(), initial, checkRefs);
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            boolean guardsValue = true;
            for (Expression guard : ifExpr.getGuards()) {
                boolean guardValue;
                Expression result = CifValueUtils.findNonSingleValueSubExpr(guard, initial, checkRefs);
                if (result != null) {
                    return result;
                }
                try {
                    guardValue = (Boolean)CifEvalUtils.eval(guard, initial);
                }
                catch (CifEvalException e) {
                    return e.expr != null ? e.expr : guard;
                }
                boolean bl = guardsValue = guardsValue && guardValue;
            }
            if (guardsValue) {
                return CifValueUtils.findNonSingleValueSubExpr(ifExpr.getThen(), initial, checkRefs);
            }
            for (ElifExpression elif : ifExpr.getElifs()) {
                guardsValue = true;
                for (Expression guard : elif.getGuards()) {
                    boolean guardValue;
                    Expression result = CifValueUtils.findNonSingleValueSubExpr(guard, initial, checkRefs);
                    if (result != null) {
                        return result;
                    }
                    try {
                        guardValue = (Boolean)CifEvalUtils.eval(guard, initial);
                    }
                    catch (CifEvalException e) {
                        return e.expr != null ? e.expr : guard;
                    }
                    boolean bl = guardsValue = guardsValue && guardValue;
                }
                if (!guardsValue) continue;
                return CifValueUtils.findNonSingleValueSubExpr(elif.getThen(), initial, checkRefs);
            }
            return CifValueUtils.findNonSingleValueSubExpr(ifExpr.getElse(), initial, checkRefs);
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression switchExpr = (SwitchExpression)expr;
            Expression value = switchExpr.getValue();
            if (CifTypeUtils.isAutRefExpr(value)) {
                Automaton aut;
                if (!checkRefs) {
                    return value;
                }
                CifType ctype = value.getType();
                CifType nctype = CifTypeUtils.normalizeType(ctype);
                if (nctype instanceof ComponentType) {
                    Component comp = ((ComponentType)nctype).getComponent();
                    aut = CifScopeUtils.getAutomaton(comp);
                } else {
                    Assert.check((boolean)(nctype instanceof ComponentDefType));
                    ComponentDef cdef = ((ComponentDefType)nctype).getDefinition();
                    aut = CifScopeUtils.getAutomaton((Component)cdef.getBody());
                }
                if (aut.getLocations().size() != 1) {
                    return value;
                }
            } else {
                Expression result = CifValueUtils.findNonSingleValueSubExpr(value, initial, checkRefs);
                if (result != null) {
                    return result;
                }
            }
            for (SwitchCase cse : switchExpr.getCases()) {
                Expression result;
                if (cse.getKey() != null && (result = CifValueUtils.findNonSingleValueSubExpr(cse.getKey(), initial, checkRefs)) != null) {
                    return result;
                }
                result = CifValueUtils.findNonSingleValueSubExpr(cse.getValue(), initial, checkRefs);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression pexpr = (ProjectionExpression)expr;
            Expression result = CifValueUtils.findNonSingleValueSubExpr(pexpr.getChild(), initial, checkRefs);
            if (result != null) {
                return result;
            }
            if (pexpr.getIndex() instanceof FieldExpression) {
                return null;
            }
            return CifValueUtils.findNonSingleValueSubExpr(pexpr.getIndex(), initial, checkRefs);
        }
        if (expr instanceof SliceExpression) {
            SliceExpression sexpr = (SliceExpression)expr;
            Expression result = CifValueUtils.findNonSingleValueSubExpr(sexpr.getChild(), initial, checkRefs);
            if (result != null) {
                return result;
            }
            if (sexpr.getBegin() != null && (result = CifValueUtils.findNonSingleValueSubExpr(sexpr.getBegin(), initial, checkRefs)) != null) {
                return result;
            }
            if (sexpr.getEnd() != null && (result = CifValueUtils.findNonSingleValueSubExpr(sexpr.getEnd(), initial, checkRefs)) != null) {
                return result;
            }
            return null;
        }
        if (expr instanceof FunctionCallExpression) {
            FunctionCallExpression fcexpr = (FunctionCallExpression)expr;
            if (fcexpr.getFunction() instanceof StdLibFunctionExpression) {
                StdLibFunctionExpression stdlib = (StdLibFunctionExpression)fcexpr.getFunction();
                StdLibFunction func = stdlib.getFunction();
                if (CifTypeUtils.isDistFunction(func)) {
                    return stdlib;
                }
            } else {
                return fcexpr.getFunction();
            }
            for (Expression arg : fcexpr.getArguments()) {
                Expression result = CifValueUtils.findNonSingleValueSubExpr(arg, initial, checkRefs);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            for (Expression elem : lexpr.getElements()) {
                Expression result = CifValueUtils.findNonSingleValueSubExpr(elem, initial, checkRefs);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            for (Expression elem : sexpr.getElements()) {
                Expression result = CifValueUtils.findNonSingleValueSubExpr(elem, initial, checkRefs);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            for (Expression elem : texpr.getFields()) {
                Expression result = CifValueUtils.findNonSingleValueSubExpr(elem, initial, checkRefs);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            for (DictPair pair : dexpr.getPairs()) {
                Expression result = CifValueUtils.findNonSingleValueSubExpr(pair.getKey(), initial, checkRefs);
                if (result != null) {
                    return result;
                }
                result = CifValueUtils.findNonSingleValueSubExpr(pair.getValue(), initial, checkRefs);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        if (expr instanceof ConstantExpression) {
            if (!checkRefs) {
                return expr;
            }
            Constant constant = ((ConstantExpression)expr).getConstant();
            return CifValueUtils.findNonSingleValueSubExpr(constant.getValue(), initial, checkRefs);
        }
        if (expr instanceof DiscVariableExpression) {
            if (!checkRefs) {
                return expr;
            }
            DiscVariable var = ((DiscVariableExpression)expr).getVariable();
            if (CifValueUtils.hasSingleValue(var.getType())) {
                return null;
            }
            if (var.eContainer() instanceof FunctionParameter) {
                return expr;
            }
            if (!initial) {
                return expr;
            }
            if (var.getValue() == null) {
                if (CifTypeUtils.hasFunctionType(var.getType())) {
                    return expr;
                }
                if (CifTypeUtils.hasDistType(var.getType())) {
                    return expr;
                }
                return null;
            }
            if (var.getValue().getValues().size() != 1) {
                return expr;
            }
            Expression value = (Expression)Lists.first((List)var.getValue().getValues());
            return CifValueUtils.findNonSingleValueSubExpr(value, initial, checkRefs);
        }
        if (expr instanceof AlgVariableExpression) {
            if (!checkRefs) {
                return expr;
            }
            AlgVariable var = ((AlgVariableExpression)expr).getVariable();
            Expression value = var.getValue();
            if (value != null) {
                return CifValueUtils.findNonSingleValueSubExpr(value, initial, checkRefs);
            }
            if (var.eContainer() instanceof Parameter) {
                return CifValueUtils.hasSingleValue(var.getType()) ? null : expr;
            }
            ComplexComponent comp = (ComplexComponent)var.eContainer();
            for (Equation eq : comp.getEquations()) {
                if (eq.getVariable() != var) continue;
                return CifValueUtils.findNonSingleValueSubExpr(eq.getValue(), initial, checkRefs);
            }
            return expr;
        }
        if (expr instanceof ContVariableExpression) {
            if (!checkRefs) {
                return expr;
            }
            ContVariableExpression cexpr = (ContVariableExpression)expr;
            ContVariable var = cexpr.getVariable();
            boolean isDer = cexpr.isDerivative();
            if (isDer) {
                Expression der = var.getDerivative();
                if (der != null) {
                    return CifValueUtils.findNonSingleValueSubExpr(der, initial, checkRefs);
                }
                ComplexComponent comp = (ComplexComponent)var.eContainer();
                for (Equation eq : comp.getEquations()) {
                    if (eq.getVariable() != var) continue;
                    return CifValueUtils.findNonSingleValueSubExpr(eq.getValue(), initial, checkRefs);
                }
                return expr;
            }
            if (!initial) {
                return expr;
            }
            if (var.getValue() == null) {
                return null;
            }
            return CifValueUtils.findNonSingleValueSubExpr(var.getValue(), initial, checkRefs);
        }
        if (expr instanceof TauExpression) {
            throw new RuntimeException("Tau expression in value context.");
        }
        if (expr instanceof LocationExpression) {
            if (!checkRefs) {
                return expr;
            }
            Location loc = ((LocationExpression)expr).getLocation();
            EObject parent = loc.eContainer();
            if (parent instanceof Parameter) {
                return expr;
            }
            Automaton aut = (Automaton)parent;
            return aut.getLocations().size() == 1 ? null : expr;
        }
        if (expr instanceof EnumLiteralExpression) {
            return null;
        }
        if (expr instanceof EventExpression) {
            throw new RuntimeException("Event expression in value context.");
        }
        if (expr instanceof FieldExpression) {
            String msg = "Unexpected field expr: proj expr should handle it.";
            throw new RuntimeException(msg);
        }
        if (expr instanceof StdLibFunctionExpression) {
            String msg = "Stdlib functions can not be used as values.";
            throw new RuntimeException(msg);
        }
        if (expr instanceof FunctionExpression) {
            if (!checkRefs) {
                return expr;
            }
            return null;
        }
        if (expr instanceof InputVariableExpression) {
            if (!checkRefs) {
                return expr;
            }
            InputVariable var = ((InputVariableExpression)expr).getVariable();
            return CifValueUtils.hasSingleValue(var.getType()) ? null : expr;
        }
        if (expr instanceof ComponentExpression) {
            return expr;
        }
        if (expr instanceof CompParamExpression) {
            return expr;
        }
        if (expr instanceof CompInstWrapExpression) {
            Expression rexpr = ((CompInstWrapExpression)expr).getReference();
            return CifValueUtils.findNonSingleValueSubExpr(rexpr, initial, checkRefs);
        }
        if (expr instanceof CompParamWrapExpression) {
            Expression rexpr = ((CompParamWrapExpression)expr).getReference();
            return CifValueUtils.findNonSingleValueSubExpr(rexpr, initial, checkRefs);
        }
        if (expr instanceof ReceivedExpression) {
            if (!checkRefs) {
                return expr;
            }
            return CifValueUtils.hasSingleValue(expr.getType()) ? null : expr;
        }
        if (expr instanceof SelfExpression) {
            return expr;
        }
        throw new RuntimeException("Unknown expr: " + String.valueOf(expr));
    }

    public static boolean hasSingleValue(CifType type) {
        if (type instanceof BoolType) {
            return false;
        }
        if (type instanceof IntType) {
            IntType itype = (IntType)type;
            if (CifTypeUtils.isRangeless(itype)) {
                return false;
            }
            return itype.getLower().equals(itype.getUpper());
        }
        if (type instanceof RealType) {
            return false;
        }
        if (type instanceof StringType) {
            return false;
        }
        if (type instanceof VoidType) {
            return false;
        }
        if (type instanceof ListType) {
            ListType ltype = (ListType)type;
            if (CifTypeUtils.isRangeless(ltype)) {
                return false;
            }
            if (!ltype.getLower().equals(ltype.getUpper())) {
                return false;
            }
            return CifValueUtils.hasSingleValue(ltype.getElementType());
        }
        if (type instanceof SetType) {
            return false;
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                if (CifValueUtils.hasSingleValue(field.getType())) continue;
                return false;
            }
            return true;
        }
        if (type instanceof DictType) {
            return false;
        }
        if (type instanceof CompInstWrapType) {
            CifType rtype = ((CompInstWrapType)type).getReference();
            return CifValueUtils.hasSingleValue(rtype);
        }
        if (type instanceof CompParamWrapType) {
            CifType rtype = ((CompParamWrapType)type).getReference();
            return CifValueUtils.hasSingleValue(rtype);
        }
        if (type instanceof ComponentDefType) {
            return false;
        }
        if (type instanceof ComponentType) {
            return true;
        }
        if (type instanceof EnumType) {
            return ((EnumType)type).getEnum().getLiterals().size() == 1;
        }
        if (type instanceof TypeRef) {
            CifType rtype = ((TypeRef)type).getType().getType();
            return CifValueUtils.hasSingleValue(rtype);
        }
        if (type instanceof FuncType) {
            return false;
        }
        if (type instanceof DistType) {
            return false;
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }

    public static Integer tryGetIntLiteralValue(Expression expr) {
        UnaryExpression unExpr;
        BinaryExpression binExpr;
        if (expr instanceof IntExpression) {
            IntExpression intLit = (IntExpression)expr;
            return intLit.getValue();
        }
        if (expr instanceof BinaryExpression && (binExpr = (BinaryExpression)expr).getOperator() == BinaryOperator.SUBTRACTION && CifTypeUtils.normalizeType(binExpr.getType()) instanceof IntType) {
            Integer right;
            Integer left = CifValueUtils.tryGetIntLiteralValue(binExpr.getLeft());
            if (left != null && (right = CifValueUtils.tryGetIntLiteralValue(binExpr.getRight())) != null) {
                try {
                    return CifMath.subtract(left, right, (Expression)binExpr);
                }
                catch (CifEvalException cifEvalException) {}
            }
        } else if (expr instanceof UnaryExpression && (unExpr = (UnaryExpression)expr).getOperator() == UnaryOperator.NEGATE && CifTypeUtils.normalizeType(unExpr.getType()) instanceof IntType) {
            Integer child = CifValueUtils.tryGetIntLiteralValue(unExpr.getChild());
            try {
                return child == null ? null : Integer.valueOf(CifMath.negate(child, (Expression)unExpr));
            }
            catch (CifEvalException cifEvalException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String tryGetRealLiteralValue(Expression expr) {
        UnaryExpression unExpr;
        if (expr instanceof RealExpression) {
            RealExpression realLit = (RealExpression)expr;
            return realLit.getValue();
        }
        if (expr instanceof UnaryExpression && (unExpr = (UnaryExpression)expr).getOperator() == UnaryOperator.NEGATE && CifTypeUtils.normalizeType(unExpr.getType()) instanceof RealType) {
            Object child = CifValueUtils.tryGetRealLiteralValue(unExpr.getChild());
            if (child != null) {
                child = ((String)child).startsWith("-") ? ((String)child).substring(1) : "-" + (String)child;
            }
            return child;
        }
        return null;
    }

    public static Expression getDefaultValue(CifType type, List<InternalFunction> funcs) {
        if (type instanceof BoolType) {
            return CifValueUtils.makeFalse();
        }
        if (type instanceof IntType) {
            int uDistanceToZero;
            int lDistanceToZero;
            IntType itype = (IntType)type;
            int defaultValue = CifTypeUtils.isRangeless(itype) ? 0 : (itype.getLower() <= 0 && itype.getUpper() >= 0 ? 0 : ((lDistanceToZero = Math.abs(itype.getLower())) < (uDistanceToZero = Math.abs(itype.getUpper())) ? itype.getLower() : itype.getUpper()));
            return CifValueUtils.makeInt(defaultValue);
        }
        if (type instanceof TypeRef) {
            return CifValueUtils.getDefaultValue(((TypeRef)type).getType().getType(), funcs);
        }
        if (type instanceof EnumType) {
            EnumLiteralExpression rslt = CifConstructors.newEnumLiteralExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            EnumDecl enumDecl = ((EnumType)type).getEnum();
            rslt.setLiteral((EnumLiteral)Lists.first((List)enumDecl.getLiterals()));
            return rslt;
        }
        if (type instanceof RealType) {
            RealExpression rslt = CifConstructors.newRealExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            rslt.setValue("0.0");
            return rslt;
        }
        if (type instanceof StringType) {
            StringExpression rslt = CifConstructors.newStringExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            rslt.setValue("");
            return rslt;
        }
        if (type instanceof ListType) {
            ListType ltype = (ListType)type;
            ListExpression rslt = CifConstructors.newListExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            if (!CifTypeUtils.isRangeless(ltype)) {
                int lower = ltype.getLower();
                int i = 0;
                while (i < lower) {
                    Expression elem = CifValueUtils.getDefaultValue(ltype.getElementType(), funcs);
                    rslt.getElements().add((Object)elem);
                    ++i;
                }
            }
            return rslt;
        }
        if (type instanceof SetType) {
            SetExpression rslt = CifConstructors.newSetExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            return rslt;
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            ftype.getReturnType();
            InternalFunction function = null;
            for (InternalFunction func : funcs) {
                FuncType t = CifConstructors.newFuncType();
                CifType rt = CifTypeUtils.makeTupleType((List<CifType>)func.getReturnTypes(), null);
                t.setReturnType(rt);
                for (FunctionParameter param : func.getParameters()) {
                    CifType pt = param.getParameter().getType();
                    t.getParamTypes().add((Object)((CifType)EMFHelper.deepclone((EObject)pt)));
                }
                if (!CifTypeUtils.checkTypeCompat((CifType)t, (CifType)ftype, RangeCompat.EQUAL)) continue;
                function = func;
                break;
            }
            if (function == null) {
                function = CifConstructors.newInternalFunction();
                int i = 0;
                while (i < ftype.getParamTypes().size()) {
                    CifType ptype = (CifType)ftype.getParamTypes().get(i);
                    DiscVariable pvar = CifConstructors.newDiscVariable();
                    pvar.setName("p" + i);
                    pvar.setType((CifType)EMFHelper.deepclone((EObject)ptype));
                    FunctionParameter param = CifConstructors.newFunctionParameter();
                    param.setParameter(pvar);
                    function.getParameters().add((Object)param);
                    ++i;
                }
                CifType rtype = ftype.getReturnType();
                function.getReturnTypes().add((Object)((CifType)EMFHelper.deepclone((EObject)rtype)));
                Expression retValue = CifValueUtils.getDefaultValue(ftype.getReturnType(), funcs);
                ReturnFuncStatement stat = CifConstructors.newReturnFuncStatement();
                stat.getValues().add((Object)retValue);
                function.getStatements().add((Object)stat);
                funcs.add(function);
            }
            FunctionExpression rslt = CifConstructors.newFunctionExpression();
            rslt.setFunction((Function)function);
            rslt.setType((CifType)EMFHelper.deepclone((EObject)ftype));
            return rslt;
        }
        if (type instanceof DictType) {
            DictExpression rslt = CifConstructors.newDictExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            return rslt;
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            TupleExpression rslt = CifConstructors.newTupleExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            for (Field field : ttype.getFields()) {
                Expression value = CifValueUtils.getDefaultValue(field.getType(), funcs);
                rslt.getFields().add((Object)value);
            }
            return rslt;
        }
        if (type instanceof DistType) {
            DistType dtype = (DistType)type;
            FuncType ftype = CifConstructors.newFuncType();
            ftype.setReturnType((CifType)EMFHelper.deepclone((EObject)type));
            ftype.getParamTypes().add((Object)((CifType)EMFHelper.deepclone((EObject)dtype.getSampleType())));
            StdLibFunctionExpression func = CifConstructors.newStdLibFunctionExpression();
            func.setFunction(StdLibFunction.CONSTANT);
            func.setType((CifType)ftype);
            Expression arg = CifValueUtils.getDefaultValue(dtype.getSampleType(), funcs);
            FunctionCallExpression rslt = CifConstructors.newFunctionCallExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            rslt.setFunction((Expression)func);
            rslt.getArguments().add((Object)arg);
            return rslt;
        }
        throw new RuntimeException("Unexpected type: " + String.valueOf(type));
    }

    public static boolean isInitialExpr(Expression expr) {
        Expression parent = expr;
        EStructuralFeature feat = null;
        while (parent instanceof Expression) {
            feat = parent.eContainingFeature();
            parent = parent.eContainer();
        }
        Assert.notNull(feat);
        if (parent instanceof VariableValue) {
            DiscVariable var = (DiscVariable)parent.eContainer();
            return var.eContainer() instanceof ComplexComponent;
        }
        if (parent instanceof ContVariable && feat == DeclarationsPackage.Literals.CONT_VARIABLE__VALUE) {
            return true;
        }
        if (parent instanceof ComplexComponent && feat == CifPackage.Literals.COMPLEX_COMPONENT__INITIALS) {
            return true;
        }
        return parent instanceof Location && feat == AutomataPackage.Literals.LOCATION__INITIALS;
    }

    public static boolean isTimeConstant(Expression expr, Boolean isInputVarTimeConstant) {
        if (expr instanceof BoolExpression) {
            return true;
        }
        if (expr instanceof IntExpression) {
            return true;
        }
        if (expr instanceof RealExpression) {
            return true;
        }
        if (expr instanceof StringExpression) {
            return true;
        }
        if (expr instanceof TimeExpression) {
            return false;
        }
        if (expr instanceof CastExpression) {
            CastExpression cexpr = (CastExpression)expr;
            return CifValueUtils.isTimeConstant(cexpr.getChild(), isInputVarTimeConstant);
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression uexpr = (UnaryExpression)expr;
            return CifValueUtils.isTimeConstant(uexpr.getChild(), isInputVarTimeConstant);
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            return CifValueUtils.isTimeConstant(bexpr.getLeft(), isInputVarTimeConstant) && CifValueUtils.isTimeConstant(bexpr.getRight(), isInputVarTimeConstant);
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            for (Expression guard : ifExpr.getGuards()) {
                if (CifValueUtils.isTimeConstant(guard, isInputVarTimeConstant)) continue;
                return false;
            }
            if (!CifValueUtils.isTimeConstant(ifExpr.getThen(), isInputVarTimeConstant)) {
                return false;
            }
            for (ElifExpression elif : ifExpr.getElifs()) {
                for (Expression guard : elif.getGuards()) {
                    if (CifValueUtils.isTimeConstant(guard, isInputVarTimeConstant)) continue;
                    return false;
                }
                if (CifValueUtils.isTimeConstant(elif.getThen(), isInputVarTimeConstant)) continue;
                return false;
            }
            return CifValueUtils.isTimeConstant(ifExpr.getElse(), isInputVarTimeConstant);
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression switchExpr = (SwitchExpression)expr;
            if (!CifValueUtils.isTimeConstant(switchExpr.getValue(), isInputVarTimeConstant)) {
                return false;
            }
            for (SwitchCase cse : switchExpr.getCases()) {
                if (cse.getKey() != null && !CifValueUtils.isTimeConstant(cse.getKey(), isInputVarTimeConstant)) {
                    return false;
                }
                if (CifValueUtils.isTimeConstant(cse.getValue(), isInputVarTimeConstant)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression pexpr = (ProjectionExpression)expr;
            if (!CifValueUtils.isTimeConstant(pexpr.getChild(), isInputVarTimeConstant)) {
                return false;
            }
            if (pexpr.getIndex() instanceof FieldExpression) {
                return true;
            }
            return CifValueUtils.isTimeConstant(pexpr.getIndex(), isInputVarTimeConstant);
        }
        if (expr instanceof SliceExpression) {
            SliceExpression sexpr = (SliceExpression)expr;
            if (!CifValueUtils.isTimeConstant(sexpr.getChild(), isInputVarTimeConstant)) {
                return false;
            }
            if (sexpr.getBegin() != null && !CifValueUtils.isTimeConstant(sexpr.getBegin(), isInputVarTimeConstant)) {
                return false;
            }
            return sexpr.getEnd() == null || CifValueUtils.isTimeConstant(sexpr.getEnd(), isInputVarTimeConstant);
        }
        if (expr instanceof FunctionCallExpression) {
            FunctionCallExpression fcexpr = (FunctionCallExpression)expr;
            if (!(fcexpr.getFunction() instanceof StdLibFunctionExpression) && !CifValueUtils.isTimeConstant(fcexpr.getFunction(), isInputVarTimeConstant)) {
                return false;
            }
            for (Expression arg : fcexpr.getArguments()) {
                if (CifValueUtils.isTimeConstant(arg, isInputVarTimeConstant)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            for (Expression elem : lexpr.getElements()) {
                if (CifValueUtils.isTimeConstant(elem, isInputVarTimeConstant)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            for (Expression elem : sexpr.getElements()) {
                if (CifValueUtils.isTimeConstant(elem, isInputVarTimeConstant)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            for (Expression elem : texpr.getFields()) {
                if (CifValueUtils.isTimeConstant(elem, isInputVarTimeConstant)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            for (DictPair pair : dexpr.getPairs()) {
                if (!CifValueUtils.isTimeConstant(pair.getKey(), isInputVarTimeConstant)) {
                    return false;
                }
                if (CifValueUtils.isTimeConstant(pair.getValue(), isInputVarTimeConstant)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ConstantExpression) {
            return true;
        }
        if (expr instanceof DiscVariableExpression) {
            return true;
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariable var = ((AlgVariableExpression)expr).getVariable();
            Expression value = var.getValue();
            if (value != null) {
                return CifValueUtils.isTimeConstant(value, isInputVarTimeConstant);
            }
            if (var.eContainer() instanceof Parameter) {
                throw new RuntimeException("unsupported alg param: " + String.valueOf(var));
            }
            List<Expression> values = CifEquationUtils.getValuesForAlgVar(var, false);
            for (Expression val : values) {
                if (CifValueUtils.isTimeConstant(val, isInputVarTimeConstant)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ContVariableExpression) {
            ContVariableExpression cexpr = (ContVariableExpression)expr;
            if (cexpr.isDerivative()) {
                ContVariable var = cexpr.getVariable();
                Expression deriv = var.getDerivative();
                if (deriv != null) {
                    return CifValueUtils.isTimeConstant(deriv, isInputVarTimeConstant);
                }
                List<Expression> derivs = CifEquationUtils.getDerivativesForContVar(var, false);
                for (Expression d : derivs) {
                    if (CifValueUtils.isTimeConstant(d, isInputVarTimeConstant)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (expr instanceof TauExpression) {
            throw new RuntimeException("Tau expression in value context.");
        }
        if (expr instanceof LocationExpression) {
            return true;
        }
        if (expr instanceof EnumLiteralExpression) {
            return true;
        }
        if (expr instanceof EventExpression) {
            throw new RuntimeException("Event expression in value context.");
        }
        if (expr instanceof FieldExpression) {
            String msg = "Unexpected field expr: proj expr should handle it.";
            throw new RuntimeException(msg);
        }
        if (expr instanceof StdLibFunctionExpression) {
            String msg = "Stdlib functions can not be used as values.";
            throw new RuntimeException(msg);
        }
        if (expr instanceof FunctionExpression) {
            return true;
        }
        if (expr instanceof InputVariableExpression) {
            return isInputVarTimeConstant;
        }
        if (expr instanceof ComponentExpression) {
            return true;
        }
        if (expr instanceof CompParamExpression) {
            return true;
        }
        if (expr instanceof CompInstWrapExpression) {
            Expression rexpr = ((CompInstWrapExpression)expr).getReference();
            return CifValueUtils.isTimeConstant(rexpr, isInputVarTimeConstant);
        }
        if (expr instanceof CompParamWrapExpression) {
            Expression rexpr = ((CompParamWrapExpression)expr).getReference();
            return CifValueUtils.isTimeConstant(rexpr, isInputVarTimeConstant);
        }
        if (expr instanceof ReceivedExpression) {
            return true;
        }
        if (expr instanceof SelfExpression) {
            return true;
        }
        throw new RuntimeException("Unknown expr: " + String.valueOf(expr));
    }

    public static Boolean areStructurallySameExpression(Expression expr1, Expression expr2) {
        if (!expr1.getClass().equals(expr2.getClass())) {
            return false;
        }
        if (expr1 instanceof BoolExpression) {
            BoolExpression bexpr1 = (BoolExpression)expr1;
            if (expr2 instanceof BoolExpression) {
                BoolExpression bexpr2 = (BoolExpression)expr2;
                if (bexpr1.isValue() == bexpr2.isValue()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof IntExpression) {
            IntExpression iexpr1 = (IntExpression)expr1;
            if (expr2 instanceof IntExpression) {
                IntExpression iexpr2 = (IntExpression)expr2;
                if (iexpr1.getValue() == iexpr2.getValue()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof RealExpression) {
            RealExpression rExpr1 = (RealExpression)expr1;
            if (expr2 instanceof RealExpression) {
                RealExpression rexpr2 = (RealExpression)expr2;
                return rExpr1.getValue().equals(rexpr2.getValue());
            }
        }
        if (expr1 instanceof StringExpression) {
            StringExpression sexpr1 = (StringExpression)expr1;
            if (expr2 instanceof StringExpression) {
                StringExpression sexpr2 = (StringExpression)expr2;
                return sexpr1.getValue().equals(sexpr2.getValue());
            }
        }
        if (expr1 instanceof TimeExpression && expr2 instanceof TimeExpression) {
            return true;
        }
        if (expr1 instanceof CastExpression) {
            CastExpression cexpr1 = (CastExpression)expr1;
            if (expr2 instanceof CastExpression) {
                CastExpression cexpr2 = (CastExpression)expr2;
                if (!CifValueUtils.areStructurallySameExpression(cexpr1.getChild(), cexpr2.getChild()).booleanValue()) {
                    return false;
                }
                return CifTypeUtils.areStructurallySameType(cexpr1.getType(), cexpr2.getType());
            }
        }
        if (expr1 instanceof UnaryExpression) {
            UnaryExpression uexpr1 = (UnaryExpression)expr1;
            if (expr2 instanceof UnaryExpression) {
                UnaryExpression uexpr2 = (UnaryExpression)expr2;
                if (uexpr1.getOperator() == uexpr2.getOperator() && CifValueUtils.areStructurallySameExpression(uexpr1.getChild(), uexpr2.getChild()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof BinaryExpression) {
            BinaryExpression bexpr1 = (BinaryExpression)expr1;
            if (expr2 instanceof BinaryExpression) {
                BinaryExpression bexpr2 = (BinaryExpression)expr2;
                if (bexpr1.getOperator() == bexpr2.getOperator() && CifValueUtils.areStructurallySameExpression(bexpr1.getLeft(), bexpr2.getLeft()).booleanValue() && CifValueUtils.areStructurallySameExpression(bexpr1.getRight(), bexpr2.getRight()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof IfExpression) {
            IfExpression iexpr1 = (IfExpression)expr1;
            if (expr2 instanceof IfExpression) {
                IfExpression iexpr2 = (IfExpression)expr2;
                if (iexpr1.getGuards().size() != iexpr2.getGuards().size()) {
                    return false;
                }
                int i = 0;
                while (i < iexpr1.getGuards().size()) {
                    if (!CifValueUtils.areStructurallySameExpression((Expression)iexpr1.getGuards().get(i), (Expression)iexpr2.getGuards().get(i)).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
                if (!CifValueUtils.areStructurallySameExpression(iexpr1.getThen(), iexpr2.getThen()).booleanValue()) {
                    return false;
                }
                if (iexpr1.getElifs().size() != iexpr2.getElifs().size()) {
                    return false;
                }
                i = 0;
                while (i < iexpr1.getElifs().size()) {
                    ElifExpression elif1 = (ElifExpression)iexpr1.getElifs().get(i);
                    ElifExpression elif2 = (ElifExpression)iexpr2.getElifs().get(i);
                    if (elif1.getGuards().size() != elif2.getGuards().size()) {
                        return false;
                    }
                    int j = 0;
                    while (j < elif1.getGuards().size()) {
                        if (!CifValueUtils.areStructurallySameExpression((Expression)elif1.getGuards().get(j), (Expression)elif2.getGuards().get(j)).booleanValue()) {
                            return false;
                        }
                        ++j;
                    }
                    if (!CifValueUtils.areStructurallySameExpression(elif1.getThen(), elif2.getThen()).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
                if (!CifValueUtils.areStructurallySameExpression(iexpr1.getElse(), iexpr2.getElse()).booleanValue()) {
                    return false;
                }
                return true;
            }
        }
        if (expr1 instanceof SwitchExpression) {
            SwitchExpression sexpr1 = (SwitchExpression)expr1;
            if (expr2 instanceof SwitchExpression) {
                SwitchExpression sexpr2 = (SwitchExpression)expr2;
                if (!CifValueUtils.areStructurallySameExpression(sexpr1.getValue(), sexpr2.getValue()).booleanValue()) {
                    return false;
                }
                if (sexpr1.getCases().size() != sexpr2.getCases().size()) {
                    return false;
                }
                int i = 0;
                while (i < sexpr1.getCases().size()) {
                    SwitchCase switchCase1 = (SwitchCase)sexpr1.getCases().get(i);
                    SwitchCase switchCase2 = (SwitchCase)sexpr2.getCases().get(i);
                    if (switchCase1.getKey() == null != (switchCase2.getKey() == null)) {
                        return false;
                    }
                    if (switchCase1.getKey() != null && !CifValueUtils.areStructurallySameExpression(switchCase1.getKey(), switchCase2.getKey()).booleanValue()) {
                        return false;
                    }
                    if (!CifValueUtils.areStructurallySameExpression(switchCase1.getValue(), switchCase2.getValue()).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        if (expr1 instanceof ProjectionExpression) {
            ProjectionExpression pexpr1 = (ProjectionExpression)expr1;
            if (expr2 instanceof ProjectionExpression) {
                ProjectionExpression pexpr2 = (ProjectionExpression)expr2;
                if (CifValueUtils.areStructurallySameExpression(pexpr1.getChild(), pexpr2.getChild()).booleanValue() && CifValueUtils.areStructurallySameExpression(pexpr1.getIndex(), pexpr2.getIndex()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof SliceExpression) {
            SliceExpression sexpr1 = (SliceExpression)expr1;
            if (expr2 instanceof SliceExpression) {
                SliceExpression sexpr2 = (SliceExpression)expr2;
                if (sexpr1.getBegin() == null != (sexpr2.getBegin() == null)) {
                    return false;
                }
                if (sexpr1.getBegin() != null && !CifValueUtils.areStructurallySameExpression(sexpr1.getBegin(), sexpr2.getBegin()).booleanValue()) {
                    return false;
                }
                if (sexpr1.getEnd() == null != (sexpr2.getEnd() == null)) {
                    return false;
                }
                if (sexpr1.getEnd() != null && !CifValueUtils.areStructurallySameExpression(sexpr1.getEnd(), sexpr2.getEnd()).booleanValue()) {
                    return false;
                }
                return CifValueUtils.areStructurallySameExpression(sexpr1.getChild(), sexpr2.getChild());
            }
        }
        if (expr1 instanceof FunctionCallExpression) {
            FunctionCallExpression fcexpr1 = (FunctionCallExpression)expr1;
            if (expr2 instanceof FunctionCallExpression) {
                FunctionCallExpression fcexpr2 = (FunctionCallExpression)expr2;
                if (!CifValueUtils.areStructurallySameExpression(fcexpr1.getFunction(), fcexpr2.getFunction()).booleanValue()) {
                    return false;
                }
                int i = 0;
                while (i < fcexpr1.getArguments().size()) {
                    if (!CifValueUtils.areStructurallySameExpression((Expression)fcexpr1.getArguments().get(i), (Expression)fcexpr2.getArguments().get(i)).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        if (expr1 instanceof ListExpression) {
            ListExpression lexpr1 = (ListExpression)expr1;
            if (expr2 instanceof ListExpression) {
                ListExpression lexpr2 = (ListExpression)expr2;
                if (lexpr1.getElements().size() != lexpr2.getElements().size()) {
                    return false;
                }
                int i = 0;
                while (i < lexpr1.getElements().size()) {
                    if (!CifValueUtils.areStructurallySameExpression((Expression)lexpr1.getElements().get(i), (Expression)lexpr2.getElements().get(i)).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        if (expr1 instanceof SetExpression) {
            SetExpression sexpr1 = (SetExpression)expr1;
            if (expr2 instanceof SetExpression) {
                SetExpression sexpr2 = (SetExpression)expr2;
                if (sexpr1.getElements().size() != sexpr2.getElements().size()) {
                    return false;
                }
                int i = 0;
                while (i < sexpr1.getElements().size()) {
                    if (!CifValueUtils.areStructurallySameExpression((Expression)sexpr1.getElements().get(i), (Expression)sexpr2.getElements().get(i)).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        if (expr1 instanceof TupleExpression) {
            TupleExpression texpr1 = (TupleExpression)expr1;
            if (expr2 instanceof TupleExpression) {
                TupleExpression texpr2 = (TupleExpression)expr2;
                if (texpr1.getFields().size() != texpr2.getFields().size()) {
                    return false;
                }
                int i = 0;
                while (i < texpr1.getFields().size()) {
                    if (!CifValueUtils.areStructurallySameExpression((Expression)texpr1.getFields().get(i), (Expression)texpr2.getFields().get(i)).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        if (expr1 instanceof DictExpression) {
            DictExpression dexpr1 = (DictExpression)expr1;
            if (expr2 instanceof DictExpression) {
                DictExpression dexpr2 = (DictExpression)expr2;
                if (dexpr1.getPairs().size() != dexpr2.getPairs().size()) {
                    return false;
                }
                int i = 0;
                while (i < dexpr1.getPairs().size()) {
                    DictPair dictPair1 = (DictPair)dexpr1.getPairs().get(i);
                    DictPair dictPair2 = (DictPair)dexpr2.getPairs().get(i);
                    if (!CifValueUtils.areStructurallySameExpression(dictPair1.getKey(), dictPair2.getKey()).booleanValue() || !CifValueUtils.areStructurallySameExpression(dictPair1.getValue(), dictPair2.getValue()).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        if (expr1 instanceof ConstantExpression) {
            ConstantExpression cexpr1 = (ConstantExpression)expr1;
            if (expr2 instanceof ConstantExpression) {
                ConstantExpression cexpr2 = (ConstantExpression)expr2;
                if (cexpr1.getConstant() == cexpr2.getConstant()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof DiscVariableExpression) {
            DiscVariableExpression dexpr1 = (DiscVariableExpression)expr1;
            if (expr2 instanceof DiscVariableExpression) {
                DiscVariableExpression dexpr2 = (DiscVariableExpression)expr2;
                if (dexpr1.getVariable() == dexpr2.getVariable()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof AlgVariableExpression) {
            AlgVariableExpression aexpr1 = (AlgVariableExpression)expr1;
            if (expr2 instanceof AlgVariableExpression) {
                AlgVariableExpression aexpr2 = (AlgVariableExpression)expr2;
                if (aexpr1.getVariable() == aexpr2.getVariable()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof ContVariableExpression) {
            ContVariableExpression cexpr1 = (ContVariableExpression)expr1;
            if (expr2 instanceof ContVariableExpression) {
                ContVariableExpression cexpr2 = (ContVariableExpression)expr2;
                if (cexpr1.getVariable() == cexpr2.getVariable() && cexpr1.isDerivative() == cexpr2.isDerivative()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof TauExpression && expr2 instanceof TauExpression) {
            return true;
        }
        if (expr1 instanceof LocationExpression) {
            LocationExpression lexpr1 = (LocationExpression)expr1;
            if (expr2 instanceof LocationExpression) {
                LocationExpression lexpr2 = (LocationExpression)expr2;
                if (lexpr1.getLocation() == lexpr2.getLocation()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof EnumLiteralExpression) {
            EnumLiteralExpression elexpr1 = (EnumLiteralExpression)expr1;
            if (expr2 instanceof EnumLiteralExpression) {
                EnumLiteralExpression elexpr2 = (EnumLiteralExpression)expr2;
                if (elexpr1.getLiteral() == elexpr2.getLiteral()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof EventExpression) {
            EventExpression eexpr1 = (EventExpression)expr1;
            if (expr2 instanceof EventExpression) {
                EventExpression eexpr2 = (EventExpression)expr2;
                if (eexpr1.getEvent() == eexpr2.getEvent()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof FieldExpression) {
            FieldExpression fexpr1 = (FieldExpression)expr1;
            if (expr2 instanceof FieldExpression) {
                FieldExpression fexpr2 = (FieldExpression)expr2;
                return Objects.equals(fexpr1.getField().getName(), fexpr2.getField().getName());
            }
        }
        if (expr1 instanceof StdLibFunctionExpression) {
            StdLibFunctionExpression slfexpr1 = (StdLibFunctionExpression)expr1;
            if (expr2 instanceof StdLibFunctionExpression) {
                StdLibFunctionExpression slfexpr2 = (StdLibFunctionExpression)expr2;
                if (slfexpr1.getFunction() == slfexpr2.getFunction()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof FunctionExpression) {
            FunctionExpression fexpr1 = (FunctionExpression)expr1;
            if (expr2 instanceof FunctionExpression) {
                FunctionExpression fexpr2 = (FunctionExpression)expr2;
                if (fexpr1.getFunction() == fexpr2.getFunction()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof InputVariableExpression) {
            InputVariableExpression ivexpr1 = (InputVariableExpression)expr1;
            if (expr2 instanceof InputVariableExpression) {
                InputVariableExpression ivexpr2 = (InputVariableExpression)expr2;
                if (ivexpr1.getVariable() == ivexpr2.getVariable()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof ComponentExpression) {
            ComponentExpression cexpr1 = (ComponentExpression)expr1;
            if (expr2 instanceof ComponentExpression) {
                ComponentExpression cexpr2 = (ComponentExpression)expr2;
                if (cexpr1.getComponent() == cexpr2.getComponent()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof CompParamExpression) {
            CompParamExpression cexpr1 = (CompParamExpression)expr1;
            if (expr2 instanceof CompParamExpression) {
                CompParamExpression cexpr2 = (CompParamExpression)expr2;
                if (cexpr1.getParameter() == cexpr2.getParameter()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof CompInstWrapExpression) {
            CompInstWrapExpression ciwexpr1 = (CompInstWrapExpression)expr1;
            if (expr2 instanceof CompInstWrapExpression) {
                CompInstWrapExpression ciwexpr2 = (CompInstWrapExpression)expr2;
                if (ciwexpr1.getInstantiation() == ciwexpr2.getInstantiation() && CifValueUtils.areStructurallySameExpression(ciwexpr1.getReference(), ciwexpr2.getReference()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof CompParamWrapExpression) {
            CompParamWrapExpression cpwexpr1 = (CompParamWrapExpression)expr1;
            if (expr2 instanceof CompParamWrapExpression) {
                CompParamWrapExpression cpwexpr2 = (CompParamWrapExpression)expr2;
                if (cpwexpr1.getParameter() == cpwexpr2.getParameter() && CifValueUtils.areStructurallySameExpression(cpwexpr1.getReference(), cpwexpr2.getReference()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof ReceivedExpression && expr2 instanceof ReceivedExpression) {
            return true;
        }
        if (expr1 instanceof SelfExpression && expr2 instanceof SelfExpression) {
            return CifScopeUtils.getScope((PositionObject)expr1).equals(CifScopeUtils.getScope((PositionObject)expr2));
        }
        throw new RuntimeException("Unexpected expressions: " + String.valueOf(expr1) + ", " + String.valueOf(expr2));
    }

    public static int hashExpr(Expression expr) {
        if (expr instanceof BoolExpression) {
            BoolExpression bExpr = (BoolExpression)expr;
            return bExpr.isValue() ? 1231 : 1237;
        }
        if (expr instanceof IntExpression) {
            IntExpression iExpr = (IntExpression)expr;
            return iExpr.getValue();
        }
        if (expr instanceof RealExpression) {
            RealExpression rExpr = (RealExpression)expr;
            return rExpr.getValue().hashCode();
        }
        if (expr instanceof StringExpression) {
            StringExpression sExpr = (StringExpression)expr;
            return sExpr.getValue().hashCode();
        }
        if (expr instanceof TimeExpression) {
            return 1;
        }
        if (expr instanceof CastExpression) {
            CastExpression cExpr = (CastExpression)expr;
            return CifTypeUtils.hashType(cExpr.getType()) + CifValueUtils.hashExpr(cExpr.getChild());
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression uExpr = (UnaryExpression)expr;
            return uExpr.getOperator().hashCode() + CifValueUtils.hashExpr(uExpr.getChild());
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bExpr = (BinaryExpression)expr;
            return CifValueUtils.hashExpr(bExpr.getLeft()) + bExpr.getOperator().hashCode() + CifValueUtils.hashExpr(bExpr.getRight());
        }
        if (expr instanceof IfExpression) {
            IfExpression iExpr = (IfExpression)expr;
            int rslt = 8;
            for (Expression guard : iExpr.getGuards()) {
                rslt += CifValueUtils.hashExpr(guard);
            }
            rslt += CifValueUtils.hashExpr(iExpr.getThen());
            for (ElifExpression elifExpr : iExpr.getElifs()) {
                for (Expression guard : elifExpr.getGuards()) {
                    rslt += CifValueUtils.hashExpr(guard);
                }
                rslt += CifValueUtils.hashExpr(elifExpr.getThen());
            }
            return rslt += CifValueUtils.hashExpr(iExpr.getElse());
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression sExpr = (SwitchExpression)expr;
            int rslt = 64;
            rslt += CifValueUtils.hashExpr(sExpr.getValue());
            for (SwitchCase sCase : sExpr.getCases()) {
                if (sCase.getKey() != null) {
                    rslt += CifValueUtils.hashExpr(sCase.getKey());
                }
                rslt += CifValueUtils.hashExpr(sCase.getValue());
            }
            return rslt;
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression pExpr = (ProjectionExpression)expr;
            return CifValueUtils.hashExpr(pExpr.getChild()) + CifValueUtils.hashExpr(pExpr.getIndex());
        }
        if (expr instanceof SliceExpression) {
            SliceExpression sExpr = (SliceExpression)expr;
            int rslt = CifValueUtils.hashExpr(sExpr.getChild());
            if (sExpr.getBegin() != null) {
                rslt += CifValueUtils.hashExpr(sExpr.getBegin());
            }
            if (sExpr.getEnd() != null) {
                rslt += CifValueUtils.hashExpr(sExpr.getEnd());
            }
            return rslt;
        }
        if (expr instanceof FunctionCallExpression) {
            FunctionCallExpression fcExpr = (FunctionCallExpression)expr;
            int rslt = 512;
            rslt += CifValueUtils.hashExpr(fcExpr.getFunction());
            for (Expression argument : fcExpr.getArguments()) {
                rslt += CifValueUtils.hashExpr(argument);
            }
            return rslt;
        }
        if (expr instanceof ListExpression) {
            ListExpression lExpr = (ListExpression)expr;
            int rslt = 4096;
            for (Expression element : lExpr.getElements()) {
                rslt += CifValueUtils.hashExpr(element);
            }
            return rslt;
        }
        if (expr instanceof SetExpression) {
            SetExpression sExpr = (SetExpression)expr;
            int rslt = 32768;
            for (Expression element : sExpr.getElements()) {
                rslt += CifValueUtils.hashExpr(element);
            }
            return rslt;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression tExpr = (TupleExpression)expr;
            int rslt = 262144;
            for (Expression field : tExpr.getFields()) {
                rslt += CifValueUtils.hashExpr(field);
            }
            return rslt;
        }
        if (expr instanceof DictExpression) {
            DictExpression dExpr = (DictExpression)expr;
            int rslt = 0x200000;
            for (DictPair pair : dExpr.getPairs()) {
                rslt += CifValueUtils.hashExpr(pair.getKey()) + CifValueUtils.hashExpr(pair.getValue());
            }
            return rslt;
        }
        if (expr instanceof ConstantExpression) {
            ConstantExpression cExpr = (ConstantExpression)expr;
            return cExpr.getConstant().hashCode();
        }
        if (expr instanceof DiscVariableExpression) {
            DiscVariableExpression dvExpr = (DiscVariableExpression)expr;
            return dvExpr.getVariable().hashCode();
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariableExpression aExpr = (AlgVariableExpression)expr;
            return aExpr.getVariable().hashCode();
        }
        if (expr instanceof ContVariableExpression) {
            ContVariableExpression cExpr = (ContVariableExpression)expr;
            return cExpr.getVariable().hashCode() + (cExpr.isDerivative() ? 1231 : 1237);
        }
        if (expr instanceof TauExpression) {
            return 0x1000000;
        }
        if (expr instanceof LocationExpression) {
            LocationExpression lExpr = (LocationExpression)expr;
            return lExpr.getLocation().hashCode();
        }
        if (expr instanceof EnumLiteralExpression) {
            EnumLiteralExpression elExpr = (EnumLiteralExpression)expr;
            return elExpr.getLiteral().hashCode();
        }
        if (expr instanceof EventExpression) {
            EventExpression eExpr = (EventExpression)expr;
            return eExpr.getEvent().hashCode();
        }
        if (expr instanceof FieldExpression) {
            FieldExpression fExpr = (FieldExpression)expr;
            int rslt = 0x8000000;
            String fieldName = fExpr.getField().getName();
            if (fieldName != null) {
                rslt += fieldName.hashCode();
            }
            return rslt;
        }
        if (expr instanceof StdLibFunctionExpression) {
            StdLibFunctionExpression slfExpr = (StdLibFunctionExpression)expr;
            return slfExpr.getFunction().hashCode();
        }
        if (expr instanceof FunctionExpression) {
            FunctionExpression fExpr = (FunctionExpression)expr;
            return fExpr.getFunction().hashCode();
        }
        if (expr instanceof InputVariableExpression) {
            InputVariableExpression iExpr = (InputVariableExpression)expr;
            return iExpr.getVariable().hashCode();
        }
        if (expr instanceof ComponentExpression) {
            ComponentExpression cExpr = (ComponentExpression)expr;
            return cExpr.getComponent().hashCode();
        }
        if (expr instanceof CompParamExpression) {
            CompParamExpression cpExpr = (CompParamExpression)expr;
            return cpExpr.getParameter().hashCode();
        }
        if (expr instanceof CompInstWrapExpression) {
            CompInstWrapExpression ciwExpr = (CompInstWrapExpression)expr;
            return ciwExpr.getInstantiation().hashCode() + CifValueUtils.hashExpr(ciwExpr.getReference());
        }
        if (expr instanceof CompParamWrapExpression) {
            CompParamWrapExpression cpwExpr = (CompParamWrapExpression)expr;
            return cpwExpr.getParameter().hashCode() + CifValueUtils.hashExpr(cpwExpr.getReference());
        }
        if (expr instanceof ReceivedExpression) {
            return 0x40000000;
        }
        if (expr instanceof SelfExpression) {
            return Integer.MIN_VALUE;
        }
        throw new RuntimeException("Unexpected expression: " + expr.toString());
    }

    public static Expression createConjunction(List<Expression> exprs) {
        return CifValueUtils.createConjunction(exprs, false);
    }

    public static Expression createConjunction(List<Expression> exprs, boolean optimize) {
        if (exprs.isEmpty()) {
            return CifValueUtils.makeTrue();
        }
        BinaryOperator operator = BinaryOperator.CONJUNCTION;
        List flattenedChildren = CifValueUtils.flattenBinExpr(exprs, operator);
        if (optimize) {
            List children = Lists.listc((int)flattenedChildren.size());
            for (Expression child : flattenedChildren) {
                boolean add = true;
                if (child instanceof BoolExpression) {
                    boolean value = ((BoolExpression)child).isValue();
                    if (!value) {
                        return child;
                    }
                    add = false;
                }
                if (!add) continue;
                children.add(child);
            }
            if (children.isEmpty()) {
                return CifValueUtils.makeTrue();
            }
            flattenedChildren = children;
        }
        int treeSize = flattenedChildren.size();
        return CifValueUtils.createBalancedBinaryTree(flattenedChildren, 0, treeSize, operator);
    }

    public static Expression createDisjunction(List<Expression> exprs) {
        return CifValueUtils.createDisjunction(exprs, false);
    }

    public static Expression createDisjunction(List<Expression> exprs, boolean optimize) {
        if (exprs.isEmpty()) {
            return CifValueUtils.makeFalse();
        }
        BinaryOperator operator = BinaryOperator.DISJUNCTION;
        List flattenedChildren = CifValueUtils.flattenBinExpr(exprs, operator);
        if (optimize) {
            List children = Lists.listc((int)flattenedChildren.size());
            for (Expression child : flattenedChildren) {
                boolean add = true;
                if (child instanceof BoolExpression) {
                    boolean value = ((BoolExpression)child).isValue();
                    if (value) {
                        return child;
                    }
                    add = false;
                }
                if (!add) continue;
                children.add(child);
            }
            if (children.isEmpty()) {
                return CifValueUtils.makeFalse();
            }
            flattenedChildren = children;
        }
        int treeSize = flattenedChildren.size();
        return CifValueUtils.createBalancedBinaryTree(flattenedChildren, 0, treeSize, operator);
    }

    public static List<Expression> flattenBinExpr(List<Expression> exprs, BinaryOperator operator) {
        if (exprs.size() == 0) {
            return Collections.emptyList();
        }
        ArrayDeque<Expression> todos = new ArrayDeque<Expression>(exprs);
        List children = Lists.listc((int)todos.size());
        while (!todos.isEmpty()) {
            BinaryExpression btodo;
            Expression todo = todos.pollFirst();
            if (todo instanceof BinaryExpression && (btodo = (BinaryExpression)todo).getOperator() == operator) {
                todos.addFirst(btodo.getRight());
                todos.addFirst(btodo.getLeft());
                continue;
            }
            children.add(todo);
        }
        return children;
    }

    public static Expression createBalancedBinaryTree(List<Expression> exprs, int lower, int upper, BinaryOperator operator) {
        Assert.check((lower < upper ? 1 : 0) != 0);
        if (lower + 1 == upper) {
            return exprs.get(lower);
        }
        int size = upper - lower;
        int left = size / 2;
        int mid = lower + left;
        BinaryExpression rslt = CifConstructors.newBinaryExpression();
        rslt.setOperator(operator);
        rslt.setType((CifType)CifConstructors.newBoolType());
        rslt.setLeft(CifValueUtils.createBalancedBinaryTree(exprs, lower, mid, operator));
        rslt.setRight(CifValueUtils.createBalancedBinaryTree(exprs, mid, upper, operator));
        return rslt;
    }

    public static Expression makeInverse(Expression expr) {
        UnaryExpression rslt = CifConstructors.newUnaryExpression();
        rslt.setOperator(UnaryOperator.INVERSE);
        rslt.setType((CifType)CifConstructors.newBoolType());
        rslt.setChild(expr);
        return rslt;
    }

    public static BoolExpression makeBool(boolean value) {
        BoolExpression rslt = CifConstructors.newBoolExpression();
        rslt.setValue(value);
        rslt.setType((CifType)CifConstructors.newBoolType());
        return rslt;
    }

    public static BoolExpression makeFalse() {
        return CifValueUtils.makeBool(false);
    }

    public static BoolExpression makeTrue() {
        return CifValueUtils.makeBool(true);
    }

    public static Expression makeInt(int value) {
        if (value == Integer.MIN_VALUE) {
            Expression left = CifValueUtils.makeInt(value + 1);
            Expression right = CifValueUtils.makeInt(1);
            IntType binType = CifConstructors.newIntType();
            binType.setLower(Integer.valueOf(value));
            binType.setUpper(Integer.valueOf(value));
            BinaryExpression bin = CifConstructors.newBinaryExpression();
            bin.setOperator(BinaryOperator.SUBTRACTION);
            bin.setLeft(left);
            bin.setRight(right);
            bin.setType((CifType)binType);
            return bin;
        }
        int absValue = Math.abs(value);
        IntType absType = CifConstructors.newIntType();
        absType.setLower(Integer.valueOf(absValue));
        absType.setUpper(Integer.valueOf(absValue));
        IntExpression absExpr = CifConstructors.newIntExpression();
        absExpr.setValue(absValue);
        absExpr.setType((CifType)absType);
        if (value >= 0) {
            return absExpr;
        }
        IntType unType = CifConstructors.newIntType();
        unType.setLower(Integer.valueOf(value));
        unType.setUpper(Integer.valueOf(value));
        UnaryExpression un = CifConstructors.newUnaryExpression();
        un.setOperator(UnaryOperator.NEGATE);
        un.setChild((Expression)absExpr);
        un.setType((CifType)unType);
        return un;
    }

    public static Expression makeReal(double value) {
        Assert.check((boolean)Double.isFinite(value));
        double absValue = Math.abs(value);
        RealExpression absExpr = CifConstructors.newRealExpression();
        absExpr.setValue(CifMath.realToStr(absValue));
        absExpr.setType((CifType)CifConstructors.newRealType());
        if (value >= 0.0) {
            return absExpr;
        }
        UnaryExpression un = CifConstructors.newUnaryExpression();
        un.setOperator(UnaryOperator.NEGATE);
        un.setChild((Expression)absExpr);
        un.setType((CifType)CifConstructors.newRealType());
        return un;
    }

    public static Expression makeTuple(List<Expression> elements, Position position) {
        Assert.check((!elements.isEmpty() ? 1 : 0) != 0);
        if (elements.size() == 1) {
            return (Expression)Lists.first(elements);
        }
        TupleType tupleType = CifConstructors.newTupleType();
        tupleType.setPosition(PositionUtils.copyPosition((Position)position));
        for (Expression element : elements) {
            Field field = CifConstructors.newField();
            field.setPosition(PositionUtils.copyPosition((Position)position));
            field.setType((CifType)EMFHelper.deepclone((EObject)element.getType()));
            tupleType.getFields().add((Object)field);
        }
        TupleExpression tuple = CifConstructors.newTupleExpression();
        tuple.setPosition(PositionUtils.copyPosition((Position)position));
        tuple.getFields().addAll(elements);
        tuple.setType((CifType)tupleType);
        return tuple;
    }

    public static Field getTupleProjField(ProjectionExpression pexpr) {
        int idx;
        Expression iexpr = pexpr.getIndex();
        if (iexpr instanceof FieldExpression) {
            return ((FieldExpression)iexpr).getField();
        }
        try {
            idx = (Integer)CifEvalUtils.eval(iexpr, false);
        }
        catch (CifEvalException e) {
            throw new RuntimeException(e);
        }
        CifType ctype = CifTypeUtils.normalizeType(pexpr.getChild().getType());
        return (Field)((TupleType)ctype).getFields().get(idx);
    }

    public static int getTupleProjIndex(ProjectionExpression pexpr) {
        TupleType tupType = (TupleType)CifTypeUtils.normalizeType(pexpr.getChild().getType());
        Expression indexExpr = pexpr.getIndex();
        if (indexExpr instanceof FieldExpression) {
            FieldExpression fe = (FieldExpression)indexExpr;
            return tupType.getFields().indexOf((Object)fe.getField());
        }
        try {
            return (Integer)CifEvalUtils.eval(indexExpr, false);
        }
        catch (CifEvalException e) {
            throw new RuntimeException(e);
        }
    }

    public static Count getPossibleInitialValuesCount(DiscVariable var) {
        VariableValue varValue = var.getValue();
        if (varValue == null) {
            return new Count(1.0, true);
        }
        if (varValue.getValues().size() >= 1) {
            return new Count(varValue.getValues().size(), false);
        }
        return new Count(CifValueUtils.getPossibleValueCount(var.getType()), true);
    }

    public static double getPossibleInitialValuesCount(InputVariable var) {
        return CifValueUtils.getPossibleValueCount(var.getType());
    }

    public static Count getPossibleInitialLocationsCount(Automaton aut) {
        int nrOfLocs = 0;
        boolean isPrecise = true;
        for (Location loc : aut.getLocations()) {
            if (loc.getInitials().isEmpty() || CifValueUtils.isTriviallyFalse((List<Expression>)loc.getInitials(), true, true)) continue;
            if (CifValueUtils.isTriviallyTrue((List<Expression>)loc.getInitials(), true, true)) {
                ++nrOfLocs;
                continue;
            }
            ++nrOfLocs;
            isPrecise = false;
        }
        return new Count(nrOfLocs, isPrecise);
    }

    public static double getPossibleValueCount(CifType type) {
        if ((type = CifTypeUtils.normalizeType(type)) instanceof BoolType) {
            return 2.0;
        }
        if (type instanceof RealType) {
            return Double.POSITIVE_INFINITY;
        }
        if (type instanceof StringType) {
            return Double.POSITIVE_INFINITY;
        }
        if (type instanceof EnumType) {
            EnumDecl enumDecl = ((EnumType)type).getEnum();
            return enumDecl.getLiterals().size();
        }
        if (type instanceof IntType) {
            IntType itype = (IntType)type;
            int lower = CifTypeUtils.getLowerBound(itype);
            int upper = CifTypeUtils.getUpperBound(itype);
            return (double)upper - (double)lower + 1.0;
        }
        if (type instanceof SetType) {
            SetType stype = (SetType)type;
            double ecnt = CifValueUtils.getPossibleValueCount(stype.getElementType());
            return Math.pow(2.0, ecnt);
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            double kcnt = CifValueUtils.getPossibleValueCount(dtype.getKeyType());
            double vcnt = CifValueUtils.getPossibleValueCount(dtype.getValueType());
            return Math.pow(vcnt + 1.0, kcnt);
        }
        if (type instanceof ListType) {
            int upper;
            ListType ltype = (ListType)type;
            double ecnt = CifValueUtils.getPossibleValueCount(ltype.getElementType());
            int lower = CifTypeUtils.getLowerBound(ltype);
            if (lower == (upper = CifTypeUtils.getUpperBound(ltype))) {
                return Math.pow(ecnt, lower);
            }
            if (Double.isInfinite(ecnt)) {
                return ecnt;
            }
            double cnt = CifValueUtils.expSum(ecnt, (double)upper + 1.0);
            if (lower > 0) {
                cnt -= CifValueUtils.expSum(ecnt, lower);
            }
            return cnt;
        }
        if (type instanceof TupleType) {
            double cnt = 1.0;
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                cnt *= CifValueUtils.getPossibleValueCount(field.getType());
            }
            return cnt;
        }
        if (type instanceof FuncType) {
            return Double.POSITIVE_INFINITY;
        }
        if (type instanceof DistType) {
            return Double.POSITIVE_INFINITY;
        }
        throw new RuntimeException("Unexpected type: " + String.valueOf(type));
    }

    public static double expSum(double n, double m) {
        Assert.check((n >= 0.0 || Double.isInfinite(n) ? 1 : 0) != 0);
        Assert.check((m >= 0.0 || Double.isInfinite(m) ? 1 : 0) != 0);
        return n == 1.0 ? m : (1.0 - Math.pow(n, m)) / (1.0 - n);
    }

    /*
     * Unable to fully structure code
     */
    public static List<Expression> getPossibleValues(CifType type) {
        block20: {
            if ((type = CifTypeUtils.normalizeType(type)) instanceof BoolType) {
                return Lists.list((Object[])new BoolExpression[]{CifValueUtils.makeFalse(), CifValueUtils.makeTrue()});
            }
            if (type instanceof EnumType) {
                enumDecl = ((EnumType)type).getEnum();
                lits = enumDecl.getLiterals();
                values = Lists.listc((int)lits.size());
                for (EnumLiteral lit : lits) {
                    litRef = CifConstructors.newEnumLiteralExpression();
                    litRef.setLiteral(lit);
                    litRef.setType((CifType)EMFHelper.deepclone((EObject)type));
                    values.add(litRef);
                }
                return values;
            }
            if (type instanceof IntType) {
                itype = (IntType)type;
                lower = CifTypeUtils.getLowerBound(itype);
                upper = CifTypeUtils.getUpperBound(itype);
                cnt = (long)upper - (long)lower + 1L;
                values = Lists.listc((int)((int)cnt));
                i = lower;
                while (i <= upper) {
                    values.add(CifValueUtils.makeInt(i));
                    ++i;
                }
                return values;
            }
            if (!(type instanceof ListType)) break block20;
            ltype = (ListType)type;
            elemValues = CifValueUtils.getPossibleValues(ltype.getElementType());
            lower = CifTypeUtils.getLowerBound(ltype);
            upper = CifTypeUtils.getUpperBound(ltype);
            lists = Lists.listc((int)((int)CifValueUtils.getPossibleValueCount(type)));
            if (lower == 0) {
                emptyList = CifConstructors.newListExpression();
                emptyList.setType((CifType)EMFHelper.deepclone((EObject)type));
                lists.add(emptyList);
            }
            elemsValues = Lists.listc((int)upper);
            len = lower;
            ** GOTO lbl59
            {
                elemsValues.add(elemValues);
                do {
                    if (elemsValues.size() < len) continue block2;
                    iter = new ListProductIterator(elemsValues);
                    while (iter.hasNext()) {
                        elems = iter.next();
                        array = CifConstructors.newListExpression();
                        for (Expression elem : elems) {
                            array.getElements().add((Object)((Expression)EMFHelper.deepclone((EObject)elem)));
                        }
                        array.setType((CifType)EMFHelper.deepclone((EObject)ltype));
                        lists.add(array);
                    }
                    ++len;
lbl59:
                    // 2 sources

                } while (len <= upper);
            }
            return lists;
        }
        if (type instanceof SetType) {
            stype = (SetType)type;
            elemValues = CifValueUtils.getPossibleValues(stype.getElementType());
            powerset = CifValueUtils.powerSet(elemValues);
            sets = Lists.listc((int)powerset.size());
            for (List<Expression> elems : powerset) {
                sets.add(CifConstructors.newSetExpression(elems, null, (CifType)((CifType)EMFHelper.deepclone((EObject)type))));
            }
            return sets;
        }
        if (type instanceof DictType) {
            dtype = (DictType)type;
            keyValues = CifValueUtils.getPossibleValues(dtype.getKeyType());
            valueValues = CifValueUtils.getPossibleValues(dtype.getValueType());
            powerset = CifValueUtils.powerSet(keyValues);
            dicts = Lists.listc((int)((int)CifValueUtils.getPossibleValueCount(type)));
            emptyDict = CifConstructors.newDictExpression();
            emptyDict.setType((CifType)EMFHelper.deepclone((EObject)type));
            dicts.add(emptyDict);
            for (List<Expression> keys : powerset) {
                if (keys.isEmpty()) continue;
                combis = Lists.listc((int)keys.size());
                i = 0;
                while (i < keys.size()) {
                    combis.add(EMFHelper.deepclone(valueValues));
                    ++i;
                }
                iter = new ListProductIterator(combis);
                while (iter.hasNext()) {
                    singleDict = CifConstructors.newDictExpression();
                    singleDict.setType((CifType)EMFHelper.deepclone((EObject)type));
                    values = iter.next();
                    i = 0;
                    while (i < keys.size()) {
                        key = (Expression)EMFHelper.deepclone((EObject)keys.get(i));
                        value = (Expression)EMFHelper.deepclone((EObject)((Expression)values.get(i)));
                        pair = CifConstructors.newDictPair((Expression)key, null, (Expression)value);
                        singleDict.getPairs().add((Object)pair);
                        ++i;
                    }
                    dicts.add(singleDict);
                }
            }
            return dicts;
        }
        if (type instanceof TupleType) {
            ttype = (TupleType)type;
            fieldsValues = Lists.listc((int)ttype.getFields().size());
            cnt = 1;
            for (Field field : ttype.getFields()) {
                fieldValues = CifValueUtils.getPossibleValues(field.getType());
                fieldsValues.add(fieldValues);
                cnt *= fieldValues.size();
            }
            values = Lists.listc((int)cnt);
            iter = new ListProductIterator(fieldsValues);
            while (iter.hasNext()) {
                elems = iter.next();
                values.add(CifValueUtils.makeTuple(EMFHelper.deepclone((List)elems), null));
            }
            return values;
        }
        throw new RuntimeException("Unexpected type: " + String.valueOf(type));
    }

    private static List<List<Expression>> powerSet(List<Expression> set) {
        int cnt = (int)Math.pow(2.0, set.size());
        List powerset = Lists.listc((int)cnt);
        BitSet combinations = new BitSet(set.size());
        do {
            List singleSet = Lists.listc((int)combinations.cardinality());
            int i = 0;
            while (i < set.size()) {
                if (combinations.get(i)) {
                    singleSet.add((Expression)EMFHelper.deepclone((EObject)set.get(i)));
                }
                ++i;
            }
            powerset.add(singleSet);
        } while (CifValueUtils.incBitSet(combinations, set.size()));
        return powerset;
    }

    private static boolean incBitSet(BitSet bitset, int bitCnt) {
        int i = 0;
        while (i < bitCnt) {
            boolean b = bitset.get(i);
            bitset.set(i, !b);
            if (!b) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isLiteralExpr(Expression expr) {
        UnaryExpression uexpr;
        if (expr instanceof BoolExpression) {
            return true;
        }
        if (expr instanceof IntExpression) {
            return true;
        }
        if (expr instanceof RealExpression) {
            return true;
        }
        if (expr instanceof StringExpression) {
            return true;
        }
        if (expr instanceof EnumLiteralExpression) {
            return true;
        }
        if (expr instanceof FunctionExpression) {
            return true;
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            for (Expression elem : lexpr.getElements()) {
                if (CifValueUtils.isLiteralExpr(elem)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            for (Expression elem : sexpr.getElements()) {
                if (CifValueUtils.isLiteralExpr(elem)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            for (DictPair pair : dexpr.getPairs()) {
                if (!CifValueUtils.isLiteralExpr(pair.getKey())) {
                    return false;
                }
                if (CifValueUtils.isLiteralExpr(pair.getValue())) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            for (Expression field : texpr.getFields()) {
                if (CifValueUtils.isLiteralExpr(field)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof UnaryExpression && (uexpr = (UnaryExpression)expr).getOperator() == UnaryOperator.NEGATE) {
            Expression child = uexpr.getChild();
            if (child instanceof IntExpression) {
                return ((IntExpression)child).getValue() >= 0;
            }
            if (child instanceof RealExpression) {
                return true;
            }
        }
        return false;
    }

    public record Count(double value, boolean isPrecise) {
    }
}

