/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck;

import java.util.List;
import org.eclipse.escet.cif.controllercheck.ControllerChecker;
import org.eclipse.escet.cif.controllercheck.ControllerCheckerResult;
import org.eclipse.escet.cif.controllercheck.ControllerCheckerSettings;
import org.eclipse.escet.cif.controllercheck.options.EnableBoundedResponseChecking;
import org.eclipse.escet.cif.controllercheck.options.EnableConfluenceChecking;
import org.eclipse.escet.cif.controllercheck.options.EnableFiniteResponseChecking;
import org.eclipse.escet.cif.controllercheck.options.EnableNonBlockingUnderControlChecking;
import org.eclipse.escet.cif.controllercheck.options.MaxPrintedCycleStatesOption;
import org.eclipse.escet.cif.controllercheck.options.PrintControlLoopsOutputOption;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.typechecker.postchk.CifAnnotationsPostChecker;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.cif.typechecker.postchk.CifToolPostCheckEnv;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.PathPair;
import org.eclipse.escet.common.typechecker.SemanticException;

public class ControllerCheckerApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        ControllerCheckerApp app = new ControllerCheckerApp();
        app.run(args, true);
    }

    public ControllerCheckerApp() {
    }

    public ControllerCheckerApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "CIF controller properties checker tool";
    }

    public String getAppDescription() {
        return "Checks whether a CIF specification meets certain properties for being a proper controller.";
    }

    protected int runInternal() {
        ControllerCheckerSettings settings = new ControllerCheckerSettings();
        settings.setCheckBoundedResponse(EnableBoundedResponseChecking.checkBoundedResponse());
        settings.setCheckConfluence(EnableConfluenceChecking.checkConfluence());
        settings.setCheckFiniteResponse(EnableFiniteResponseChecking.checkFiniteResponse());
        settings.setCheckNonBlockingUnderControl(EnableNonBlockingUnderControlChecking.checkNonBlockingUnderControl());
        settings.setBoundedResponseMaxPrintedCycleStates(MaxPrintedCycleStatesOption.getMaxPrintedCycleStatesCount());
        settings.setPrintFiniteResponseControlLoops(PrintControlLoopsOutputOption.isPrintControlLoopsEnabled());
        settings.setTermination(() -> this.isTerminationRequested());
        settings.setNormalOutput(OutputProvider.getNormalOutputStream());
        settings.setDebugOutput(OutputProvider.getDebugOutputStream());
        settings.setWarnOutput(OutputProvider.getWarningOutputStream());
        settings.check();
        OutputProvider.dbg((String)"Loading CIF specification \"%s\".", (Object[])new Object[]{InputFileOption.getPath()});
        CifReader cifReader = new CifReader();
        Specification spec = (Specification)((CifReader)cifReader.init()).read();
        String specAbsPath = Paths.resolve((String)InputFileOption.getPath());
        if (this.isTerminationRequested()) {
            return 0;
        }
        ControllerCheckerResult result = ControllerChecker.performChecks(spec, specAbsPath, settings);
        if (this.isTerminationRequested()) {
            return 0;
        }
        result.updateSpecification(spec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        CifToolPostCheckEnv env = new CifToolPostCheckEnv(cifReader.getAbsDirPath(), "output");
        try {
            new CifAnnotationsPostChecker((CifPostCheckEnv)env).check(spec);
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        env.throwUnsupportedExceptionIfAnyErrors("Checking the specification for the requested properties failed.");
        if (this.isTerminationRequested()) {
            return 0;
        }
        String outPath = OutputFileOption.getDerivedPath((String)".cif", (String)".checked.cif");
        String absOutPath = Paths.resolve((String)outPath);
        CifWriter.writeCifSpec((Specification)spec, (PathPair)new PathPair(outPath, absOutPath), (String)cifReader.getAbsDirPath());
        OutputProvider.out();
        OutputProvider.out((String)"The model with the check results has been written to \"%s\".", (Object[])new Object[]{outPath});
        return result.noFailureFound() ? 0 : 1;
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = ControllerCheckerApp.getGeneralOptionCategory();
        List checkOpts = Lists.list();
        checkOpts.add(Options.getInstance(InputFileOption.class));
        checkOpts.add(Options.getInstance(EnableBoundedResponseChecking.class));
        checkOpts.add(Options.getInstance(EnableNonBlockingUnderControlChecking.class));
        checkOpts.add(Options.getInstance(EnableFiniteResponseChecking.class));
        checkOpts.add(Options.getInstance(EnableConfluenceChecking.class));
        checkOpts.add(Options.getInstance(MaxPrintedCycleStatesOption.class));
        checkOpts.add(Options.getInstance(PrintControlLoopsOutputOption.class));
        checkOpts.add(Options.getInstance(OutputFileOption.class));
        OptionCategory checksCat = new OptionCategory("Checks", "Controller properties checker options.", Lists.list(), checkOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, checksCat});
        OptionCategory options = new OptionCategory("CIF Controller properties checker Options", "All options for the CIF controller properties checker tool.", cats, Lists.list());
        return options;
    }
}

