/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.checks.finiteresponse;

import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifSortUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.controllercheck.checks.ControllerCheckerMddBasedCheck;
import org.eclipse.escet.cif.controllercheck.checks.finiteresponse.EventLoop;
import org.eclipse.escet.cif.controllercheck.checks.finiteresponse.EventLoopSearch;
import org.eclipse.escet.cif.controllercheck.checks.finiteresponse.FiniteResponseCheckConclusion;
import org.eclipse.escet.cif.controllercheck.mdd.CifMddSpec;
import org.eclipse.escet.cif.controllercheck.mdd.MddSpecBuilder;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.output.DebugNormalOutput;
import org.eclipse.escet.common.multivaluetrees.Node;
import org.eclipse.escet.common.multivaluetrees.Tree;
import org.eclipse.escet.common.multivaluetrees.VarInfo;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class FiniteResponseCheck
extends ControllerCheckerMddBasedCheck<FiniteResponseCheckConclusion> {
    public static final String PROPERTY_NAME = "finite response";
    private final boolean printControlLoops;
    private Set<Event> controllableEvents;
    private boolean controllableEventsChanged;
    private Map<Event, Set<Declaration>> eventVarUpdate;
    private VarInfo[] nonCtrlIndependentVarsInfos;
    private Map<Event, Node> globalGuardsByEvent;
    private MddSpecBuilder builder;

    public FiniteResponseCheck(boolean printControlLoops) {
        this.printControlLoops = printControlLoops;
    }

    @Override
    public String getPropertyName() {
        return PROPERTY_NAME;
    }

    @Override
    public FiniteResponseCheckConclusion performCheck(CifMddSpec cifMddSpec) {
        int oldSize;
        DebugNormalOutput dbg = cifMddSpec.getDebugOutput();
        List<Automaton> automata = cifMddSpec.getAutomata();
        Assert.check((!automata.isEmpty() ? 1 : 0) != 0);
        this.controllableEvents = Sets.copy(cifMddSpec.getControllableEvents());
        if (this.controllableEvents.isEmpty()) {
            dbg.line("No controllable events. Finite response trivially holds.");
            return new FiniteResponseCheckConclusion(List.of(), this.printControlLoops);
        }
        Termination termination = cifMddSpec.getTermination();
        this.controllableEventsChanged = true;
        this.eventVarUpdate = cifMddSpec.getUpdatedVariablesByEvent();
        this.nonCtrlIndependentVarsInfos = null;
        this.globalGuardsByEvent = cifMddSpec.getGlobalGuardsByEvent();
        this.builder = cifMddSpec.getBuilder();
        Iterator<Event> evtIterator = this.controllableEvents.iterator();
        while (evtIterator.hasNext()) {
            Event evt = evtIterator.next();
            Node n = this.globalGuardsByEvent.get(evt);
            Assert.notNull((Object)n);
            if (n != Tree.ZERO) continue;
            evtIterator.remove();
        }
        if (termination.isRequested()) {
            return null;
        }
        int iterationNumber = 1;
        do {
            if (iterationNumber > 1) {
                dbg.line();
            }
            dbg.line("Iteration %d.", new Object[]{iterationNumber});
            ++iterationNumber;
            oldSize = this.controllableEvents.size();
            dbg.inc();
            for (Automaton aut : automata) {
                this.checkAutomaton(aut, termination, dbg);
                if (!termination.isRequested()) continue;
                dbg.dec();
                return null;
            }
            dbg.dec();
        } while (oldSize != this.controllableEvents.size() && !this.controllableEvents.isEmpty());
        List orderedEvents = Lists.set2list(this.controllableEvents);
        CifSortUtils.sortCifObjects((List)orderedEvents);
        return new FiniteResponseCheckConclusion(orderedEvents, this.printControlLoops);
    }

    private void checkAutomaton(Automaton aut, Termination termination, DebugNormalOutput dbg) {
        if (Sets.isEmptyIntersection((Set)CifEventUtils.getAlphabet((Automaton)aut), this.controllableEvents)) {
            return;
        }
        Set<EventLoop> controllableEventLoops = EventLoopSearch.searchEventLoops(aut, this.controllableEvents, termination);
        if (termination.isRequested()) {
            return;
        }
        if (this.controllableEventsChanged) {
            this.controllableEventsChanged = false;
            BitSet bits = new BitSet(this.builder.cifVarInfoBuilder.varInfos.size());
            for (Event evt : this.controllableEvents) {
                for (Declaration var : this.eventVarUpdate.getOrDefault(evt, Sets.set())) {
                    VarInfo varInfo = this.builder.cifVarInfoBuilder.getVarInfo(var, 0);
                    bits.set(varInfo.level);
                }
            }
            this.nonCtrlIndependentVarsInfos = new VarInfo[bits.cardinality()];
            int nextFree = 0;
            int level = bits.nextSetBit(0);
            while (level >= 0) {
                this.nonCtrlIndependentVarsInfos[nextFree] = (VarInfo)this.builder.cifVarInfoBuilder.varInfos.get(level);
                ++nextFree;
                level = bits.nextSetBit(level + 1);
            }
        }
        if (termination.isRequested()) {
            return;
        }
        Set eventsInPotentialControllableLoops = Sets.set();
        if (!controllableEventLoops.isEmpty()) {
            dbg.line("The following events have been encountered in a controllable-event loop of automaton %s:", new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
            dbg.inc();
            for (EventLoop controllableEventLoop : controllableEventLoops) {
                if (this.isUnconnectable(controllableEventLoop, this.nonCtrlIndependentVarsInfos, termination)) {
                    dbg.line("%s, which is controllable unconnectable.", new Object[]{controllableEventLoop.toString()});
                } else {
                    dbg.line("%s, which is not controllable unconnectable.", new Object[]{controllableEventLoop.toString()});
                    eventsInPotentialControllableLoops.addAll(controllableEventLoop.events);
                }
                if (!termination.isRequested()) continue;
                dbg.dec();
                return;
            }
            dbg.dec();
        }
        Set eventsInAlphabetNotInLoop = Sets.difference((Collection)CifEventUtils.getAlphabet((Automaton)aut), (Collection)eventsInPotentialControllableLoops);
        this.controllableEventsChanged = this.controllableEvents.removeAll(eventsInAlphabetNotInLoop);
    }

    private boolean isUnconnectable(EventLoop controllableEventLoop, VarInfo[] nonCtrlIndependentVarsInfos, Termination termination) {
        Node n = Tree.ONE;
        for (Event evt : controllableEventLoop.events) {
            Node g = this.globalGuardsByEvent.get(evt);
            Node gAbstract = this.builder.tree.variableAbstractions(g, nonCtrlIndependentVarsInfos);
            if ((n = this.builder.tree.conjunct(n, gAbstract)) == Tree.ZERO) {
                return true;
            }
            if (!termination.isRequested()) continue;
            return false;
        }
        return false;
    }
}

