/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ocl;

import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibrariesRegistry;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibrariesRegistryImpl;
import org.osgi.framework.BundleContext;

public class OclQvtoPlugin
extends Plugin {
    private static final String LOGLEVEL_OPTION = "/loglevel";
    private static final String TRANSFORMATION_EP = "libraries";
    private final String SCHEMA_ID = "org.eclipse.m2m.qvt.oml.ocl";
    private static OclQvtoPlugin ourInstance;
    private final LibrariesRegistry myLibrariesRegistry;

    public OclQvtoPlugin() {
        ourInstance = this;
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.m2m.qvt.oml.ocl", TRANSFORMATION_EP);
        this.myLibrariesRegistry = new LibrariesRegistryImpl(configElements);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        String logLevelString = Platform.getDebugOption((String)(String.valueOf(this.getBundle().getSymbolicName()) + LOGLEVEL_OPTION));
        Logger.getLogger("org.eclipse.m2m.qvt.oml.ocl").setLevel(this.getLogLevel(logLevelString, Level.SEVERE));
        Logger.getLogger("org.eclipse.m2m.qvt.oml.ocl").addHandler(new PluginLogHandler());
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        ourInstance = null;
    }

    public static OclQvtoPlugin getDefault() {
        return ourInstance;
    }

    public LibrariesRegistry getLibrariesRegistry() {
        return this.myLibrariesRegistry;
    }

    private Level getLogLevel(String level, Level def) {
        if (level == null || level.trim().equals("")) {
            return def;
        }
        level = level.trim().toUpperCase();
        try {
            return Level.parse(level);
        }
        catch (IllegalArgumentException ie) {
            return def;
        }
    }

    private class PluginLogHandler
    extends StreamHandler {
        private PluginLogHandler() {
        }

        @Override
        public synchronized void publish(LogRecord record) {
            int severity = 0;
            if (record.getLevel() == Level.SEVERE) {
                severity = 4;
            } else if (record.getLevel() == Level.WARNING) {
                severity = 2;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.setOutputStream(outputStream);
            super.publish(record);
            super.close();
            OclQvtoPlugin.this.getLog().log((IStatus)new Status(severity, OclQvtoPlugin.this.getBundle().getSymbolicName(), 0, outputStream.toString(), record.getThrown()));
        }

        @Override
        public synchronized void flush() {
        }

        @Override
        public synchronized void close() throws SecurityException {
        }
    }
}

