/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui;

import java.util.EnumSet;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.ui.ElkUiPlugin;
import org.eclipse.elk.core.ui.Messages;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class LayoutOptionLabelProvider
extends LabelProvider {
    private final LayoutOptionData optionData;

    public LayoutOptionLabelProvider(LayoutOptionData optionData) {
        this.optionData = optionData;
    }

    public Image getImage(Object element) {
        ImageRegistry registry = ElkUiPlugin.getInstance().getImageRegistry();
        switch (this.optionData.getType()) {
            case STRING: 
            case OBJECT: {
                return registry.get("obj16/prop_text.gif");
            }
            case BOOLEAN: {
                boolean istrue = true;
                if (element instanceof Boolean) {
                    istrue = (Boolean)element;
                } else if (element instanceof Integer) {
                    boolean bl = istrue = (Integer)element == 1;
                }
                if (istrue) {
                    return registry.get("obj16/prop_true.gif");
                }
                return registry.get("obj16/prop_false.gif");
            }
            case ENUM: 
            case ENUMSET: {
                return registry.get("obj16/prop_choice.gif");
            }
            case INT: {
                return registry.get("obj16/prop_int.gif");
            }
            case DOUBLE: {
                return registry.get("obj16/prop_double.gif");
            }
        }
        return null;
    }

    public String getText(Object element) {
        switch (this.optionData.getType()) {
            case STRING: {
                if (!CoreOptions.ALGORITHM.equals(this.optionData)) break;
                LayoutMetaDataService layoutDataService = LayoutMetaDataService.getInstance();
                LayoutAlgorithmData algorithmData = layoutDataService.getAlgorithmData((String)element);
                if (algorithmData != null) {
                    String bundleName = algorithmData.getBundleName();
                    if (bundleName == null) {
                        return algorithmData.getName();
                    }
                    return String.valueOf(algorithmData.getName()) + " (" + bundleName + ")";
                }
                return Messages.getString("elk.ui.8");
            }
            case BOOLEAN: {
                if (element instanceof Boolean) {
                    return ((Boolean)element).toString();
                }
            }
            case ENUM: {
                if (!(element instanceof Integer)) break;
                return this.optionData.getChoices()[(Integer)element];
            }
            case ENUMSET: {
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof String[]) {
                    String[] arr = (String[])element;
                    if (arr.length == 0) {
                        return "";
                    }
                    StringBuilder builder = new StringBuilder();
                    String[] stringArray = arr;
                    int n = arr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        builder.append(", ").append(s);
                        ++n2;
                    }
                    return builder.substring(2);
                }
                if (!(element instanceof EnumSet)) break;
                EnumSet set = (EnumSet)element;
                if (set.isEmpty()) {
                    return "";
                }
                StringBuilder builder = new StringBuilder();
                for (Object o : set) {
                    builder.append(", " + ((Enum)o).name());
                }
                return builder.substring(2);
            }
        }
        return element.toString();
    }
}

