/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class PopUpHelper {
    private Shell shell;
    private LightweightSystem lws;
    private boolean tipShowing;
    protected Control control;
    protected final int shellStyle;

    protected PopUpHelper(Control c) {
        this(c, 16392);
    }

    protected PopUpHelper(Control c, int shellStyle) {
        this.control = c;
        this.shellStyle = shellStyle | 0x40000 | 0x100000;
    }

    protected LightweightSystem createLightweightSystem() {
        return new LightweightSystem();
    }

    protected Shell createShell() {
        return new Shell(this.control.getDisplay(), this.shellStyle);
    }

    public void dispose() {
        if (this.isShowing()) {
            this.hide();
        }
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    protected Shell getShell() {
        if (this.shell == null) {
            this.shell = this.createShell();
            this.hookShellListeners();
        }
        return this.shell;
    }

    protected Dimension getShellTrimSize() {
        Rectangle trim = this.shell.computeTrim(0, 0, 0, 0);
        return new Dimension(trim.width, trim.height);
    }

    protected LightweightSystem getLightweightSystem() {
        if (this.lws == null) {
            this.lws = this.createLightweightSystem();
            this.lws.setControl((Canvas)this.getShell());
        }
        return this.lws;
    }

    protected void hide() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.setVisible(false);
        }
        this.tipShowing = false;
    }

    protected abstract void hookShellListeners();

    public boolean isShowing() {
        return this.tipShowing;
    }

    public void setBackgroundColor(Color c) {
        this.getShell().setBackground(c);
    }

    public void setForegroundColor(Color c) {
        this.getShell().setForeground(c);
    }

    protected void setShellBounds(int x, int y, int width, int height) {
        this.getShell().setBounds(x, y, width, height);
    }

    protected void show() {
        this.getShell().setVisible(true);
        this.tipShowing = true;
    }
}

