# coding: utf-8

"""
    LSAT API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.5.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from lsat_client.models.lsat_base import LsatBase
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from lsat_client.models.motion_setting import MotionSetting
from lsat_client.models.path import Path
from lsat_client.models.timing_setting import TimingSetting
from typing import Optional, Set
from typing_extensions import Self

class Peripheral(LsatBase):
    """
    Peripheral
    """ # noqa: E501
    name: StrictStr
    peripheral_type: object = Field(default=None, repr=False)
    peripheral_type_id: StrictStr = Field(alias="peripheralTypeId")
    resource: object = Field(default=None, repr=False)
    resource_id: StrictStr = Field(alias="resourceId")
    profiles: Optional[List[StrictStr]] = None
    positions: Optional[Dict[str, Dict[str, Union[StrictFloat, StrictInt]]]] = None
    paths: Optional[List[Path]] = None
    distances: Optional[List[StrictStr]] = None
    motion_settings: Optional[Dict[str, MotionSetting]] = Field(default=None, alias="motionSettings")
    timing_settings: Optional[Dict[str, TimingSetting]] = Field(default=None, alias="timingSettings")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "peripheralTypeId", "resourceId", "profiles", "positions", "paths", "distances", "motionSettings", "timingSettings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Peripheral from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in paths (list)
        _items = []
        if self.paths:
            for _item_paths in self.paths:
                if _item_paths:
                    _items.append(_item_paths.to_dict())
            _dict['paths'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in motion_settings (dict)
        _field_dict = {}
        if self.motion_settings:
            for _key_motion_settings in self.motion_settings:
                if self.motion_settings[_key_motion_settings]:
                    _field_dict[_key_motion_settings] = self.motion_settings[_key_motion_settings].to_dict()
            _dict['motionSettings'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in timing_settings (dict)
        _field_dict = {}
        if self.timing_settings:
            for _key_timing_settings in self.timing_settings:
                if self.timing_settings[_key_timing_settings]:
                    _field_dict[_key_timing_settings] = self.timing_settings[_key_timing_settings].to_dict()
            _dict['timingSettings'] = _field_dict
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Peripheral from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "peripheralTypeId": obj.get("peripheralTypeId"),
            "resourceId": obj.get("resourceId"),
            "profiles": obj.get("profiles"),
            "positions": obj.get("positions"),
            "paths": [Path.from_dict(_item) for _item in obj["paths"]] if obj.get("paths") is not None else None,
            "distances": obj.get("distances"),
            "motionSettings": dict(
                (_k, MotionSetting.from_dict(_v))
                for _k, _v in obj["motionSettings"].items()
            )
            if obj.get("motionSettings") is not None
            else None,
            "timingSettings": dict(
                (_k, TimingSetting.from_dict(_v))
                for _k, _v in obj["timingSettings"].items()
            )
            if obj.get("timingSettings") is not None
            else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


