/**
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.activity.teditor.formatting2;

import activity.Activity
import activity.ActivitySet
import activity.Claim
import activity.Event
import activity.LocationPrerequisite
import activity.Move
import activity.RaiseEvent
import activity.Release
import activity.RequireEvent
import activity.SimpleAction
import com.google.inject.Inject
import common.Import
import org.eclipse.lsat.activity.teditor.services.ActivityGrammarAccess
import org.eclipse.lsat.common.graph.directed.editable.Edge
import org.eclipse.lsat.common.graph.directed.editable.Node
import org.eclipse.lsat.common.graph.directed.editable.SourceReference
import org.eclipse.lsat.common.graph.directed.editable.TargetReference
import org.eclipse.xtext.formatting2.AbstractFormatter2
import org.eclipse.xtext.formatting2.IFormattableDocument

import static activity.ActivityPackage.Literals.*

class ActivityFormatter extends AbstractFormatter2 {

    @Inject extension ActivityGrammarAccess

    def dispatch void format(ActivitySet activityset, extension IFormattableDocument document) {
        // Enable the line below to see the document's formatting elements.
        // println(textRegionAccess)
        for (Import imports : activityset.getImports()) {
            imports.prepend[noSpace]
        }
        for (Activity activities : activityset.getActivities()) {
            activities?.format
        }
        for (Event event : activityset.getEvents()) {
            event?.format
        }
    }

    def dispatch void format(LocationPrerequisite prerequisite, extension IFormattableDocument document) {
        prerequisite.prepend[newLine]
        prerequisite.regionFor.keyword(locationPrerequisiteAccess.atKeyword_4).surround[oneSpace]
    }

    def dispatch void format(Activity activity, extension IFormattableDocument document) {
        activity.prepend[newLines = 2]
        activity.regionFor.keyword(activityAccess.activityKeyword_0).append[oneSpace]
        

        val openActivity = activity.regionFor.keyword(activityAccess.leftCurlyBracketKeyword_3)
        val closeActivity = activity.regionFor.keyword(activityAccess.rightCurlyBracketKeyword_12)

        openActivity.surround[oneSpace]
        interior(openActivity, closeActivity)[indent]

        // Format prerequisites
        activity.regionFor.keyword(activityAccess.prerequisitesKeyword_4_0).prepend[newLine]
        val openPrerequisites = activity.regionFor.keyword(activityAccess.leftCurlyBracketKeyword_4_1)
        val closePrerequisites = activity.regionFor.keyword(activityAccess.rightCurlyBracketKeyword_4_3)
        
        openPrerequisites.prepend[oneSpace].append[newLine]
        closePrerequisites.prepend[newLine].append[newLine]
        interior(openPrerequisites,closePrerequisites)[indent]
        for (prerequisite : activity.prerequisites) {
            prerequisite?.format
        }
        
        // Format actions block.
        activity.regionFor.keyword(activityAccess.actionsKeyword_5).prepend[newLine]
        val openActions = activity.regionFor.keyword(activityAccess.leftCurlyBracketKeyword_6)
        val closeActions = activity.regionFor.keyword(activityAccess.rightCurlyBracketKeyword_8)

        openActions.prepend[oneSpace].append[newLine]
        closeActions.prepend[newLine].append[newLine]
        interior(openActions, closeActions)[indent]

        // Format action flow
        val openActionFlow = activity.regionFor.keyword(activityAccess.leftCurlyBracketKeyword_10)
        val closeActionFlow = activity.regionFor.keyword(activityAccess.rightCurlyBracketKeyword_12)

        openActionFlow.prepend[oneSpace].append[newLine]
        closeActionFlow.prepend[newLine].append[newLine]

        interior(openActionFlow, closeActionFlow)[indent]
        

        activity.regionFor.keyword(activityAccess.actionsKeyword_5).append[oneSpace]

        for (Node node : activity.getNodes()) {
            node.prepend[newLine]
            node?.format
        }

        for (Edge edge : activity.getEdges()) {
            edge.prepend[newLine]
            edge?.format
        }
    }

    def dispatch void format(Claim claim, extension IFormattableDocument document) {
        claim.regionFor.keyword(claimAccess.colonKeyword_2).prepend[noSpace].append[oneSpace]
        claim.regionFor.keyword(claimAccess.claimKeyword_5).surround[oneSpace]
        claim.regionFor.keyword(claimAccess.passivePassiveKeyword_4_0).surround[oneSpace]
        claim.regionFor.assignment(claimAccess.resourceDefinitionAssignment_6).prepend[oneSpace]
        claim.regionFor.assignment(claimAccess.resourceItemAssignment_7_1).surround[noSpace]
    }

    def dispatch void format(Release release, extension IFormattableDocument document) {
        release.regionFor.keyword(releaseAccess.colonKeyword_2).prepend[noSpace].append[oneSpace]
        release.regionFor.keyword(releaseAccess.releaseKeyword_4).surround[oneSpace]
        release.regionFor.assignment(releaseAccess.resourceDefinitionAssignment_5).prepend[oneSpace]
        release.regionFor.assignment(releaseAccess.resourceItemAssignment_6_1).surround[noSpace]
    }

    def dispatch void format(RequireEvent require, extension IFormattableDocument document) {
        require.regionFor.keyword(requireEventAccess.colonKeyword_2).prepend[noSpace].append[oneSpace]
        require.regionFor.keyword(requireEventAccess.requireKeyword_3).surround[oneSpace]
        require.regionFor.assignment(requireEventAccess.resourceDefinitionAssignment_4).surround[oneSpace]
    }

    def dispatch void format(RaiseEvent raise, extension IFormattableDocument document) {
        raise.regionFor.keyword(raiseEventAccess.colonKeyword_2).prepend[noSpace].append[oneSpace]
        raise.regionFor.keyword(raiseEventAccess.raiseKeyword_3).surround[oneSpace]
        raise.regionFor.assignment(raiseEventAccess.resourceDefinitionAssignment_4).prepend[oneSpace]
        raise.regionFor.assignment(raiseEventAccess.resourceItemAssignment_5_1).append[noSpace]
    }

    def dispatch void format(Event event, extension IFormattableDocument document) {
        event.prepend[newLines = 2]
        event.regionFor.keyword(eventAccess.eventKeyword_0).prepend[noSpace].append[oneSpace]
    }

    def dispatch void format(Move move, extension IFormattableDocument document) {
        move.regionFor.keyword(moveAccess.colonKeyword_2).prepend[noSpace].append[oneSpace]
        move.regionFor.keyword(moveAccess.moveKeyword_4).surround[oneSpace]
        move.regionFor.keyword(moveAccess.passingPassingKeyword_9_0_0_0_0).surround[oneSpace]
        move.regionFor.keyword(moveAccess.continuingContinuingKeyword_9_1_0_0_0).surround[oneSpace]
        move.regionFor.keyword(moveAccess.toKeyword_9_0_0_1).surround[oneSpace]
        move.regionFor.keyword(moveAccess.forKeyword_9_1_0_1).surround[oneSpace]
        move.regionFor.keyword(moveAccess.withSpeedProfileKeyword_10_0).surround[oneSpace]
        move.regionFor.ruleCall(moveAccess.schedulingTypeSchedulingEnumRuleCall_11_0).surround[oneSpace]
        move.regionFor.feature(MOVE__PROFILE).surround[oneSpace]
    }

     def dispatch void format(SimpleAction simpleaction, extension IFormattableDocument document) {
        simpleaction.regionFor.keyword(simpleActionAccess.colonKeyword_2).prepend[noSpace].append[oneSpace]
        simpleaction.regionFor.feature(SIMPLE_ACTION__TYPE).append[oneSpace]
        simpleaction.regionFor.keyword(simpleActionAccess.fullStopKeyword_4_1).surround[noSpace]
        simpleaction.regionFor.keyword(simpleActionAccess.fullStopKeyword_4_2_1).surround[noSpace]
    }

    def dispatch void format(Edge edge, extension IFormattableDocument document) {
        edge.regionFor.keyword(edgeAccess.hyphenMinusGreaterThanSignKeyword_2).prepend[oneSpace]
        
        edge.source?.format
        edge.target?.format
    }
    
    def dispatch void format(SourceReference sourceRef, extension IFormattableDocument document) {
        sourceRef.regionFor.keyword(sourceReferenceAccess.verticalLineKeyword_1_1_0).prepend[oneSpace].append[noSpace]
        sourceRef.regionFor.ruleCall(sourceReferenceAccess.nodeActionIDTerminalRuleCall_1_0_0_1).prepend[oneSpace]
    }
    
    def dispatch void format(TargetReference targetRef, extension IFormattableDocument document) {
        targetRef.regionFor.ruleCall(targetReferenceAccess.nodeActionIDTerminalRuleCall_1_0_0_1).prepend[oneSpace]
        targetRef.regionFor.keyword(targetReferenceAccess.verticalLineKeyword_1_1_0).prepend[oneSpace].append[noSpace]
    }
    
}
