/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.external.api;

import java.util.List;

/**
 * The External API of LSAT
 */
public interface LSATService {
    public static enum FileType {
        PROJECT, DISPATCH, SETTING, MACHINE, ACTIVITY;

        public String getExtension() {
            return toString().toLowerCase();
        }
    }

    public static enum TimingAnalysisGoal {
        NORMAL, CRITICAL_PATH, STOCHASTIC_IMPACT
    }

    public String timingAnalysis(String projectName, String dispatchFileName, String settingFileName,
            TimingAnalysisGoal goal, int stochasticSampleLength, boolean exportMotionPlots,
            int motionPlotSampleFrequency, String mmotionPlotFilter, boolean colorErroneousMoves, boolean debug)
            throws LSATException;

    public List<String> list(String projectName, FileType fileType) throws LSATException;

    public String reloadProject(String projectName) throws LSATException;

    public List<String> reloadAllProjects() throws LSATException;
}
