/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.semanticTokens;

import java.util.List;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.lsp4e.operations.semanticTokens.StyleRangeHolder;
import org.eclipse.lsp4e.test.utils.AbstractTest;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StyleRangeHolderTest
extends AbstractTest {
    private static final Color RED = new Color(255, 0, 0);
    private List<StyleRange> originalStyleRanges = List.of(new StyleRange(0, 4, RED, null), new StyleRange(15, 4, RED, null), new StyleRange(24, 7, RED, null));

    @Test
    public void testAllDocumentRanges() {
        StyleRangeHolder holder = new StyleRangeHolder();
        holder.saveStyles(this.originalStyleRanges);
        StyleRange[] allDocumentRanges = holder.overlappingRanges((IRegion)new Region(0, 50));
        Assertions.assertNotEquals(this.originalStyleRanges, (Object)allDocumentRanges);
        Assertions.assertEquals((int)this.originalStyleRanges.size(), (int)allDocumentRanges.length);
    }

    @Test
    public void testPartialDocumentRanges() {
        StyleRangeHolder holder = new StyleRangeHolder();
        holder.saveStyles(this.originalStyleRanges);
        StyleRange[] allDocumentRanges = holder.overlappingRanges((IRegion)new Region(0, 20));
        Assertions.assertEquals((int)2, (int)allDocumentRanges.length);
    }

    @Test
    public void testDocumentChange() {
        StyleRangeHolder holder = new StyleRangeHolder();
        holder.saveStyles(this.originalStyleRanges);
        TextEvent textEvent = new TextEvent(0, 1, " ", null, new DocumentEvent(), false){};
        holder.textChanged(textEvent);
        StyleRange[] noOverlappingRanges = holder.overlappingRanges((IRegion)new Region(0, 10));
        Assertions.assertEquals((int)0, (int)noOverlappingRanges.length);
        StyleRange[] twoShiftedOverlappingRanges = holder.overlappingRanges((IRegion)new Region(10, 50));
        Assertions.assertEquals((int)2, (int)twoShiftedOverlappingRanges.length);
        Assertions.assertEquals((int)16, (int)twoShiftedOverlappingRanges[0].start);
        Assertions.assertEquals((int)4, (int)twoShiftedOverlappingRanges[0].length);
        Assertions.assertEquals((int)25, (int)twoShiftedOverlappingRanges[1].start);
        Assertions.assertEquals((int)7, (int)twoShiftedOverlappingRanges[1].length);
    }
}

